/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.forester.archaeopteryx.Configuration;
import org.forester.archaeopteryx.MainPanel;
import org.forester.archaeopteryx.TreeColorSet;
import org.forester.archaeopteryx.TreePanel;

final class ColorSchemeChooser
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 6150960100859081126L;
    private final TreeColorSet _colorset;
    private final JComboBox _selector;
    private final JPanel _color_panel;
    private final JPanel[] _color_labels;
    private final JButton _ok_btn;
    private final JButton _cancel_btn;
    private final MainPanel _main_panel;
    private final int _prev_selected_scheme;
    private int _selected_scheme;

    ColorSchemeChooser(MainPanel mainPanel, TreeColorSet treeColorSet) {
        int n;
        this.setName("Color Scheme Chooser");
        this.setModal(true);
        this._colorset = treeColorSet;
        this._prev_selected_scheme = this._colorset.getCurrentColorScheme();
        this._main_panel = mainPanel;
        this.setSize(400, 350);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout(5, 15));
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel("Choose a color scheme:");
        jPanel.add(jLabel);
        Vector<String> vector = new Vector<String>();
        String[] stringArray = TreeColorSet.SCHEME_NAMES;
        int n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            String string = stringArray[n];
            vector.add(string);
        }
        this._selector = new JComboBox(vector);
        this._selector.setMaximumRowCount(vector.size());
        this._selector.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent listDataEvent) {
                int n = ColorSchemeChooser.this._selector.getSelectedIndex();
                ColorSchemeChooser.this.changeDialogColors(n);
            }

            @Override
            public void intervalAdded(ListDataEvent listDataEvent) {
            }

            @Override
            public void intervalRemoved(ListDataEvent listDataEvent) {
            }
        });
        jPanel.add(this._selector);
        container.add((Component)jPanel, "North");
        int n3 = TreeColorSet.COLOR_FIELDS.length;
        this._color_panel = new JPanel(new GridLayout(n3, 2, 8, 0));
        JLabel[] jLabelArray = new JLabel[n3];
        this._color_labels = new JPanel[n3];
        for (n = 0; n < n3; ++n) {
            jLabelArray[n] = new JLabel(TreeColorSet.COLOR_FIELDS[n]);
            jLabelArray[n].setFont(new Font(Configuration.getDefaultFontFamilyName(), 0, 9));
            jLabelArray[n].setHorizontalAlignment(4);
            this._color_panel.add(jLabelArray[n]);
            this._color_labels[n] = new JPanel();
            this._color_labels[n].setPreferredSize(new Dimension(15, 40));
            this._color_panel.add(this._color_labels[n]);
        }
        container.add((Component)this._color_panel, "Center");
        this.setColors(this._colorset.getColorSchemes()[0]);
        JPanel jPanel2 = new JPanel();
        this._ok_btn = new JButton("OK");
        this._ok_btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColorSchemeChooser.this.ok();
            }
        });
        jPanel2.add(this._ok_btn);
        this._cancel_btn = new JButton("Cancel");
        this._cancel_btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColorSchemeChooser.this.cancel();
            }
        });
        jPanel2.add(this._cancel_btn);
        jPanel2.setPreferredSize(new Dimension(400, 30));
        this.getContentPane().add((Component)jPanel2, "South");
        this.setCurrentColor(treeColorSet.getCurrentColorScheme());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    private void cancel() {
        this._colorset.setColorSchema(this._prev_selected_scheme);
        for (TreePanel treePanel : this.getMainPanel().getTreePanels()) {
            treePanel.setBackground(this._colorset.getBackgroundColor());
        }
        this.redrawTreePanel();
        this.setVisible(false);
        this.dispose();
    }

    private void changeDialogColors(int n) {
        this._selected_scheme = n;
        this.setColors(this._colorset.getColorSchemes()[n]);
        this._colorset.setColorSchema(this.getSelectedScheme());
        for (TreePanel treePanel : this.getMainPanel().getTreePanels()) {
            treePanel.setBackground(this._colorset.getBackgroundColor());
        }
        this.redrawTreePanel();
    }

    private MainPanel getMainPanel() {
        return this._main_panel;
    }

    private int getSelectedScheme() {
        return this._selected_scheme;
    }

    private void ok() {
        this._colorset.setColorSchema(this.getSelectedScheme());
        this.setVisible(false);
        this.dispose();
    }

    private void redrawTreePanel() {
        if (this.getMainPanel().getCurrentTreePanel() != null) {
            this.getMainPanel().getCurrentTreePanel().repaint();
        }
    }

    private void setColors(Color[] colorArray) {
        for (int i = 0; i < colorArray.length; ++i) {
            this._color_labels[i].setBackground(colorArray[i]);
        }
    }

    private void setCurrentColor(int n) {
        this.setColors(this._colorset.getColorSchemes()[n]);
        this._selector.setSelectedIndex(n);
    }
}

