/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.awt.Color;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.Property;

public class NodeVisualization
implements PhylogenyData {
    private NodeShape _shape;
    private NodeFill _fill_type;
    private Color _border_color;
    private Color _fill_color;
    private double _size;
    private double _transparancy;
    public static final String SIZE_REF = "aptx_visualiation:node_sise";
    public static final String SIZE_TYPE = "xsd:decimal";

    public NodeVisualization() {
        this.init();
    }

    public NodeVisualization(NodeShape nodeShape, NodeFill nodeFill, Color color, Color color2, double d, double d2) {
        this.setShape(nodeShape);
        this.setFillType(nodeFill);
        this.setBorderColor(color);
        this.setFillColor(color2);
        this.setSize(d);
        this.setTransparancy(d2);
    }

    @Override
    public StringBuffer asSimpleText() {
        return this.asText();
    }

    @Override
    public StringBuffer asText() {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer;
    }

    @Override
    public PhylogenyData copy() {
        return new NodeVisualization(this.getShape(), this.getFillType(), this.getBorderColor() != null ? new Color(this.getBorderColor().getRed(), this.getBorderColor().getGreen(), this.getBorderColor().getBlue()) : null, this.getFillColor() != null ? new Color(this.getFillColor().getRed(), this.getFillColor().getGreen(), this.getFillColor().getBlue()) : null, this.getSize(), this.getTransparancy());
    }

    public Color getBorderColor() {
        return this._border_color;
    }

    public Color getFillColor() {
        return this._fill_color;
    }

    public NodeFill getFillType() {
        return this._fill_type;
    }

    public NodeShape getShape() {
        return this._shape;
    }

    public double getSize() {
        return this._size;
    }

    public double getTransparancy() {
        return this._transparancy;
    }

    private void init() {
        this.setShape(NodeShape.CIRCLE);
        this.setFillType(NodeFill.SOLID);
        this.setBorderColor(null);
        this.setFillColor(null);
        this.setSize(0.0);
        this.setTransparancy(1.0);
    }

    @Override
    public boolean isEqual(PhylogenyData phylogenyData) {
        throw new UnsupportedOperationException();
    }

    public void setBorderColor(Color color) {
        this._border_color = color;
    }

    public void setFillColor(Color color) {
        this._fill_color = color;
    }

    public void setFillType(NodeFill nodeFill) {
        this._fill_type = nodeFill;
    }

    public void setShape(NodeShape nodeShape) {
        this._shape = nodeShape;
    }

    public void setSize(double d) {
        this._size = d;
    }

    public void setTransparancy(double d) {
        this._transparancy = d;
    }

    @Override
    public StringBuffer toNHX() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void toPhyloXML(Writer writer, int n, String string) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.asText().toString();
    }

    private List<Property> toProperties() {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        arrayList.add(new Property(SIZE_REF, String.valueOf(this.getSize()), "", SIZE_TYPE, Property.AppliesTo.NODE));
        arrayList.add(new Property(SIZE_REF, String.valueOf((Object)this.getShape()), "", SIZE_TYPE, Property.AppliesTo.NODE));
        arrayList.add(new Property(SIZE_REF, String.valueOf((Object)this.getFillType()), "", SIZE_TYPE, Property.AppliesTo.NODE));
        arrayList.add(new Property(SIZE_REF, String.valueOf(this.getTransparancy()), "", SIZE_TYPE, Property.AppliesTo.NODE));
        arrayList.add(new Property(SIZE_REF, String.valueOf(this.getFillColor()), "", SIZE_TYPE, Property.AppliesTo.NODE));
        arrayList.add(new Property(SIZE_REF, String.valueOf(this.getBorderColor()), "", SIZE_TYPE, Property.AppliesTo.NODE));
        return arrayList;
    }

    public static enum NodeShape {
        CIRCLE,
        RECTANGLE;

    }

    public static enum NodeFill {
        NONE,
        GRADIENT,
        SOLID;

    }
}

