/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.compiler.jdt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.AND_AND_Expression;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.AnnotationMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.ArrayReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.AssertStatement;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.BinaryExpression;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.BreakStatement;
import org.eclipse.jdt.internal.compiler.ast.CaseStatement;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.CharLiteral;
import org.eclipse.jdt.internal.compiler.ast.ClassLiteralAccess;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompoundAssignment;
import org.eclipse.jdt.internal.compiler.ast.ConditionalExpression;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ContinueStatement;
import org.eclipse.jdt.internal.compiler.ast.DoStatement;
import org.eclipse.jdt.internal.compiler.ast.DoubleLiteral;
import org.eclipse.jdt.internal.compiler.ast.EqualExpression;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ExtendedStringLiteral;
import org.eclipse.jdt.internal.compiler.ast.FalseLiteral;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.FloatLiteral;
import org.eclipse.jdt.internal.compiler.ast.ForStatement;
import org.eclipse.jdt.internal.compiler.ast.ForeachStatement;
import org.eclipse.jdt.internal.compiler.ast.IfStatement;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.InstanceOfExpression;
import org.eclipse.jdt.internal.compiler.ast.IntLiteral;
import org.eclipse.jdt.internal.compiler.ast.Javadoc;
import org.eclipse.jdt.internal.compiler.ast.LabeledStatement;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LongLiteral;
import org.eclipse.jdt.internal.compiler.ast.MarkerAnnotation;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.NormalAnnotation;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.ast.OR_OR_Expression;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.PostfixExpression;
import org.eclipse.jdt.internal.compiler.ast.PrefixExpression;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedSuperReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedThisReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ReferenceExpression;
import org.eclipse.jdt.internal.compiler.ast.ReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.SingleMemberAnnotation;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.eclipse.jdt.internal.compiler.ast.StringLiteralConcatenation;
import org.eclipse.jdt.internal.compiler.ast.SuperReference;
import org.eclipse.jdt.internal.compiler.ast.SwitchStatement;
import org.eclipse.jdt.internal.compiler.ast.SynchronizedStatement;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.ast.ThrowStatement;
import org.eclipse.jdt.internal.compiler.ast.TrueLiteral;
import org.eclipse.jdt.internal.compiler.ast.TryStatement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.UnaryExpression;
import org.eclipse.jdt.internal.compiler.ast.UnionTypeReference;
import org.eclipse.jdt.internal.compiler.ast.WhileStatement;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.jdt.internal.compiler.lookup.CatchParameterBinding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtAnnotationFieldAccess;
import spoon.reflect.code.CtArrayAccess;
import spoon.reflect.code.CtAssert;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtBreak;
import spoon.reflect.code.CtCase;
import spoon.reflect.code.CtCatch;
import spoon.reflect.code.CtCatchVariable;
import spoon.reflect.code.CtConditional;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtContinue;
import spoon.reflect.code.CtDo;
import spoon.reflect.code.CtExecutableReferenceExpression;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtForEach;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.code.CtOperatorAssignment;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtSuperAccess;
import spoon.reflect.code.CtSwitch;
import spoon.reflect.code.CtSynchronized;
import spoon.reflect.code.CtTargetedExpression;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.code.CtThrow;
import spoon.reflect.code.CtTry;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtWhile;
import spoon.reflect.code.UnaryOperatorKind;
import spoon.reflect.cu.CompilationUnit;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtAnonymousExecutable;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypedElement;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.factory.CoreFactory;
import spoon.reflect.factory.Factory;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtCatchVariableReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtLocalVariableReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtParameterReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtVariableReference;
import spoon.reflect.visitor.Query;
import spoon.reflect.visitor.filter.TypeFilter;
import spoon.support.compiler.jdt.ParentExiter;
import spoon.support.reflect.reference.CtUnboundVariableReferenceImpl;

public class JDTTreeBuilder
extends ASTVisitor {
    private static final Logger logger = Logger.getLogger(JDTTreeBuilder.class);
    BuilderContext context = new BuilderContext();
    ParentExiter exiter = new ParentExiter(this);
    Factory factory;
    ReferenceBuilder references = new ReferenceBuilder();
    public boolean template = false;
    boolean skipTypeInAnnotation = false;

    private String createTypeName(char[][] typeName) {
        String s = "";
        for (int i = 0; i < typeName.length - 1; ++i) {
            s = s + new String(typeName[i]) + ".";
        }
        s = s + new String(typeName[typeName.length - 1]);
        return s;
    }

    public static String cleanJavadoc(String doc) {
        StringBuffer ret = new StringBuffer();
        String[] lines = doc.split("\n");
        if (lines.length == 1) {
            return lines[0].replaceAll("^/\\*+", "").replaceAll("\\*+/$", "");
        }
        for (String s : lines) {
            if (s.startsWith("/**")) {
                ret.append(s.replaceAll("/\\*+", ""));
            } else if (s.endsWith("*/")) {
                ret.append(s.replaceAll("\\*+/$", "").replaceAll("^ *\\*+", ""));
            } else {
                ret.append(s.replaceAll("^ *\\*+", ""));
            }
            ret.append("\n");
        }
        StringBuffer ret2 = new StringBuffer();
        for (int i = 0; i < ret.length(); ++i) {
            if (ret.charAt(i) == '\r') continue;
            ret2.append(ret.charAt(i));
        }
        return ret2.toString();
    }

    public static Set<ModifierKind> getModifiers(int mod) {
        TreeSet<ModifierKind> ret = new TreeSet<ModifierKind>();
        if ((mod & 1) != 0) {
            ret.add(ModifierKind.PUBLIC);
        }
        if ((mod & 2) != 0) {
            ret.add(ModifierKind.PRIVATE);
        }
        if ((mod & 4) != 0) {
            ret.add(ModifierKind.PROTECTED);
        }
        if ((mod & 8) != 0) {
            ret.add(ModifierKind.STATIC);
        }
        if ((mod & 0x10) != 0) {
            ret.add(ModifierKind.FINAL);
        }
        if ((mod & 0x20) != 0) {
            ret.add(ModifierKind.SYNCHRONIZED);
        }
        if ((mod & 0x40) != 0) {
            ret.add(ModifierKind.VOLATILE);
        }
        if ((mod & 0x80) != 0) {
            ret.add(ModifierKind.TRANSIENT);
        }
        if ((mod & 0x400) != 0) {
            ret.add(ModifierKind.ABSTRACT);
        }
        if ((mod & 0x800) != 0) {
            ret.add(ModifierKind.STRICTFP);
        }
        if ((mod & 0x100) != 0) {
            ret.add(ModifierKind.NATIVE);
        }
        return ret;
    }

    public static final int searchLineNumber(int[] startLineIndexes, int position) {
        if (startLineIndexes == null) {
            return 1;
        }
        int length = startLineIndexes.length;
        if (length == 0) {
            return 1;
        }
        int g = 0;
        int d = length - 1;
        int m = 0;
        while (g <= d) {
            m = (g + d) / 2;
            int start = startLineIndexes[m];
            if (position < start) {
                d = m - 1;
                continue;
            }
            if (position > start) {
                g = m + 1;
                continue;
            }
            return m + 1;
        }
        if (position < startLineIndexes[m]) {
            return m + 1;
        }
        return m + 2;
    }

    public JDTTreeBuilder(Factory factory) {
        this.factory = factory;
    }

    private void createExpression(StringLiteralConcatenation literal, BlockScope scope, List<Expression> rst) {
        if (rst.isEmpty()) {
            return;
        }
        rst.get(0).traverse((ASTVisitor)this, scope);
        rst.remove(0);
        if (rst.size() > 1) {
            CtBinaryOperator op = this.factory.Core().createBinaryOperator();
            op.setKind(BinaryOperatorKind.PLUS);
            this.context.enter(op, literal);
            this.createExpression(literal, scope, rst);
            this.context.exit(literal);
        } else {
            this.createExpression(literal, scope, rst);
        }
    }

    CtType<?> createType(TypeDeclaration typeDeclaration) {
        CtType type = null;
        if ((typeDeclaration.modifiers & 0x2000) != 0) {
            type = this.factory.Core().createAnnotationType();
        } else if ((typeDeclaration.modifiers & 0x4000) != 0) {
            CtEnum e = this.factory.Core().createEnum();
            if (typeDeclaration.superInterfaces != null) {
                for (TypeReference typeReference : typeDeclaration.superInterfaces) {
                    e.addSuperInterface(this.references.getTypeReference(typeReference.resolvedType));
                }
            }
            type = e;
        } else if ((typeDeclaration.modifiers & 0x200) != 0) {
            CtInterface interf = this.factory.Core().createInterface();
            if (typeDeclaration.superInterfaces != null) {
                for (Statement statement : typeDeclaration.superInterfaces) {
                    interf.addSuperInterface(this.references.getTypeReference(((TypeReference)statement).resolvedType));
                }
            }
            if (typeDeclaration.typeParameters != null) {
                for (Statement statement : typeDeclaration.typeParameters) {
                    interf.addFormalTypeParameter(this.references.getBoundedTypeReference(((TypeParameter)statement).binding));
                }
            }
            type = interf;
        } else {
            CtClass cl = this.factory.Core().createClass();
            if (typeDeclaration.superclass != null) {
                cl.setSuperclass(this.references.getTypeReference(typeDeclaration.superclass.resolvedType));
            }
            if (typeDeclaration.binding.isAnonymousType() && typeDeclaration.superInterfaces != null) {
                TypeReference superInterface = typeDeclaration.superInterfaces[0];
                if (superInterface.resolvedType instanceof ParameterizedTypeBinding) {
                    ParameterizedTypeBinding resolvedType = (ParameterizedTypeBinding)superInterface.resolvedType;
                    if (resolvedType.arguments != null) {
                        for (TypeBinding b : resolvedType.arguments) {
                            cl.addFormalTypeParameter(this.references.getTypeReference(b));
                        }
                    }
                }
            }
            if (typeDeclaration.superInterfaces != null) {
                for (Statement statement : typeDeclaration.superInterfaces) {
                    cl.addSuperInterface(this.references.getTypeReference(((TypeReference)statement).resolvedType));
                }
            }
            if (typeDeclaration.typeParameters != null) {
                for (Statement statement : typeDeclaration.typeParameters) {
                    cl.addFormalTypeParameter(this.references.getBoundedTypeReference(((TypeParameter)statement).binding));
                }
            }
            type = cl;
        }
        if (type instanceof CtClass) {
            if (typeDeclaration.binding.isAnonymousType()) {
                type.setSimpleName(this.computeAnonymousName(typeDeclaration.binding));
            } else {
                type.setSimpleName(new String(typeDeclaration.name));
            }
        } else {
            type.setSimpleName(new String(typeDeclaration.name));
        }
        type.setModifiers(JDTTreeBuilder.getModifiers(typeDeclaration.modifiers));
        return type;
    }

    private String computeAnonymousName(SourceTypeBinding binding) {
        String poolName = String.valueOf(binding.constantPoolName());
        int lastIndexSeparator = poolName.lastIndexOf("$");
        return poolName.substring(lastIndexSeparator + 1, lastIndexSeparator + 2);
    }

    @Override
    public void endVisit(AllocationExpression allocationExpression, BlockScope scope) {
        this.context.exit(allocationExpression);
    }

    @Override
    public void endVisit(AND_AND_Expression and_and_Expression, BlockScope scope) {
        this.context.exit(and_and_Expression);
    }

    @Override
    public void endVisit(AnnotationMethodDeclaration annotationTypeDeclaration, ClassScope classScope) {
        this.context.exit(annotationTypeDeclaration);
    }

    @Override
    public void endVisit(Argument argument, BlockScope scope) {
        this.context.exit(argument);
    }

    @Override
    public void endVisit(ArrayAllocationExpression arrayAllocationExpression, BlockScope scope) {
        this.context.exit(arrayAllocationExpression);
    }

    @Override
    public void endVisit(ArrayInitializer arrayInitializer, BlockScope scope) {
        this.context.exit(arrayInitializer);
    }

    @Override
    public void endVisit(ArrayReference arrayReference, BlockScope scope) {
        this.context.exit(arrayReference);
    }

    @Override
    public void endVisit(ArrayTypeReference arrayTypeReference, BlockScope scope) {
        this.context.exit(arrayTypeReference);
    }

    @Override
    public void endVisit(AssertStatement assertStatement, BlockScope scope) {
        this.context.exit(assertStatement);
    }

    @Override
    public void endVisit(Assignment assignment, BlockScope scope) {
        this.context.exit(assignment);
    }

    @Override
    public void endVisit(BinaryExpression binaryExpression, BlockScope scope) {
        this.context.exit(binaryExpression);
    }

    @Override
    public void endVisit(Block block, BlockScope scope) {
        this.context.exit(block);
    }

    @Override
    public void endVisit(BreakStatement breakStatement, BlockScope scope) {
        this.context.exit(breakStatement);
    }

    @Override
    public void endVisit(CaseStatement caseStatement, BlockScope scope) {
        this.context.exit(caseStatement);
    }

    @Override
    public void endVisit(CharLiteral charLiteral, BlockScope scope) {
        this.context.exit(charLiteral);
    }

    @Override
    public void endVisit(ClassLiteralAccess classLiteral, BlockScope scope) {
        this.context.exit(classLiteral);
    }

    @Override
    public void endVisit(CompoundAssignment compoundAssignment, BlockScope scope) {
        this.context.exit(compoundAssignment);
    }

    @Override
    public void endVisit(ConditionalExpression conditionalExpression, BlockScope scope) {
        this.context.exit(conditionalExpression);
    }

    @Override
    public void endVisit(ConstructorDeclaration constructorDeclaration, ClassScope scope) {
        this.context.exit(constructorDeclaration);
        if (this.context.stack.peek().node == constructorDeclaration) {
            this.context.exit(constructorDeclaration);
        }
    }

    @Override
    public void endVisit(ContinueStatement continueStatement, BlockScope scope) {
        this.context.exit(continueStatement);
    }

    @Override
    public void endVisit(DoStatement doStatement, BlockScope scope) {
        this.context.exit(doStatement);
    }

    @Override
    public void endVisit(DoubleLiteral doubleLiteral, BlockScope scope) {
        this.context.exit(doubleLiteral);
    }

    @Override
    public void endVisit(EqualExpression equalExpression, BlockScope scope) {
        this.context.exit(equalExpression);
    }

    @Override
    public void endVisit(ExplicitConstructorCall explicitConstructor, BlockScope scope) {
        this.context.exit(explicitConstructor);
    }

    @Override
    public void endVisit(ExtendedStringLiteral extendedStringLiteral, BlockScope scope) {
        this.context.exit(extendedStringLiteral);
    }

    @Override
    public void endVisit(FalseLiteral falseLiteral, BlockScope scope) {
        this.context.exit(falseLiteral);
    }

    @Override
    public void endVisit(FieldDeclaration fieldDeclaration, MethodScope scope) {
        this.context.exit(fieldDeclaration);
    }

    @Override
    public void endVisit(FieldReference fieldReference, BlockScope scope) {
        this.context.exit(fieldReference);
    }

    @Override
    public void endVisit(FloatLiteral floatLiteral, BlockScope scope) {
        this.context.exit(floatLiteral);
    }

    @Override
    public void endVisit(ForeachStatement forStatement, BlockScope scope) {
        this.context.exit(forStatement);
    }

    @Override
    public void endVisit(ForStatement forStatement, BlockScope scope) {
        this.context.exit(forStatement);
    }

    @Override
    public void endVisit(IfStatement ifStatement, BlockScope scope) {
        this.context.exit(ifStatement);
    }

    @Override
    public void endVisit(Initializer initializer, MethodScope scope) {
        this.context.exit(initializer);
    }

    @Override
    public void endVisit(InstanceOfExpression instanceOfExpression, BlockScope scope) {
        this.context.exit(instanceOfExpression);
    }

    @Override
    public void endVisit(IntLiteral intLiteral, BlockScope scope) {
        this.context.exit(intLiteral);
    }

    @Override
    public void endVisit(LocalDeclaration localDeclaration, BlockScope scope) {
        this.context.exit(localDeclaration);
    }

    @Override
    public void endVisit(LongLiteral longLiteral, BlockScope scope) {
        this.context.exit(longLiteral);
    }

    @Override
    public void endVisit(MarkerAnnotation annotation, BlockScope scope) {
        this.context.exit(annotation);
        this.skipTypeInAnnotation = false;
    }

    @Override
    public void endVisit(MemberValuePair pair, BlockScope scope) {
        if (!this.context.annotationValueName.pop().equals(new String(pair.name))) {
            throw new RuntimeException("Unconsistant Stack");
        }
    }

    @Override
    public void endVisit(MessageSend messageSend, BlockScope scope) {
        this.context.exit(messageSend);
    }

    @Override
    public void endVisit(MethodDeclaration methodDeclaration, ClassScope scope) {
        this.context.exit(methodDeclaration);
        if (this.context.stack.peek().node == methodDeclaration) {
            this.context.exit(methodDeclaration);
        }
    }

    @Override
    public void endVisit(NormalAnnotation annotation, BlockScope scope) {
        this.context.exit(annotation);
        this.skipTypeInAnnotation = false;
    }

    @Override
    public void endVisit(NullLiteral nullLiteral, BlockScope scope) {
        this.context.exit(nullLiteral);
    }

    @Override
    public void endVisit(OR_OR_Expression or_or_Expression, BlockScope scope) {
        this.context.exit(or_or_Expression);
    }

    @Override
    public void endVisit(ParameterizedQualifiedTypeReference parameterizedQualifiedTypeReference, ClassScope scope) {
        if (this.skipTypeInAnnotation) {
            this.skipTypeInAnnotation = false;
            return;
        }
        this.context.exit(parameterizedQualifiedTypeReference);
    }

    @Override
    public void endVisit(ParameterizedSingleTypeReference parameterizedSingleTypeReference, BlockScope scope) {
        if (this.skipTypeInAnnotation) {
            this.skipTypeInAnnotation = false;
            return;
        }
        this.context.exit(parameterizedSingleTypeReference);
    }

    @Override
    public void endVisit(ParameterizedSingleTypeReference parameterizedSingleTypeReference, ClassScope scope) {
        if (this.skipTypeInAnnotation) {
            this.skipTypeInAnnotation = false;
            return;
        }
        this.context.exit(parameterizedSingleTypeReference);
    }

    @Override
    public void endVisit(PostfixExpression postfixExpression, BlockScope scope) {
        this.context.exit(postfixExpression);
    }

    @Override
    public void endVisit(PrefixExpression prefixExpression, BlockScope scope) {
        this.context.exit(prefixExpression);
    }

    @Override
    public void endVisit(QualifiedAllocationExpression qualifiedAllocationExpression, BlockScope scope) {
        this.endVisit((AllocationExpression)qualifiedAllocationExpression, scope);
    }

    @Override
    public void endVisit(QualifiedNameReference qualifiedNameReference, BlockScope scope) {
        if (this.context.stack.peek().node == qualifiedNameReference) {
            this.context.exit(qualifiedNameReference);
        }
    }

    @Override
    public void endVisit(QualifiedThisReference qualifiedThisReference, BlockScope scope) {
        this.endVisit((ThisReference)qualifiedThisReference, scope);
    }

    @Override
    public void endVisit(QualifiedTypeReference arg0, BlockScope arg1) {
        if (this.skipTypeInAnnotation) {
            this.skipTypeInAnnotation = false;
            return;
        }
        this.context.exit(arg0);
    }

    @Override
    public void endVisit(ReturnStatement returnStatement, BlockScope scope) {
        this.context.exit(returnStatement);
    }

    @Override
    public void endVisit(SingleMemberAnnotation annotation, BlockScope scope) {
        if (!this.context.annotationValueName.pop().equals("value")) {
            throw new RuntimeException("unconsistant Stack");
        }
        this.context.exit(annotation);
        this.skipTypeInAnnotation = false;
    }

    @Override
    public void endVisit(SingleNameReference singleNameReference, BlockScope scope) {
        if (this.context.stack.peek().node == singleNameReference) {
            this.context.exit(singleNameReference);
        }
    }

    @Override
    public void endVisit(SingleTypeReference singleTypeReference, BlockScope scope) {
        if (this.skipTypeInAnnotation) {
            this.skipTypeInAnnotation = false;
            return;
        }
        this.context.exit(singleTypeReference);
    }

    @Override
    public void endVisit(SingleTypeReference singleTypeReference, ClassScope scope) {
        this.context.exit(singleTypeReference);
    }

    @Override
    public void endVisit(StringLiteral stringLiteral, BlockScope scope) {
        this.context.exit(stringLiteral);
    }

    @Override
    public void endVisit(StringLiteralConcatenation literal, BlockScope scope) {
        this.context.exit(literal);
    }

    @Override
    public void endVisit(QualifiedSuperReference qualifiedsuperReference, BlockScope scope) {
        this.context.exit(qualifiedsuperReference);
    }

    @Override
    public void endVisit(SuperReference superReference, BlockScope scope) {
        this.context.exit(superReference);
    }

    @Override
    public void endVisit(SwitchStatement switchStatement, BlockScope scope) {
        this.context.exit(switchStatement);
    }

    @Override
    public void endVisit(SynchronizedStatement synchronizedStatement, BlockScope scope) {
        this.context.exit(synchronizedStatement);
    }

    @Override
    public void endVisit(ThisReference thisReference, BlockScope scope) {
        this.context.exit(thisReference);
    }

    @Override
    public void endVisit(ThrowStatement throwStatement, BlockScope scope) {
        this.context.exit(throwStatement);
    }

    @Override
    public void endVisit(TrueLiteral trueLiteral, BlockScope scope) {
        this.context.exit(trueLiteral);
    }

    @Override
    public void endVisit(TryStatement tryStatement, BlockScope scope) {
        this.context.exit(tryStatement);
    }

    @Override
    public void endVisit(TypeDeclaration localTypeDeclaration, BlockScope scope) {
        this.context.exit(localTypeDeclaration);
    }

    @Override
    public void endVisit(TypeDeclaration memberTypeDeclaration, ClassScope scope) {
        while (!this.context.stack.isEmpty() && this.context.stack.peek().node == memberTypeDeclaration) {
            this.context.exit(memberTypeDeclaration);
        }
    }

    @Override
    public void endVisit(TypeDeclaration typeDeclaration, CompilationUnitScope scope) {
        while (!this.context.stack.isEmpty() && this.context.stack.peek().node == typeDeclaration) {
            this.context.exit(typeDeclaration);
        }
        this.context.compilationunitdeclaration = null;
    }

    @Override
    public void endVisit(UnaryExpression unaryExpression, BlockScope scope) {
        this.context.exit(unaryExpression);
    }

    @Override
    public void endVisit(WhileStatement whileStatement, BlockScope scope) {
        this.context.exit(whileStatement);
    }

    BinaryOperatorKind getBinaryOperatorKind(int bits) {
        switch (bits) {
            case 18: {
                return BinaryOperatorKind.EQ;
            }
            case 5: {
                return BinaryOperatorKind.LE;
            }
            case 7: {
                return BinaryOperatorKind.GE;
            }
            case 29: {
                return BinaryOperatorKind.NE;
            }
            case 10: {
                return BinaryOperatorKind.SL;
            }
            case 17: {
                return BinaryOperatorKind.SR;
            }
            case 19: {
                return BinaryOperatorKind.USR;
            }
            case 1: {
                return BinaryOperatorKind.OR;
            }
            case 0: {
                return BinaryOperatorKind.AND;
            }
            case 14: {
                return BinaryOperatorKind.PLUS;
            }
            case 13: {
                return BinaryOperatorKind.MINUS;
            }
            case 11: {
                return BinaryOperatorKind.NE;
            }
            case 16: {
                return BinaryOperatorKind.MOD;
            }
            case 8: {
                return BinaryOperatorKind.BITXOR;
            }
            case 2: {
                return BinaryOperatorKind.BITAND;
            }
            case 15: {
                return BinaryOperatorKind.MUL;
            }
            case 3: {
                return BinaryOperatorKind.BITOR;
            }
            case 9: {
                return BinaryOperatorKind.DIV;
            }
            case 6: {
                return BinaryOperatorKind.GT;
            }
            case 4: {
                return BinaryOperatorKind.LT;
            }
            case 23: {
                throw new RuntimeException("Unknown operator");
            }
            case 30: {
                return BinaryOperatorKind.EQ;
            }
        }
        return null;
    }

    public List<CtType<?>> getCreatedTypes() {
        return this.context.getCreatedTypes();
    }

    public String getJavaDoc(Javadoc javadoc, CompilationUnitDeclaration declaration) {
        if (javadoc != null) {
            try {
                String s = new String(declaration.compilationResult.compilationUnit.getContents(), javadoc.sourceStart, javadoc.sourceEnd - javadoc.sourceStart + 1);
                return JDTTreeBuilder.cleanJavadoc(s);
            }
            catch (StringIndexOutOfBoundsException e) {
                return null;
            }
        }
        return null;
    }

    protected <T> CtLocalVariable<T> getLocalVariableDeclaration(final String name) {
        ArrayList<CtElement> reversedElements = new ArrayList<CtElement>();
        for (ASTPair aSTPair : this.context.stack) {
            reversedElements.add(0, aSTPair.element);
        }
        for (CtElement ctElement : reversedElements) {
            List var = Query.getElements(ctElement, new TypeFilter<CtLocalVariable<T>>(CtLocalVariable.class){

                @Override
                public boolean matches(CtLocalVariable<T> element) {
                    return name.equals(element.getSimpleName()) && super.matches(element);
                }
            });
            if (var.size() <= 0) continue;
            return (CtLocalVariable)var.get(0);
        }
        logger.error("could not find declaration for local variable " + name + " at " + this.context.stack.peek().element.getPosition());
        return null;
    }

    protected <T> CtCatchVariable<T> getCatchVariableDeclaration(final String name) {
        ArrayList<CtElement> reversedElements = new ArrayList<CtElement>();
        for (ASTPair aSTPair : this.context.stack) {
            reversedElements.add(0, aSTPair.element);
        }
        for (CtElement ctElement : reversedElements) {
            List var = Query.getElements(ctElement, new TypeFilter<CtCatchVariable<T>>(CtCatchVariable.class){

                @Override
                public boolean matches(CtCatchVariable<T> element) {
                    return name.equals(element.getSimpleName()) && super.matches(element);
                }
            });
            if (var.size() <= 0) continue;
            return (CtCatchVariable)var.get(0);
        }
        logger.error("could not find declaration for catch variable " + name + " at " + this.context.stack.peek().element.getPosition());
        return null;
    }

    UnaryOperatorKind getUnaryOperator(int op) {
        switch (op) {
            case 14: {
                return UnaryOperatorKind.POS;
            }
            case 13: {
                return UnaryOperatorKind.NEG;
            }
            case 11: {
                return UnaryOperatorKind.NOT;
            }
            case 12: {
                return UnaryOperatorKind.COMPL;
            }
        }
        return null;
    }

    @Override
    public boolean visit(ReferenceExpression referenceExpression, BlockScope blockScope) {
        CtExecutableReferenceExpression executableRef = this.createExecutableReferenceExpression(referenceExpression);
        this.context.enter(executableRef, referenceExpression);
        return true;
    }

    private <T, E extends CtExpression<?>> CtExecutableReferenceExpression<T, E> createExecutableReferenceExpression(ReferenceExpression referenceExpression) {
        CtExecutableReferenceExpression executableRef = this.factory.Core().createExecutableReferenceExpression();
        CtExecutableReference<?> executableReference = this.references.getExecutableReference(referenceExpression.binding);
        executableReference.setType(executableReference.getDeclaringType());
        executableRef.setExecutable(executableReference);
        return executableRef;
    }

    @Override
    public void endVisit(ReferenceExpression referenceExpression, BlockScope blockScope) {
        this.context.exit(referenceExpression);
    }

    @Override
    public boolean visit(LambdaExpression lambdaExpression, BlockScope blockScope) {
        CtLambda lambda = this.factory.Core().createLambda();
        MethodBinding methodBinding = lambdaExpression.getMethodBinding();
        if (methodBinding != null) {
            lambda.setSimpleName(String.valueOf(methodBinding.constantPoolName()));
        }
        this.context.enter(lambda, lambdaExpression);
        Argument[] arguments = lambdaExpression.arguments();
        if (arguments != null && arguments.length > 0) {
            for (Argument e : arguments) {
                e.traverse((ASTVisitor)this, blockScope);
            }
        }
        if (lambdaExpression.body() != null) {
            lambdaExpression.body().traverse(this, blockScope);
        }
        return false;
    }

    @Override
    public void endVisit(LambdaExpression lambdaExpression, BlockScope blockScope) {
        this.context.exit(lambdaExpression);
    }

    @Override
    public boolean visit(AllocationExpression allocationExpression, BlockScope scope) {
        this.buildCommonPartForCtNewClassAndCtConstructorCall(allocationExpression, scope, this.factory.Core().createConstructorCall());
        return false;
    }

    private <T extends CtConstructorCall<Object>> T buildCommonPartForCtNewClassAndCtConstructorCall(AllocationExpression allocationExpression, BlockScope scope, T constructorCall) {
        if (allocationExpression.type != null) {
            if (allocationExpression.type.resolvedType instanceof ParameterizedTypeBinding) {
                CtTypeReference res = this.references.getTypeReference(((ParameterizedTypeBinding)allocationExpression.type.resolvedType).genericType());
                ParameterizedTypeBinding paramType = (ParameterizedTypeBinding)allocationExpression.type.resolvedType;
                if (paramType.arguments != null && paramType.isBoundParameterizedType()) {
                    for (TypeBinding b : ((ParameterizedTypeBinding)allocationExpression.type.resolvedType).arguments) {
                        res.addActualTypeArgument(this.references.getTypeReference(b));
                    }
                }
                constructorCall.setType(res);
            } else {
                constructorCall.setType(this.references.getTypeReference(allocationExpression.type.resolvedType));
            }
        } else if (allocationExpression.expectedType() != null) {
            constructorCall.setType(this.references.getTypeReference(allocationExpression.expectedType()));
        }
        constructorCall.setExecutable(this.references.getExecutableReference(allocationExpression.binding));
        if (constructorCall.getExecutable() != null) {
            constructorCall.getExecutable().setType(constructorCall.getExecutable().getDeclaringType());
        }
        this.context.enter((CtElement)constructorCall, allocationExpression);
        if (allocationExpression.enclosingInstance() != null) {
            this.context.target.push((CtTargetedExpression<?, ?>)constructorCall);
            allocationExpression.enclosingInstance().traverse((ASTVisitor)this, scope);
            this.context.target.pop();
        }
        this.context.pushArgument(constructorCall);
        if (allocationExpression.arguments != null) {
            for (Expression e : allocationExpression.arguments) {
                e.traverse((ASTVisitor)this, scope);
            }
        }
        this.context.popArgument(constructorCall);
        return (T)constructorCall;
    }

    @Override
    public boolean visit(AND_AND_Expression and_and_Expression, BlockScope scope) {
        CtBinaryOperator op = this.factory.Core().createBinaryOperator();
        op.setKind(this.getBinaryOperatorKind((and_and_Expression.bits & 0xFC0) >> 6));
        this.context.enter(op, and_and_Expression);
        return true;
    }

    @Override
    public boolean visit(AnnotationMethodDeclaration annotationTypeDeclaration, ClassScope classScope) {
        CtField f = this.factory.Core().createField();
        f.setSimpleName(new String(annotationTypeDeclaration.selector));
        f.setType(this.references.getTypeReference(annotationTypeDeclaration.binding.returnType));
        this.context.enter(f, annotationTypeDeclaration);
        if (annotationTypeDeclaration.annotations != null) {
            int annotationsLength = annotationTypeDeclaration.annotations.length;
            for (int i = 0; i < annotationsLength; ++i) {
                annotationTypeDeclaration.annotations[i].traverse((ASTVisitor)this, annotationTypeDeclaration.scope);
            }
        }
        if (annotationTypeDeclaration.defaultValue != null) {
            annotationTypeDeclaration.defaultValue.traverse((ASTVisitor)this, annotationTypeDeclaration.scope);
        }
        return false;
    }

    @Override
    public boolean visit(Argument argument, BlockScope scope) {
        CtParameter p = this.factory.Core().createParameter();
        p.setSimpleName(new String(argument.name));
        p.setVarArgs(argument.isVarArgs());
        p.setModifiers(JDTTreeBuilder.getModifiers(argument.modifiers));
        if (argument.type != null) {
            p.setType(this.references.getTypeReference(argument.type.resolvedType));
        } else if (argument.binding != null && argument.binding.type != null) {
            p.setType(this.references.getTypeReference(argument.binding.type));
        }
        this.context.enter(p, argument);
        if (argument.initialization != null) {
            argument.initialization.traverse((ASTVisitor)this, scope);
        }
        if (argument.annotations != null) {
            for (Annotation a : argument.annotations) {
                if (!this.isContainsInTypeAnnotation(argument.type.resolvedType, a)) continue;
                a.traverse((ASTVisitor)this, scope);
            }
        }
        return false;
    }

    @Override
    public boolean visit(ArrayAllocationExpression arrayAllocationExpression, BlockScope scope) {
        CtNewArray array = this.factory.Core().createNewArray();
        array.setType(this.references.getTypeReference(arrayAllocationExpression.resolvedType));
        this.context.enter(array, arrayAllocationExpression);
        this.context.pushArgument(array);
        if (arrayAllocationExpression.dimensions != null) {
            for (Expression e : arrayAllocationExpression.dimensions) {
                if (e == null) continue;
                e.traverse((ASTVisitor)this, scope);
            }
        }
        this.context.popArgument(array);
        if (arrayAllocationExpression.initializer != null && arrayAllocationExpression.initializer.expressions != null) {
            for (Expression e : arrayAllocationExpression.initializer.expressions) {
                e.traverse((ASTVisitor)this, scope);
            }
        }
        return false;
    }

    @Override
    public boolean visit(ArrayInitializer arrayInitializer, BlockScope scope) {
        CtNewArray array = this.factory.Core().createNewArray();
        this.context.enter(array, arrayInitializer);
        return super.visit(arrayInitializer, scope);
    }

    @Override
    public boolean visit(ArrayReference arrayReference, BlockScope scope) {
        CtArrayAccess a = this.factory.Core().createArrayAccess();
        this.context.enter(a, arrayReference);
        arrayReference.receiver.traverse((ASTVisitor)this, scope);
        this.context.arguments.push(a);
        arrayReference.position.traverse((ASTVisitor)this, scope);
        this.context.arguments.pop();
        return false;
    }

    @Override
    public boolean visit(ArrayTypeReference arrayTypeReference, BlockScope scope) {
        CtLiteral l = this.factory.Core().createLiteral();
        l.setValue(this.references.getTypeReference(arrayTypeReference.resolvedType));
        this.context.enter(l, arrayTypeReference);
        return true;
    }

    @Override
    public boolean visit(AssertStatement assertStatement, BlockScope scope) {
        CtAssert a = this.factory.Core().createAssert();
        this.context.enter(a, assertStatement);
        assertStatement.assertExpression.traverse((ASTVisitor)this, scope);
        this.context.arguments.push(a);
        if (assertStatement.exceptionArgument != null) {
            assertStatement.exceptionArgument.traverse((ASTVisitor)this, scope);
        }
        this.context.arguments.pop();
        return false;
    }

    @Override
    public boolean visit(Assignment assignment, BlockScope scope) {
        CtAssignment assign = this.factory.Core().createAssignment();
        this.context.enter(assign, assignment);
        return true;
    }

    @Override
    public boolean visit(BinaryExpression binaryExpression, BlockScope scope) {
        CtBinaryOperator op = this.factory.Core().createBinaryOperator();
        op.setKind(this.getBinaryOperatorKind((binaryExpression.bits & 0xFC0) >> 6));
        this.context.enter(op, binaryExpression);
        return true;
    }

    @Override
    public boolean visit(Block block, BlockScope scope) {
        CtBlock b = this.factory.Core().createBlock();
        this.context.enter(b, block);
        return true;
    }

    @Override
    public boolean visit(BreakStatement breakStatement, BlockScope scope) {
        CtBreak b = this.factory.Core().createBreak();
        if (breakStatement.label != null) {
            b.setTargetLabel(new String(breakStatement.label));
        }
        this.context.enter(b, breakStatement);
        return true;
    }

    @Override
    public boolean visit(CaseStatement caseStatement, BlockScope scope) {
        CtCase c = this.factory.Core().createCase();
        this.context.enter(c, caseStatement);
        if (caseStatement.constantExpression != null) {
            this.context.selector = true;
            caseStatement.constantExpression.traverse((ASTVisitor)this, scope);
            this.context.selector = false;
        }
        return false;
    }

    @Override
    public boolean visit(CastExpression castExpression, BlockScope scope) {
        TypeBinding resolvedType = castExpression.resolvedType;
        CtTypeReference castReference = this.references.getTypeReference(resolvedType);
        this.context.casts.add(castReference);
        castExpression.expression.traverse((ASTVisitor)this, scope);
        return false;
    }

    @Override
    public boolean visit(CharLiteral charLiteral, BlockScope scope) {
        CtLiteral<Character> l = this.factory.Core().createLiteral();
        l.setValue(Character.valueOf(charLiteral.constant.charValue()));
        this.context.enter(l, charLiteral);
        return true;
    }

    @Override
    public boolean visit(ClassLiteralAccess classLiteral, BlockScope scope) {
        CtTypeReference ref = this.references.getTypeReference(classLiteral.targetType);
        CtFieldReference fr = this.factory.Core().createFieldReference();
        fr.setSimpleName("class");
        fr.setType(ref);
        fr.setDeclaringType(ref);
        CtFieldAccess fa = this.factory.Core().createFieldAccess();
        fa.setType(ref);
        fa.setVariable(fr);
        this.context.enter(fa, classLiteral);
        return true;
    }

    @Override
    public boolean visit(CompoundAssignment compoundAssignment, BlockScope scope) {
        CtOperatorAssignment a = this.factory.Core().createOperatorAssignment();
        a.setKind(this.getBinaryOperatorKind(compoundAssignment.operator));
        this.context.enter(a, compoundAssignment);
        return super.visit(compoundAssignment, scope);
    }

    @Override
    public boolean visit(ConditionalExpression conditionalExpression, BlockScope scope) {
        CtConditional c = this.factory.Core().createConditional();
        this.context.enter(c, conditionalExpression);
        return super.visit(conditionalExpression, scope);
    }

    @Override
    public boolean visit(ConstructorDeclaration constructorDeclaration, ClassScope scope) {
        int i;
        CtConstructor c = this.factory.Core().createConstructor();
        c.setModifiers(JDTTreeBuilder.getModifiers(constructorDeclaration.modifiers));
        c.setDocComment(this.getJavaDoc(constructorDeclaration.javadoc, scope.referenceCompilationUnit()));
        this.context.enter(c, constructorDeclaration);
        if (constructorDeclaration.annotations != null) {
            int annotationsLength = constructorDeclaration.annotations.length;
            for (i = 0; i < annotationsLength; ++i) {
                constructorDeclaration.annotations[i].traverse((ASTVisitor)this, constructorDeclaration.scope);
            }
        }
        this.context.pushArgument(c);
        if (constructorDeclaration.arguments != null) {
            int argumentLength = constructorDeclaration.arguments.length;
            for (i = 0; i < argumentLength; ++i) {
                constructorDeclaration.arguments[i].traverse((ASTVisitor)this, constructorDeclaration.scope);
            }
        }
        this.context.popArgument(c);
        if (constructorDeclaration.thrownExceptions != null) {
            for (TypeReference r : constructorDeclaration.thrownExceptions) {
                CtTypeReference tr = this.references.getTypeReference(r.resolvedType);
                c.addThrownType(tr);
            }
        }
        if (constructorDeclaration.binding != null) {
            for (TypeVariableBinding b : constructorDeclaration.binding.typeVariables) {
                c.addFormalTypeParameter(this.references.getBoundedTypeReference(b));
            }
        }
        if (!constructorDeclaration.isAbstract()) {
            CtBlock b = this.factory.Core().createBlock();
            this.context.enter(b, constructorDeclaration);
        }
        if (constructorDeclaration.constructorCall != null) {
            constructorDeclaration.constructorCall.traverse(this, constructorDeclaration.scope);
        }
        if (constructorDeclaration.statements != null) {
            for (Statement s : constructorDeclaration.statements) {
                s.traverse(this, constructorDeclaration.scope);
            }
        }
        return false;
    }

    @Override
    public boolean visit(ContinueStatement continueStatement, BlockScope scope) {
        CtContinue c = this.factory.Core().createContinue();
        this.context.enter(c, continueStatement);
        if (continueStatement.label != null) {
            c.setTargetLabel(new String(continueStatement.label));
        }
        return true;
    }

    @Override
    public boolean visit(DoStatement doStatement, BlockScope scope) {
        CtDo d = this.factory.Core().createDo();
        this.context.enter(d, doStatement);
        return true;
    }

    @Override
    public boolean visit(DoubleLiteral doubleLiteral, BlockScope scope) {
        CtLiteral<Double> d = this.factory.Core().createLiteral();
        d.setValue(doubleLiteral.constant.doubleValue());
        this.context.enter(d, doubleLiteral);
        return true;
    }

    @Override
    public boolean visit(EqualExpression equalExpression, BlockScope scope) {
        CtBinaryOperator op = this.factory.Core().createBinaryOperator();
        op.setKind(this.getBinaryOperatorKind((equalExpression.bits & 0xFC0) >> 6));
        this.context.enter(op, equalExpression);
        return true;
    }

    @Override
    public boolean visit(ExplicitConstructorCall explicitConstructor, BlockScope scope) {
        int i;
        CtInvocation inv = this.factory.Core().createInvocation();
        if (explicitConstructor.isImplicitSuper()) {
            inv.setImplicit(true);
        }
        CtExecutableReference er = this.references.getExecutableReference(explicitConstructor.binding);
        inv.setExecutable(er);
        inv.getExecutable().setType(inv.getExecutable().getDeclaringType());
        inv.setType(inv.getExecutable().getType());
        this.context.enter(inv, explicitConstructor);
        if (explicitConstructor.qualification != null) {
            explicitConstructor.qualification.traverse((ASTVisitor)this, scope);
        }
        if (explicitConstructor.typeArguments != null) {
            int typeArgumentsLength = explicitConstructor.typeArguments.length;
            for (i = 0; i < typeArgumentsLength; ++i) {
                explicitConstructor.typeArguments[i].traverse((ASTVisitor)this, scope);
            }
        }
        this.context.arguments.push(inv);
        if (explicitConstructor.arguments != null) {
            int argumentLength = explicitConstructor.arguments.length;
            for (i = 0; i < argumentLength; ++i) {
                explicitConstructor.arguments[i].traverse((ASTVisitor)this, scope);
            }
        }
        this.context.arguments.pop();
        return false;
    }

    @Override
    public boolean visit(ExtendedStringLiteral extendedStringLiteral, BlockScope scope) {
        CtLiteral<String> l = this.factory.Core().createLiteral();
        l.setValue(new String(extendedStringLiteral.source()));
        this.context.enter(l, extendedStringLiteral);
        return true;
    }

    @Override
    public boolean visit(FalseLiteral falseLiteral, BlockScope scope) {
        CtLiteral<Boolean> l = this.factory.Core().createLiteral();
        l.setValue(false);
        this.context.enter(l, falseLiteral);
        return true;
    }

    @Override
    public boolean visit(FieldDeclaration fieldDeclaration, MethodScope scope) {
        CtField field = this.factory.Core().createField();
        field.setSimpleName(new String(fieldDeclaration.name));
        if (fieldDeclaration.type != null) {
            field.setType(this.references.getTypeReference(fieldDeclaration.type.resolvedType));
        }
        field.setModifiers(JDTTreeBuilder.getModifiers(fieldDeclaration.modifiers));
        field.setDocComment(this.getJavaDoc(fieldDeclaration.javadoc, scope.referenceCompilationUnit()));
        this.context.enter(field, fieldDeclaration);
        if (fieldDeclaration.annotations != null) {
            int annotationsLength = fieldDeclaration.annotations.length;
            for (int i = 0; i < annotationsLength; ++i) {
                fieldDeclaration.annotations[i].traverse((ASTVisitor)this, scope);
            }
        }
        if (fieldDeclaration.initialization != null) {
            fieldDeclaration.initialization.traverse((ASTVisitor)this, scope);
        }
        return false;
    }

    @Override
    public boolean visit(FieldReference fieldReference, BlockScope scope) {
        CtFieldAccess acc = this.factory.Core().createFieldAccess();
        CtFieldReference variableReference = this.references.getVariableReference(fieldReference.binding);
        if (variableReference.getSimpleName() == null) {
            variableReference.setSimpleName(new String(fieldReference.token));
        }
        acc.setVariable(variableReference);
        acc.setType(this.references.getTypeReference(fieldReference.resolvedType));
        this.context.enter(acc, fieldReference);
        this.context.target.push(acc);
        fieldReference.receiver.traverse((ASTVisitor)this, scope);
        this.context.target.pop();
        return false;
    }

    @Override
    public boolean visit(FloatLiteral floatLiteral, BlockScope scope) {
        CtLiteral<Float> l = this.factory.Core().createLiteral();
        l.setValue(Float.valueOf(floatLiteral.constant.floatValue()));
        this.context.enter(l, floatLiteral);
        return true;
    }

    @Override
    public boolean visit(ForeachStatement forStatement, BlockScope scope) {
        CtForEach fe = this.factory.Core().createForEach();
        this.context.enter(fe, forStatement);
        return true;
    }

    @Override
    public boolean visit(ForStatement forStatement, BlockScope scope) {
        int i;
        CtFor for1 = this.factory.Core().createFor();
        this.context.enter(for1, forStatement);
        if (forStatement.initializations != null) {
            this.context.forinit = true;
            int initializationsLength = forStatement.initializations.length;
            for (i = 0; i < initializationsLength; ++i) {
                forStatement.initializations[i].traverse(this, scope);
            }
            this.context.forinit = false;
        }
        if (forStatement.condition != null) {
            forStatement.condition.traverse((ASTVisitor)this, scope);
        }
        if (forStatement.increments != null) {
            this.context.forupdate = true;
            int incrementsLength = forStatement.increments.length;
            for (i = 0; i < incrementsLength; ++i) {
                forStatement.increments[i].traverse(this, scope);
            }
            this.context.forupdate = false;
        }
        if (forStatement.action != null) {
            forStatement.action.traverse(this, scope);
        }
        return false;
    }

    @Override
    public boolean visit(IfStatement ifStatement, BlockScope scope) {
        CtIf ifs = this.factory.Core().createIf();
        this.context.enter(ifs, ifStatement);
        return super.visit(ifStatement, scope);
    }

    @Override
    public boolean visit(Initializer initializer, MethodScope scope) {
        CtAnonymousExecutable b = this.factory.Core().createAnonymousExecutable();
        if (initializer.isStatic()) {
            b.addModifier(ModifierKind.STATIC);
        }
        this.context.enter(b, initializer);
        return true;
    }

    @Override
    public boolean visit(InstanceOfExpression instanceOfExpression, BlockScope scope) {
        CtBinaryOperator op = this.factory.Core().createBinaryOperator();
        op.setKind(BinaryOperatorKind.INSTANCEOF);
        CtLiteral<CtTypeReference<?>> l = this.factory.Core().createLiteral();
        l.setValue(this.references.getBoundedTypeReference(instanceOfExpression.type.resolvedType));
        op.setRightHandOperand(l);
        l.setParent(op);
        this.context.enter(op, instanceOfExpression);
        return true;
    }

    @Override
    public boolean visit(IntLiteral intLiteral, BlockScope scope) {
        CtLiteral l = this.factory.Core().createLiteral();
        CtTypeReference r = this.references.getTypeReference(intLiteral.resolvedType);
        l.setType(r);
        l.setValue(intLiteral.constant.intValue());
        this.context.enter(l, intLiteral);
        return true;
    }

    @Override
    public boolean visit(LabeledStatement labeledStatement, BlockScope scope) {
        this.context.label.push(new String(labeledStatement.label));
        return true;
    }

    @Override
    public boolean visit(LocalDeclaration localDeclaration, BlockScope scope) {
        CtLocalVariable v = this.factory.Core().createLocalVariable();
        v.setSimpleName(new String(localDeclaration.name));
        v.setType(this.references.getTypeReference(localDeclaration.type.resolvedType));
        v.setModifiers(JDTTreeBuilder.getModifiers(localDeclaration.modifiers));
        this.context.enter(v, localDeclaration);
        if (localDeclaration.initialization != null) {
            this.context.arguments.push(v);
            localDeclaration.initialization.traverse((ASTVisitor)this, scope);
            this.context.arguments.pop();
        }
        if (localDeclaration.annotations != null) {
            for (Annotation a : localDeclaration.annotations) {
                if (!this.isContainsInTypeAnnotation(localDeclaration.type.resolvedType, a)) continue;
                a.traverse((ASTVisitor)this, scope);
            }
        }
        return false;
    }

    @Override
    public boolean visit(LongLiteral longLiteral, BlockScope scope) {
        CtLiteral<Long> l = this.factory.Core().createLiteral();
        l.setValue(longLiteral.constant.longValue());
        CtTypeReference r = this.references.getTypeReference(longLiteral.resolvedType);
        l.setType(r);
        this.context.enter(l, longLiteral);
        return true;
    }

    @Override
    public boolean visit(MarkerAnnotation annotation, BlockScope scope) {
        return this.visitMarkerAnnoation(annotation, scope);
    }

    private <A extends java.lang.annotation.Annotation> boolean visitMarkerAnnoation(MarkerAnnotation annotation, BlockScope scope) {
        CtAnnotation a = this.factory.Core().createAnnotation();
        CtTypeReference t = this.references.getTypeReference(annotation.resolvedType);
        a.setAnnotationType(t);
        this.context.enter(a, annotation);
        this.skipTypeInAnnotation = true;
        return true;
    }

    @Override
    public boolean visit(MemberValuePair pair, BlockScope scope) {
        this.context.annotationValueName.push(new String(pair.name));
        return true;
    }

    @Override
    public boolean visit(MessageSend messageSend, BlockScope scope) {
        if (messageSend.actualReceiverType == null || !messageSend.actualReceiverType.isAnnotationType()) {
            CtInvocation inv = this.factory.Core().createInvocation();
            if (messageSend.binding != null) {
                inv.setExecutable(this.references.getExecutableReference(messageSend.binding));
            } else {
                CtExecutableReference ref = this.factory.Core().createExecutableReference();
                ref.setSimpleName(new String(messageSend.selector));
                inv.setExecutable(ref);
            }
            this.context.enter(inv, messageSend);
            if (!messageSend.receiver.getClass().equals(ThisReference.class)) {
                messageSend.receiver.traverse((ASTVisitor)this, scope);
            }
            this.context.pushArgument(inv);
            if (messageSend.arguments != null) {
                for (Expression e : messageSend.arguments) {
                    e.traverse((ASTVisitor)this, scope);
                }
            }
            if (messageSend.genericTypeArguments != null) {
                inv.getExecutable().setActualTypeArguments(this.references.getBoundedTypesReferences(messageSend.genericTypeArguments));
            }
            this.context.popArgument(inv);
            return false;
        }
        CtAnnotationFieldAccess acc = this.factory.Core().createAnnotationFieldAccess();
        acc.setVariable(this.references.getVariableReference(messageSend.binding));
        acc.setType(this.references.getTypeReference(messageSend.resolvedType));
        this.context.enter(acc, messageSend);
        this.context.target.push(acc);
        messageSend.receiver.traverse((ASTVisitor)this, scope);
        this.context.target.pop();
        return false;
    }

    @Override
    public boolean visit(MethodDeclaration methodDeclaration, ClassScope scope) {
        CtMethod m = this.factory.Core().createMethod();
        m.setSimpleName(new String(methodDeclaration.selector));
        m.setType(this.references.getTypeReference(methodDeclaration.returnType.resolvedType));
        m.setModifiers(JDTTreeBuilder.getModifiers(methodDeclaration.modifiers));
        m.setDefaultMethod(methodDeclaration.isDefaultMethod());
        if (methodDeclaration.thrownExceptions != null) {
            for (TypeReference typeReference : methodDeclaration.thrownExceptions) {
                CtTypeReference tr = this.references.getTypeReference(typeReference.resolvedType);
                m.addThrownType(tr);
            }
        }
        if (methodDeclaration.binding != null) {
            for (TypeVariableBinding typeVariableBinding : methodDeclaration.binding.typeVariables) {
                m.addFormalTypeParameter(this.references.getBoundedTypeReference(typeVariableBinding));
            }
        }
        if (scope != null) {
            m.setDocComment(this.getJavaDoc(methodDeclaration.javadoc, scope.referenceCompilationUnit()));
        } else if (methodDeclaration.scope != null) {
            m.setDocComment(this.getJavaDoc(methodDeclaration.javadoc, methodDeclaration.scope.referenceCompilationUnit()));
        }
        this.context.enter(m, methodDeclaration);
        if (methodDeclaration.annotations != null) {
            for (Annotation annotation : methodDeclaration.annotations) {
                if (!this.isContainsInTypeAnnotation(methodDeclaration.returnType.resolvedType, annotation)) continue;
                annotation.traverse((ASTVisitor)this, methodDeclaration.scope);
            }
        }
        if (methodDeclaration.arguments != null) {
            for (Argument argument : methodDeclaration.arguments) {
                argument.traverse((ASTVisitor)this, methodDeclaration.scope);
            }
        }
        if (!methodDeclaration.isAbstract() && (methodDeclaration.modifiers & 0x100) == 0) {
            CtBlock b = this.factory.Core().createBlock();
            this.context.enter(b, methodDeclaration);
        }
        if (methodDeclaration.statements != null) {
            for (Statement statement : methodDeclaration.statements) {
                statement.traverse(this, methodDeclaration.scope);
            }
        }
        return false;
    }

    private boolean isContainsInTypeAnnotation(TypeBinding binding, Annotation a) {
        return !binding.hasTypeAnnotations() || !this.containsInTypeAnnotation(a, binding.getTypeAnnotations());
    }

    private boolean containsInTypeAnnotation(Annotation a, AnnotationBinding[] typeAnnotations) {
        for (AnnotationBinding typeAnnotation : typeAnnotations) {
            if (!typeAnnotation.getAnnotationType().equals(a.resolvedType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean visit(NormalAnnotation annotation, BlockScope scope) {
        return this.visitNormalAnnotation(annotation, scope);
    }

    private <A extends java.lang.annotation.Annotation> boolean visitNormalAnnotation(NormalAnnotation annotation, BlockScope scope) {
        CtAnnotation a = this.factory.Core().createAnnotation();
        CtTypeReference r = this.references.getTypeReference(annotation.resolvedType);
        a.setAnnotationType(r);
        this.context.enter(a, annotation);
        this.skipTypeInAnnotation = true;
        return true;
    }

    @Override
    public boolean visit(NullLiteral nullLiteral, BlockScope scope) {
        CtLiteral lit = this.factory.Core().createLiteral();
        CtTypeReference ref = this.factory.Core().createTypeReference();
        ref.setSimpleName("<nulltype>");
        lit.setType(ref);
        this.context.enter(lit, nullLiteral);
        return true;
    }

    @Override
    public boolean visit(OR_OR_Expression or_or_Expression, BlockScope scope) {
        CtBinaryOperator op = this.factory.Core().createBinaryOperator();
        op.setKind(this.getBinaryOperatorKind((or_or_Expression.bits & 0xFC0) >> 6));
        this.context.enter(op, or_or_Expression);
        return true;
    }

    @Override
    public boolean visit(ParameterizedQualifiedTypeReference parameterizedQualifiedTypeReference, ClassScope scope) {
        if (this.skipTypeInAnnotation) {
            return true;
        }
        CtLiteral<CtTypeReference<?>> l = this.factory.Core().createLiteral();
        l.setValue(this.references.getBoundedTypeReference(parameterizedQualifiedTypeReference.resolvedType));
        this.context.enter(l, parameterizedQualifiedTypeReference);
        return true;
    }

    @Override
    public boolean visit(ParameterizedSingleTypeReference parameterizedSingleTypeReference, BlockScope scope) {
        if (this.skipTypeInAnnotation) {
            return true;
        }
        CtLiteral<CtTypeReference<?>> l = this.factory.Core().createLiteral();
        l.setValue(this.references.getBoundedTypeReference(parameterizedSingleTypeReference.resolvedType));
        this.context.enter(l, parameterizedSingleTypeReference);
        return true;
    }

    @Override
    public boolean visit(ParameterizedSingleTypeReference parameterizedSingleTypeReference, ClassScope scope) {
        if (this.skipTypeInAnnotation) {
            return true;
        }
        CtLiteral<CtTypeReference<?>> l = this.factory.Core().createLiteral();
        l.setValue(this.references.getBoundedTypeReference(parameterizedSingleTypeReference.resolvedType));
        this.context.enter(l, parameterizedSingleTypeReference);
        return super.visit(parameterizedSingleTypeReference, scope);
    }

    @Override
    public boolean visit(PostfixExpression postfixExpression, BlockScope scope) {
        CtUnaryOperator op = this.factory.Core().createUnaryOperator();
        if (postfixExpression.operator == 14) {
            op.setKind(UnaryOperatorKind.POSTINC);
        }
        if (postfixExpression.operator == 13) {
            op.setKind(UnaryOperatorKind.POSTDEC);
        }
        this.context.enter(op, postfixExpression);
        return true;
    }

    @Override
    public boolean visit(PrefixExpression prefixExpression, BlockScope scope) {
        CtUnaryOperator op = this.factory.Core().createUnaryOperator();
        if (prefixExpression.operator == 14) {
            op.setKind(UnaryOperatorKind.PREINC);
        }
        if (prefixExpression.operator == 13) {
            op.setKind(UnaryOperatorKind.PREDEC);
        }
        this.context.enter(op, prefixExpression);
        return true;
    }

    @Override
    public boolean visit(QualifiedAllocationExpression qualifiedAllocationExpression, BlockScope scope) {
        this.buildCommonPartForCtNewClassAndCtConstructorCall(qualifiedAllocationExpression, scope, this.factory.Core().createNewClass());
        if (qualifiedAllocationExpression.enclosingInstance != null) {
            qualifiedAllocationExpression.enclosingInstance.traverse((ASTVisitor)this, scope);
        }
        if (qualifiedAllocationExpression.anonymousType != null) {
            qualifiedAllocationExpression.anonymousType.traverse((ASTVisitor)this, scope);
        }
        return false;
    }

    @Override
    public boolean visit(QualifiedNameReference qualifiedNameReference, BlockScope scope) {
        long[] positions = qualifiedNameReference.sourcePositions;
        if (qualifiedNameReference.binding instanceof FieldBinding) {
            CtFieldAccess fa = this.factory.Core().createFieldAccess();
            CtFieldReference ref = this.references.getVariableReference(qualifiedNameReference.fieldBinding());
            ref.setDeclaringType(this.references.getTypeReference(qualifiedNameReference.actualReceiverType));
            fa.setVariable(ref);
            if (qualifiedNameReference.otherBindings != null) {
                int i = 0;
                int sourceStart = (int)(positions[0] >>> 32);
                for (FieldBinding b : qualifiedNameReference.otherBindings) {
                    if (b == null) continue;
                    CtFieldAccess other = this.factory.Core().createFieldAccess();
                    other.setVariable(this.references.getVariableReference(b));
                    other.setTarget(fa);
                    fa.setParent(other);
                    CompilationUnit cu = this.factory.CompilationUnit().create(new String(this.context.compilationunitdeclaration.getFileName()));
                    int sourceEnd = (int)positions[i];
                    fa.setPosition(this.factory.Core().createSourcePosition(cu, sourceStart, sourceEnd, this.context.compilationunitdeclaration.compilationResult.lineSeparatorPositions));
                    fa = other;
                    ++i;
                }
            }
            this.context.enter(fa, qualifiedNameReference);
            return true;
        }
        if (qualifiedNameReference.binding instanceof VariableBinding) {
            CtVariableAccess va = this.factory.Core().createVariableAccess();
            va.setVariable(this.references.getVariableReference((VariableBinding)qualifiedNameReference.binding));
            va.setType(va.getVariable().getType());
            if (qualifiedNameReference.otherBindings != null) {
                int i = 0;
                int sourceStart = (int)(positions[0] >>> 32);
                for (FieldBinding b : qualifiedNameReference.otherBindings) {
                    CtFieldAccess fa = this.factory.Core().createFieldAccess();
                    fa.setTarget(va);
                    CtFieldReference varRef = this.references.getVariableReference(b);
                    if (varRef != null) {
                        fa.setVariable(varRef);
                    }
                    if (b != null) {
                        fa.setType(this.references.getTypeReference(b.type));
                    } else {
                        CtTypeReference ref = this.factory.Core().createTypeReference();
                        ref.setSimpleName(new String(qualifiedNameReference.tokens[qualifiedNameReference.tokens.length - 1]));
                        fa.setType(ref);
                    }
                    va.setParent(fa);
                    CompilationUnit cu = this.factory.CompilationUnit().create(new String(this.context.compilationunitdeclaration.getFileName()));
                    int sourceEnd = (int)positions[i];
                    va.setPosition(this.factory.Core().createSourcePosition(cu, sourceStart, sourceEnd, this.context.compilationunitdeclaration.compilationResult.lineSeparatorPositions));
                    va = fa;
                    ++i;
                }
            }
            this.context.enter(va, qualifiedNameReference);
            return false;
        }
        CtVariableAccess va = this.factory.Core().createVariableAccess();
        CtUnboundVariableReferenceImpl varRef = new CtUnboundVariableReferenceImpl();
        varRef.setSimpleName(qualifiedNameReference.toString());
        va.setVariable(varRef);
        this.context.enter(va, qualifiedNameReference);
        return false;
    }

    @Override
    public boolean visit(QualifiedThisReference qualifiedThisReference, BlockScope scope) {
        return this.visit((ThisReference)qualifiedThisReference, scope);
    }

    @Override
    public boolean visit(QualifiedTypeReference arg0, BlockScope arg1) {
        if (this.skipTypeInAnnotation) {
            return true;
        }
        CtLiteral l = this.factory.Core().createLiteral();
        l.setValue(this.references.getTypeReference(arg0.resolvedType));
        this.context.enter(l, arg0);
        return true;
    }

    @Override
    public boolean visit(ReturnStatement returnStatement, BlockScope scope) {
        CtReturn ret = this.factory.Core().createReturn();
        this.context.enter(ret, returnStatement);
        return true;
    }

    @Override
    public boolean visit(SingleMemberAnnotation annotation, BlockScope scope) {
        return this.visitSingleMemberAnnotation(annotation, scope);
    }

    private <A extends java.lang.annotation.Annotation> boolean visitSingleMemberAnnotation(SingleMemberAnnotation annotation, BlockScope scope) {
        CtAnnotation a = this.factory.Core().createAnnotation();
        CtTypeReference r = this.references.getTypeReference(annotation.resolvedType);
        a.setAnnotationType(r);
        this.context.enter(a, annotation);
        this.context.annotationValueName.push("value");
        this.skipTypeInAnnotation = true;
        return true;
    }

    @Override
    public boolean visit(SingleNameReference singleNameReference, BlockScope scope) {
        CtVariableAccess va = null;
        if (singleNameReference.binding instanceof FieldBinding) {
            va = this.factory.Core().createFieldAccess();
            va.setVariable(this.references.getVariableReference(singleNameReference.fieldBinding()));
        } else if (singleNameReference.binding instanceof VariableBinding) {
            va = this.factory.Core().createVariableAccess();
            va.setVariable(this.references.getVariableReference((VariableBinding)singleNameReference.binding));
        } else if (singleNameReference.binding instanceof TypeBinding) {
            CtTypeAccess ta = this.factory.Core().createTypeAccess();
            ta.setType(this.references.getTypeReference((TypeBinding)singleNameReference.binding));
            this.context.enter(ta, singleNameReference);
        }
        if (va != null) {
            this.context.enter(va, singleNameReference);
        }
        return true;
    }

    @Override
    public boolean visit(QualifiedSuperReference qualifiedSuperReference, BlockScope scope) {
        if (this.skipTypeInAnnotation) {
            return true;
        }
        CtLiteral l = this.factory.Core().createLiteral();
        CtTypeReference withoutSuper = this.references.getTypeReference(qualifiedSuperReference.qualification.resolvedType);
        withoutSuper.setSuperReference(true);
        l.setValue(withoutSuper);
        this.context.enter(l, qualifiedSuperReference);
        return false;
    }

    @Override
    public boolean visit(SingleTypeReference singleTypeReference, BlockScope scope) {
        if (this.skipTypeInAnnotation) {
            return true;
        }
        CtLiteral l = this.factory.Core().createLiteral();
        l.setValue(this.references.getTypeReference(singleTypeReference.resolvedType));
        this.context.enter(l, singleTypeReference);
        return true;
    }

    @Override
    public boolean visit(SingleTypeReference singleTypeReference, ClassScope scope) {
        CtLiteral l = this.factory.Core().createLiteral();
        l.setValue(this.references.getTypeReference(singleTypeReference.resolvedType));
        this.context.enter(l, singleTypeReference);
        return true;
    }

    @Override
    public boolean visit(StringLiteral stringLiteral, BlockScope scope) {
        CtLiteral<String> s = this.factory.Core().createLiteral();
        s.setType(this.factory.Type().createReference(String.class));
        s.setValue(new String(stringLiteral.source()));
        this.context.enter(s, stringLiteral);
        return true;
    }

    @Override
    public boolean visit(StringLiteralConcatenation literal, BlockScope scope) {
        CtBinaryOperator op = this.factory.Core().createBinaryOperator();
        op.setKind(BinaryOperatorKind.PLUS);
        this.context.enter(op, literal);
        ArrayList<Expression> exp = new ArrayList<Expression>();
        for (int i = 0; i < literal.counter; ++i) {
            exp.add(literal.literals[i]);
        }
        this.createExpression(literal, scope, exp);
        return false;
    }

    @Override
    public boolean visit(SuperReference superReference, BlockScope scope) {
        CtFieldReference fr = this.factory.Core().createFieldReference();
        CtTypeReference ref = this.references.getTypeReference(superReference.resolvedType);
        fr.setSimpleName("super");
        fr.setDeclaringType(ref);
        fr.setType(ref);
        CtSuperAccess fa = this.factory.Core().createSuperAccess();
        fa.setVariable(fr);
        this.context.enter(fa, superReference);
        return super.visit(superReference, scope);
    }

    @Override
    public boolean visit(SwitchStatement switchStatement, BlockScope scope) {
        CtSwitch s = this.factory.Core().createSwitch();
        this.context.enter(s, switchStatement);
        switchStatement.expression.traverse((ASTVisitor)this, switchStatement.scope);
        if (switchStatement.statements != null) {
            int statementsLength = switchStatement.statements.length;
            for (int i = 0; i < statementsLength; ++i) {
                if (switchStatement.statements[i] instanceof CaseStatement) {
                    if (this.context.stack.peek().element instanceof CtCase) {
                        this.context.exit(this.context.stack.peek().node);
                    }
                    CaseStatement cas = (CaseStatement)switchStatement.statements[i];
                    this.visit(cas, switchStatement.scope);
                    continue;
                }
                switchStatement.statements[i].traverse(this, switchStatement.scope);
            }
            if (this.context.stack.peek().element instanceof CtCase) {
                this.context.exit(this.context.stack.peek().node);
            }
        }
        return false;
    }

    @Override
    public boolean visit(SynchronizedStatement synchronizedStatement, BlockScope scope) {
        CtSynchronized s = this.factory.Core().createSynchronized();
        this.context.enter(s, synchronizedStatement);
        return super.visit(synchronizedStatement, scope);
    }

    @Override
    public boolean visit(ThisReference thisReference, BlockScope scope) {
        CtThisAccess fa = this.factory.Core().createThisAccess();
        fa.setImplicit(thisReference.isImplicitThis());
        if (thisReference instanceof QualifiedThisReference) {
            fa.setQualified(true);
        }
        CtTypeReference typeref = this.references.getTypeReference(thisReference.resolvedType);
        fa.setType(typeref);
        this.context.enter(fa, thisReference);
        return true;
    }

    @Override
    public boolean visit(ThrowStatement throwStatement, BlockScope scope) {
        CtThrow t = this.factory.Core().createThrow();
        this.context.enter(t, throwStatement);
        return true;
    }

    @Override
    public boolean visit(TrueLiteral trueLiteral, BlockScope scope) {
        CtLiteral<Boolean> l = this.factory.Core().createLiteral();
        l.setValue(true);
        this.context.enter(l, trueLiteral);
        return true;
    }

    @Override
    public boolean visit(TryStatement tryStatement, BlockScope scope) {
        CtTry t = tryStatement.resources.length > 0 ? this.factory.Core().createTryWithResource() : this.factory.Core().createTry();
        this.context.enter(t, tryStatement);
        for (LocalDeclaration localDeclaration : tryStatement.resources) {
            localDeclaration.traverse(this, scope);
        }
        tryStatement.tryBlock.traverse(this, scope);
        if (tryStatement.catchArguments != null) {
            for (int i = 0; i < tryStatement.catchArguments.length; ++i) {
                Argument jdtCatch = tryStatement.catchArguments[i];
                if (jdtCatch.type instanceof SingleTypeReference || jdtCatch.type instanceof QualifiedTypeReference) {
                    CtTypeReference<Throwable> r = this.references.getTypeReference(jdtCatch.type.resolvedType);
                    this.createCtCatch(jdtCatch, r);
                    tryStatement.catchBlocks[i].traverse(this, scope);
                    this.context.exit(jdtCatch);
                    continue;
                }
                if (jdtCatch.type instanceof UnionTypeReference) {
                    UnionTypeReference utr = (UnionTypeReference)jdtCatch.type;
                    ArrayList refs = new ArrayList();
                    for (TypeReference type : utr.typeReferences) {
                        CtTypeReference r = this.references.getTypeReference(type.resolvedType);
                        refs.add(r);
                    }
                    CtTypeReference<Throwable> r = this.references.getTypeReference(jdtCatch.type.resolvedType);
                    this.createCtCatchJava7(jdtCatch, r, refs);
                    tryStatement.catchBlocks[i].traverse(this, scope);
                    this.context.exit(jdtCatch);
                    continue;
                }
                throw new RuntimeException("I don't know how to do this");
            }
        }
        if (tryStatement.finallyBlock != null) {
            this.context.finallyzer.push(t);
            tryStatement.finallyBlock.traverse(this, scope);
            this.context.finallyzer.pop();
        }
        return false;
    }

    private CtCatch createCtCatch(Argument jdtCatch, CtTypeReference<Throwable> r) {
        CtCatch c = this.factory.Core().createCatch();
        CtCatchVariable<Throwable> var = this.factory.Core().createCatchVariable();
        this.context.enter(c, jdtCatch);
        this.context.enter(var, jdtCatch);
        var.setSimpleName(new String(jdtCatch.name));
        var.setType(r);
        for (ModifierKind modifier : JDTTreeBuilder.getModifiers(jdtCatch.modifiers)) {
            var.addModifier(modifier);
        }
        this.context.exit(jdtCatch);
        return c;
    }

    private CtCatch createCtCatchJava7(Argument jdtCatch, CtTypeReference<Throwable> r, List<CtTypeReference<?>> refs) {
        CtCatch c = this.factory.Core().createCatch();
        CtCatchVariable<Throwable> var = this.factory.Core().createCatchVariable();
        this.context.enter(c, jdtCatch);
        this.context.enter(var, jdtCatch);
        var.setSimpleName(new String(jdtCatch.name));
        var.setType(r);
        for (CtTypeReference<?> ref : refs) {
            var.addMultiType(ref);
        }
        for (ModifierKind modifier : JDTTreeBuilder.getModifiers(jdtCatch.modifiers)) {
            var.addModifier(modifier);
        }
        this.context.exit(jdtCatch);
        return c;
    }

    @Override
    public boolean visit(TypeDeclaration localTypeDeclaration, BlockScope scope) {
        CtType<?> t = this.createType(localTypeDeclaration);
        t.setDocComment(this.getJavaDoc(localTypeDeclaration.javadoc, scope.referenceCompilationUnit()));
        this.context.enter(t, localTypeDeclaration);
        if (localTypeDeclaration.fields != null) {
            for (FieldDeclaration field : localTypeDeclaration.fields) {
                if (!field.isStatic()) continue;
                field.traverse((ASTVisitor)this, localTypeDeclaration.initializerScope);
            }
        }
        return true;
    }

    @Override
    public boolean visit(TypeDeclaration memberTypeDeclaration, ClassScope scope) {
        CtType<?> type = this.createType(memberTypeDeclaration);
        type.setDocComment(this.getJavaDoc(memberTypeDeclaration.javadoc, scope.referenceCompilationUnit()));
        this.context.enter(type, memberTypeDeclaration);
        return true;
    }

    @Override
    public boolean visit(TypeDeclaration typeDeclaration, CompilationUnitScope scope) {
        int i;
        if (new String(typeDeclaration.name).equals("package-info")) {
            CtPackage pack = this.factory.Package().getOrCreate(new String(typeDeclaration.binding.fPackage.readableName()));
            pack.setDocComment(this.getJavaDoc(typeDeclaration.javadoc, scope.referenceContext));
            this.context.compilationunitdeclaration = scope.referenceContext;
            this.context.enter(pack, typeDeclaration);
            return true;
        }
        CtType<?> type = this.createType(typeDeclaration);
        type.setDocComment(this.getJavaDoc(typeDeclaration.javadoc, scope.referenceContext));
        CtPackage pack = null;
        pack = typeDeclaration.binding.fPackage.shortReadableName() != null && typeDeclaration.binding.fPackage.shortReadableName().length > 0 ? this.factory.Package().getOrCreate(new String(typeDeclaration.binding.fPackage.shortReadableName())) : this.factory.Package().getOrCreate("unnamed package");
        this.context.enter(pack, typeDeclaration);
        this.context.compilationunitdeclaration = scope.referenceContext;
        this.context.enter(type, typeDeclaration);
        if (typeDeclaration.annotations != null) {
            for (Annotation a : typeDeclaration.annotations) {
                a.traverse((ASTVisitor)this, (BlockScope)null);
            }
        }
        if (typeDeclaration.memberTypes != null) {
            int length = typeDeclaration.memberTypes.length;
            for (i = 0; i < length; ++i) {
                typeDeclaration.memberTypes[i].traverse((ASTVisitor)this, typeDeclaration.scope);
            }
        }
        if (typeDeclaration.fields != null) {
            int length = typeDeclaration.fields.length;
            for (i = 0; i < length; ++i) {
                FieldDeclaration field = typeDeclaration.fields[i];
                if (field.isStatic()) {
                    field.traverse((ASTVisitor)this, typeDeclaration.staticInitializerScope);
                    continue;
                }
                field.traverse((ASTVisitor)this, typeDeclaration.initializerScope);
            }
        }
        if (typeDeclaration.methods != null) {
            int length = typeDeclaration.methods.length;
            for (i = 0; i < length; ++i) {
                typeDeclaration.methods[i].traverse((ASTVisitor)this, typeDeclaration.scope);
            }
        }
        return false;
    }

    @Override
    public boolean visit(UnaryExpression unaryExpression, BlockScope scope) {
        CtUnaryOperator op = this.factory.Core().createUnaryOperator();
        op.setKind(this.getUnaryOperator((unaryExpression.bits & 0xFC0) >> 6));
        this.context.enter(op, unaryExpression);
        return true;
    }

    @Override
    public boolean visit(WhileStatement whileStatement, BlockScope scope) {
        CtWhile w = this.factory.Core().createWhile();
        this.context.enter(w, whileStatement);
        return true;
    }

    public class ReferenceBuilder {
        Map<String, CtTypeReference<?>> basestypes = new TreeMap();
        Set<String> typevars = new TreeSet<String>();
        boolean bounds = false;

        public CtTypeReference<?> getBoundedTypeReference(TypeBinding binding) {
            this.bounds = true;
            CtTypeReference ref = this.getTypeReference(binding);
            this.bounds = false;
            return ref;
        }

        public <T> CtExecutableReference<T> getExecutableReference(MethodBinding exec) {
            if (exec == null) {
                return null;
            }
            CtExecutableReference<T> ref = JDTTreeBuilder.this.factory.Core().createExecutableReference();
            ref.setDeclaringType(this.getTypeReference(exec.declaringClass));
            ref.setType(this.getTypeReference(exec.returnType));
            ref.setSimpleName(new String(exec.selector));
            ref.setStatic(exec.isStatic());
            if (exec.original() != null) {
                ArrayList parameters = new ArrayList();
                for (TypeBinding b : exec.original().parameters) {
                    parameters.add(this.getTypeReference(b));
                }
                ref.setParameters(parameters);
            } else if (exec.parameters != null) {
                ArrayList parameters = new ArrayList();
                for (TypeBinding b : exec.parameters) {
                    parameters.add(this.getTypeReference(b));
                }
                ref.setParameters(parameters);
            }
            return ref;
        }

        public CtPackageReference getPackageReference(PackageBinding reference) {
            String name = new String(reference.shortReadableName());
            if (name.length() == 0) {
                return null;
            }
            CtPackageReference ref = JDTTreeBuilder.this.factory.Core().createPackageReference();
            ref.setSimpleName(name);
            return ref;
        }

        public <T> CtTypeReference<T> getTypeReference(TypeBinding binding, TypeReference ref) {
            CtTypeReference<T> ctRef = this.getTypeReference(binding);
            if (ctRef != null) {
                return ctRef;
            }
            ctRef = JDTTreeBuilder.this.factory.Core().createTypeReference();
            ctRef.setSimpleName(new String(JDTTreeBuilder.this.createTypeName(ref.getTypeName())));
            return ctRef;
        }

        public <T> CtTypeReference<T> getTypeReference(TypeBinding binding) {
            if (binding == null) {
                return null;
            }
            CtTypeReference<Object> ref = null;
            if (binding instanceof RawTypeBinding) {
                ref = this.getTypeReference(((ParameterizedTypeBinding)binding).genericType());
            } else if (binding instanceof ParameterizedTypeBinding) {
                ref = JDTTreeBuilder.this.factory.Core().createTypeReference();
                if (binding.isAnonymousType()) {
                    ref.setSimpleName("");
                } else {
                    ref.setSimpleName(String.valueOf(binding.sourceName()));
                    if (binding.enclosingType() != null) {
                        ref.setDeclaringType(this.getTypeReference(binding.enclosingType()));
                    } else {
                        ref.setPackage(this.getPackageReference(binding.getPackage()));
                    }
                }
                if (((ParameterizedTypeBinding)binding).arguments != null) {
                    for (TypeBinding b : ((ParameterizedTypeBinding)binding).arguments) {
                        ref.addActualTypeArgument(this.getTypeReference(b));
                    }
                }
            } else if (binding instanceof BinaryTypeBinding) {
                ref = JDTTreeBuilder.this.factory.Core().createTypeReference();
                if (binding.enclosingType() != null) {
                    ref.setDeclaringType(this.getTypeReference(binding.enclosingType()));
                } else {
                    ref.setPackage(this.getPackageReference(binding.getPackage()));
                }
                ref.setSimpleName(new String(binding.sourceName()));
            } else if (binding instanceof TypeVariableBinding) {
                boolean oldBounds = this.bounds;
                ref = JDTTreeBuilder.this.factory.Core().createTypeParameterReference();
                if (binding instanceof CaptureBinding) {
                    ref.setSimpleName("?");
                    this.bounds = true;
                } else {
                    ref.setSimpleName(new String(binding.sourceName()));
                }
                TypeVariableBinding b = (TypeVariableBinding)binding;
                if (this.bounds) {
                    if (b instanceof CaptureBinding && ((CaptureBinding)b).wildcard != null) {
                        this.bounds = oldBounds;
                        return this.getTypeReference(((CaptureBinding)b).wildcard);
                    }
                    if (b.superclass != null && b.firstBound == b.superclass) {
                        this.bounds = false;
                        ((CtTypeParameterReference)ref).addBound(this.getTypeReference(b.superclass));
                        this.bounds = oldBounds;
                    }
                }
                if (this.bounds && b.superInterfaces != null && b.superInterfaces != Binding.NO_SUPERINTERFACES) {
                    this.bounds = false;
                    for (ReferenceBinding tb : b.superInterfaces) {
                        ((CtTypeParameterReference)ref).addBound(this.getTypeReference(tb));
                    }
                }
                if (binding instanceof CaptureBinding) {
                    this.bounds = false;
                }
            } else if (binding instanceof BaseTypeBinding) {
                String name = new String(binding.sourceName());
                ref = this.basestypes.get(name);
                if (ref == null) {
                    ref = JDTTreeBuilder.this.factory.Core().createTypeReference();
                    ref.setSimpleName(name);
                    this.basestypes.put(name, ref);
                }
            } else if (binding instanceof WildcardBinding) {
                CtTypeParameterReference reference = JDTTreeBuilder.this.factory.Core().createTypeParameterReference();
                reference.setSimpleName("?");
                if (((WildcardBinding)binding).boundKind == 2) {
                    reference.setUpper(false);
                }
                if (((WildcardBinding)binding).bound != null) {
                    reference.addBound(this.getTypeReference(((WildcardBinding)binding).bound));
                }
                ref = reference;
            } else if (binding instanceof LocalTypeBinding) {
                ref = JDTTreeBuilder.this.factory.Core().createTypeReference();
                if (binding.isAnonymousType()) {
                    ref.setSimpleName(JDTTreeBuilder.this.computeAnonymousName((SourceTypeBinding)binding));
                    ref.setDeclaringType(this.getTypeReference(binding.enclosingType()));
                } else {
                    ref.setSimpleName(new String(binding.sourceName()));
                    if (((LocalTypeBinding)binding).enclosingMethod == null && binding.enclosingType() != null && binding.enclosingType() instanceof LocalTypeBinding) {
                        ref.setDeclaringType(this.getTypeReference(binding.enclosingType()));
                    }
                }
            } else if (binding instanceof SourceTypeBinding) {
                ref = JDTTreeBuilder.this.factory.Core().createTypeReference();
                if (binding.isAnonymousType()) {
                    ref.setSimpleName(JDTTreeBuilder.this.computeAnonymousName((SourceTypeBinding)binding));
                    ref.setDeclaringType(this.getTypeReference(binding.enclosingType()));
                } else {
                    ref.setSimpleName(new String(binding.sourceName()));
                    if (binding.enclosingType() != null) {
                        ref.setDeclaringType(this.getTypeReference(binding.enclosingType()));
                    } else {
                        ref.setPackage(this.getPackageReference(binding.getPackage()));
                    }
                }
            } else if (binding instanceof ArrayBinding) {
                CtArrayTypeReference arrayref = JDTTreeBuilder.this.factory.Core().createArrayTypeReference();
                ref = arrayref;
                for (int i = 1; i < binding.dimensions(); ++i) {
                    CtArrayTypeReference tmp = JDTTreeBuilder.this.factory.Core().createArrayTypeReference();
                    arrayref.setComponentType(tmp);
                    arrayref = tmp;
                }
                arrayref.setComponentType(this.getTypeReference(binding.leafComponentType()));
            } else if (binding instanceof ProblemReferenceBinding) {
                ref = JDTTreeBuilder.this.factory.Core().createTypeReference();
                ref.setSimpleName(new String(binding.readableName()));
            } else {
                throw new RuntimeException("Unknown TypeBinding: " + binding.getClass() + " " + binding);
            }
            this.addTypeAnnotationFromBindingToReference(binding, ref);
            return ref;
        }

        private void addTypeAnnotationFromBindingToReference(TypeBinding resolvedType, CtTypeReference<?> reference) {
            if (resolvedType.hasTypeAnnotations()) {
                AnnotationBinding[] typeAnnotations;
                for (AnnotationBinding typeAnnotation : typeAnnotations = resolvedType.getTypeAnnotations()) {
                    reference.addTypeAnnotation(this.getTypeCtAnnotation(typeAnnotation));
                }
            }
        }

        public <A extends java.lang.annotation.Annotation> CtAnnotation<A> getTypeCtAnnotation(AnnotationBinding annotationBinding) {
            CtAnnotation a = JDTTreeBuilder.this.factory.Core().createAnnotation();
            CtTypeReference t = JDTTreeBuilder.this.references.getTypeReference(annotationBinding.getAnnotationType());
            a.setAnnotationType(t);
            HashMap<String, Object> valuePairs = new HashMap<String, Object>();
            for (ElementValuePair valuePair : annotationBinding.getElementValuePairs()) {
                valuePairs.put(String.valueOf(valuePair.getName()), this.buildValuePairAnnotation(valuePair.getValue()));
            }
            a.setElementValues(valuePairs);
            return a;
        }

        private Object buildValuePairAnnotation(Object value) {
            if (value instanceof AnnotationBinding) {
                return this.getTypeCtAnnotation((AnnotationBinding)value);
            }
            if (value instanceof FieldBinding) {
                return this.getVariableReference((FieldBinding)value);
            }
            if (value instanceof BinaryTypeBinding) {
                return this.getTypeReference((BinaryTypeBinding)value);
            }
            if (value instanceof Object[]) {
                ArrayList<Object> values = new ArrayList<Object>();
                for (Object currentValue : (Object[])value) {
                    values.add(this.buildValuePairAnnotation(currentValue));
                }
                return values;
            }
            return value;
        }

        public <T> CtVariableReference<T> getVariableReference(MethodBinding methbin) {
            CtFieldReference<T> ref = JDTTreeBuilder.this.factory.Core().createFieldReference();
            ref.setSimpleName(new String(methbin.selector));
            ref.setType(this.getTypeReference(methbin.returnType));
            if (methbin.declaringClass != null) {
                ref.setDeclaringType(this.getTypeReference(methbin.declaringClass));
            } else {
                ref.setDeclaringType(ref.getType());
            }
            return ref;
        }

        public <T> CtFieldReference<T> getVariableReference(FieldBinding varbin) {
            CtFieldReference<T> ref = JDTTreeBuilder.this.factory.Core().createFieldReference();
            if (varbin == null) {
                return ref;
            }
            ref.setSimpleName(new String(varbin.name));
            ref.setType(this.getTypeReference(varbin.type));
            if (varbin.declaringClass != null) {
                ref.setDeclaringType(this.getTypeReference(varbin.declaringClass));
            } else {
                ref.setDeclaringType(ref.getType());
            }
            ref.setFinal(varbin.isFinal());
            ref.setStatic((varbin.modifiers & 8) != 0);
            return ref;
        }

        public <T> CtVariableReference<T> getVariableReference(VariableBinding varbin) {
            if (varbin instanceof FieldBinding) {
                return this.getVariableReference((FieldBinding)varbin);
            }
            if (varbin instanceof LocalVariableBinding) {
                LocalVariableBinding localVariableBinding = (LocalVariableBinding)varbin;
                if (localVariableBinding.declaration instanceof Argument && localVariableBinding.declaringScope instanceof MethodScope) {
                    CtParameterReference<T> ref = JDTTreeBuilder.this.factory.Core().createParameterReference();
                    ref.setSimpleName(new String(varbin.name));
                    ref.setType(this.getTypeReference(varbin.type));
                    ReferenceContext referenceContext = localVariableBinding.declaringScope.referenceContext();
                    if (referenceContext instanceof LambdaExpression) {
                        ref.setDeclaringExecutable(this.getExecutableReference(((LambdaExpression)referenceContext).binding));
                    } else {
                        ref.setDeclaringExecutable(this.getExecutableReference(((AbstractMethodDeclaration)referenceContext).binding));
                    }
                    return ref;
                }
                if (localVariableBinding.declaration.binding instanceof CatchParameterBinding) {
                    CtCatchVariableReference ref = JDTTreeBuilder.this.factory.Core().createCatchVariableReference();
                    ref.setSimpleName(new String(varbin.name));
                    CtTypeReference<T> ref2 = this.getTypeReference(varbin.type);
                    ref.setType(ref2);
                    ref.setDeclaration(JDTTreeBuilder.this.getCatchVariableDeclaration(ref.getSimpleName()));
                    return ref;
                }
                CtLocalVariableReference ref = JDTTreeBuilder.this.factory.Core().createLocalVariableReference();
                ref.setSimpleName(new String(varbin.name));
                CtTypeReference<T> ref2 = this.getTypeReference(varbin.type);
                ref.setType(ref2);
                ref.setDeclaration(JDTTreeBuilder.this.getLocalVariableDeclaration(ref.getSimpleName()));
                return ref;
            }
            return null;
        }

        public List<CtTypeReference<?>> getBoundedTypesReferences(TypeBinding[] genericTypeArguments) {
            ArrayList res = new ArrayList();
            for (TypeBinding tb : genericTypeArguments) {
                res.add(this.getBoundedTypeReference(tb));
            }
            return res;
        }
    }

    public class BuilderContext {
        Stack<String> annotationValueName = new Stack();
        Stack<CtElement> arguments = new Stack();
        List<CtTypeReference<?>> casts = new ArrayList();
        CompilationUnitDeclaration compilationunitdeclaration;
        List<CtType<?>> createdTypes = new ArrayList();
        Stack<CtTry> finallyzer = new Stack();
        boolean forinit = false;
        boolean forupdate = false;
        Stack<String> label = new Stack();
        boolean selector = false;
        Stack<ASTPair> stack = new Stack();
        Stack<CtTargetedExpression<?, ?>> target = new Stack();

        public void addCreatedType(CtType<?> type) {
            this.createdTypes.add(type);
        }

        void enter(CtElement e, ASTNode node) {
            this.stack.push(new ASTPair(e, node));
            if (this.compilationunitdeclaration != null) {
                CoreFactory cf = JDTTreeBuilder.this.factory.Core();
                int sourceStart = node.sourceStart;
                int sourceEnd = node.sourceEnd;
                if (e instanceof CtBlock && node instanceof MethodDeclaration) {
                    sourceStart = ((MethodDeclaration)node).bodyStart;
                    sourceEnd = ((MethodDeclaration)node).bodyEnd;
                }
                CompilationUnit cu = JDTTreeBuilder.this.factory.CompilationUnit().create(new String(this.compilationunitdeclaration.getFileName()));
                e.setPosition(cf.createSourcePosition(cu, sourceStart, sourceEnd, this.compilationunitdeclaration.compilationResult.lineSeparatorPositions));
            }
            ASTPair pair = this.stack.peek();
            CtElement current = pair.element;
            if (current instanceof CtExpression) {
                while (!this.casts.isEmpty()) {
                    ((CtExpression)current).addTypeCast(this.casts.remove(0));
                }
            }
            if (current instanceof CtStatement && !JDTTreeBuilder.this.context.label.isEmpty()) {
                ((CtStatement)current).setLabel(JDTTreeBuilder.this.context.label.pop());
            }
            if (e instanceof CtTypedElement && node instanceof Expression && ((CtTypedElement)e).getType() == null) {
                ((CtTypedElement)e).setType(JDTTreeBuilder.this.references.getTypeReference(((Expression)node).resolvedType));
            }
        }

        void exit(ASTNode node) {
            ASTPair pair = this.stack.pop();
            if (pair.node != node) {
                throw new RuntimeException("Inconsistent Stack " + node + "\n" + pair.node);
            }
            CtElement current = pair.element;
            if (!this.stack.isEmpty()) {
                current.setParent(this.stack.peek().element);
                JDTTreeBuilder.this.exiter.child = current;
                JDTTreeBuilder.this.exiter.scan(this.stack.peek().element);
            }
        }

        public List<CtType<?>> getCreatedTypes() {
            return this.createdTypes;
        }

        public boolean isArgument(CtElement e) {
            return this.arguments.size() > 0 && this.arguments.peek() == e;
        }

        private void popArgument(CtElement e) {
            if (this.arguments.pop() != e) {
                throw new RuntimeException("Unconsistant stack");
            }
        }

        private void pushArgument(CtElement e) {
            this.arguments.push(e);
        }
    }

    public class ASTPair {
        public CtElement element;
        public ASTNode node;

        public ASTPair(CtElement element, ASTNode node) {
            this.element = element;
            this.node = node;
        }

        public String toString() {
            return this.element.getClass().getSimpleName() + "-" + this.node.getClass().getSimpleName();
        }
    }
}

