/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.polynomials;

import JSci.maths.Complex;
import JSci.maths.MathDouble;
import JSci.maths.fields.Field;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;
import JSci.maths.polynomials.ComplexPolynomial;

public class ComplexPolynomialRing
implements Ring {
    private static final ComplexPolynomial ZERO = new ComplexPolynomial(new Complex[]{Complex.ZERO});
    private static final ComplexPolynomial ONE = new ComplexPolynomial(new Complex[]{Complex.ONE});
    private static final ComplexPolynomialRing _instance = new ComplexPolynomialRing();

    protected ComplexPolynomialRing() {
    }

    public static final ComplexPolynomialRing getInstance() {
        return _instance;
    }

    public boolean isNegative(AbelianGroup.Member member, AbelianGroup.Member member2) {
        return member.add(member2).equals(ZERO);
    }

    public boolean isOne(Ring.Member member) {
        return member.equals(ONE);
    }

    public boolean isZero(AbelianGroup.Member member) {
        return member.equals(ZERO);
    }

    public Ring.Member one() {
        return ONE;
    }

    public AbelianGroup.Member zero() {
        return ZERO;
    }

    protected static Complex[] toComplex(Field.Member[] memberArray) {
        Complex[] complexArray = null;
        if (memberArray == null) {
            complexArray = new Complex[]{Complex.ZERO};
        }
        if (memberArray.length == 0) {
            complexArray = new Complex[]{Complex.ZERO};
        } else {
            complexArray = new Complex[memberArray.length];
            for (int i = 0; i < complexArray.length; ++i) {
                if (memberArray[i] instanceof Complex) {
                    complexArray[i] = (Complex)memberArray[i];
                    continue;
                }
                if (memberArray[i] instanceof MathDouble) {
                    complexArray[i] = new Complex(((MathDouble)memberArray[i]).value(), 0.0);
                    continue;
                }
                throw new IllegalArgumentException("Different fields. Argument was " + memberArray[i]);
            }
        }
        return complexArray;
    }
}

