/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.statistics;

public class DiscreteDistribution {
    private final double[] weights;
    private final double mass;

    public DiscreteDistribution(double[] dArray) {
        this.weights = dArray;
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i];
        }
        this.mass = d;
    }

    public double probability(int n) {
        return this.weights[n] / this.mass;
    }

    public double cumulative(int n) {
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += this.weights[i];
        }
        return d;
    }

    public int inverse(double d) {
        double d2 = d * this.mass;
        double d3 = 0.0;
        for (int i = 0; i < this.weights.length; ++i) {
            if (!((d3 += this.weights[i]) > d2)) continue;
            return i;
        }
        return this.weights.length;
    }
}

