/*
 * Decompiled with CFR 0.152.
 */
package ev.par;

import ev.par.HydrophobicModeling;
import ev.par.Input;
import ev.par.Output;
import ev.par.StrTaxonSuffStat;
import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.UnorderedPair;
import goblin.Taxon;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import nuts.io.IO;
import nuts.maxent.LabeledInstance;
import nuts.util.CoordinatesPacker;
import nuts.util.Counter;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;

public final class FeatureExtractor
implements nuts.maxent.FeatureExtractor<LabeledInstance<Input, Output>, Object> {
    public final Map<UnorderedPair<Taxon, Taxon>, Double> distances;
    public final FeatureOptions options;
    private final double[] thresholds;
    private final CoordinatesPacker.MSCoordinatePacker cp;
    private final Index[] indices;
    private final HydrophobicModeling.HydrophobicHeuristic hydrophobicModelingHeuristic = new HydrophobicModeling.ClustalHeuristics();

    @Override
    public Counter<Object> extractFeatures(LabeledInstance<Input, Output> instance) {
        Counter<Object> result = new Counter<Object>();
        int[] coord = this.cp.int2coord(instance.getInput().strTaxSuffStat);
        int distQuantile = coord[Index.DIST.ordinal()];
        int hIndex = coord[Index.HC.ordinal()];
        for (int q = 0; q <= distQuantile; ++q) {
            String emission = "q=" + q + "," + (instance.getLabel().topSymbol < instance.getLabel().botSymbol ? "(" + instance.getLabel().topToChar() + instance.getLabel().botToChar() + ")" : "(" + instance.getLabel().botToChar() + instance.getLabel().topToChar() + ")");
            result.incrementCount(emission, 1.0);
            if (instance.getLabel().topSymbol == instance.getLabel().botSymbol) {
                result.incrementCount("q=" + q + "," + "selfsub", 1.0);
            }
            for (int h = 0; h <= hIndex; ++h) {
                result.incrementCount("q=" + q + "," + "h=" + h + "," + "state1=" + FeatureExtractor.collapseInDelStates(instance.getInput().state1), 1.0);
                if (!this.options.useLongGaps) continue;
                result.incrementCount("q=" + q + "," + "h=" + h + "," + "state1=" + FeatureExtractor.collapseInDelStates(instance.getInput().state1) + "&state2=" + FeatureExtractor.collapseInDelStates(instance.getLabel().state2), 1.0);
            }
        }
        return result;
    }

    public static int collapseInDelStates(int s) {
        if (s == 0) {
            return 0;
        }
        if (s == 1 || s == 2) {
            return 1;
        }
        throw new RuntimeException();
    }

    @Override
    public double regularizationFactor(Object feature) {
        return 1.0;
    }

    public StrTaxonSuffStat getStrTaxonSuffStat() {
        return new SuffStat();
    }

    /*
     * WARNING - void declaration
     */
    public FeatureExtractor(Map<UnorderedPair<Taxon, Taxon>, Double> distances, FeatureOptions options) {
        this.options = options;
        this.distances = distances;
        this.thresholds = new double[options.nQuantiles];
        if (options.nQuantiles > 1) {
            void var5_9;
            void var5_7;
            DescriptiveStatistics ds = new DescriptiveStatistics();
            for (UnorderedPair unorderedPair : distances.keySet()) {
                if (((Taxon)unorderedPair.getFirst()).equals(unorderedPair.getSecond())) continue;
                ds.addValue(distances.get(unorderedPair).doubleValue());
            }
            double[] quantiles = new double[options.nQuantiles];
            boolean bl = true;
            while (var5_7 < quantiles.length) {
                quantiles[var5_7] = 100.0 * (double)var5_7 / (double)quantiles.length;
                ++var5_7;
            }
            quantiles[0] = Double.NaN;
            boolean bl2 = false;
            while (var5_9 < quantiles.length) {
                this.thresholds[var5_9] = var5_9 == false ? Double.NEGATIVE_INFINITY : ds.getPercentile(quantiles[var5_9]);
                ++var5_9;
            }
            LogInfo.logsForce("Thresholds:" + Arrays.toString(this.thresholds));
        }
        this.indices = Index.values();
        int[] sizes = new int[this.indices.length];
        for (Index idx : this.indices) {
            sizes[idx.ordinal()] = idx.size(this);
        }
        this.cp = new CoordinatesPacker.MSCoordinatePacker(sizes);
    }

    public static class HydropathyDB {
        private final Map<Character, Double> db = new HashMap<Character, Double>();
        public final DescriptiveStatistics stats = new DescriptiveStatistics();

        public HydropathyDB() {
            for (String line : IO.i("data/hydropathy.txt")) {
                String[] fields = line.split("\\s+");
                if (fields[0].length() != 1) {
                    throw new RuntimeException();
                }
                char c = Character.toUpperCase(fields[0].charAt(0));
                double d = Double.parseDouble(fields[1]);
                this.db.put(Character.valueOf(c), d);
                this.stats.addValue(d);
            }
        }

        public double get(char c) {
            if (this.db.containsKey(Character.valueOf(c = Character.toUpperCase(c)))) {
                return this.db.get(Character.valueOf(c));
            }
            return 0.0;
        }
    }

    public final class SuffStat
    extends StrTaxonSuffStat {
        public SuffStat() {
            for (int i = 0; i < ((FeatureExtractor)FeatureExtractor.this).cp.max; ++i) {
                StringBuilder current = new StringBuilder();
                int[] c = FeatureExtractor.this.cp.int2coord(i);
                for (int j = 0; j < FeatureExtractor.this.indices.length; ++j) {
                    current.append(FeatureExtractor.this.indices[j].toString() + "=" + c[j]);
                    if (j == FeatureExtractor.this.indices.length - 1) continue;
                    current.append(",");
                }
                this.valuesIndexer.addToIndex(current.toString());
            }
        }

        @Override
        public StrTaxonSuffStat.StrTaxonSuffStatExtractor getExtractor(String str1, String str2, Taxon taxon1, Taxon taxon2) {
            int[] c = new int[FeatureExtractor.this.indices.length];
            if (FeatureExtractor.this.options.nQuantiles > 1) {
                double d = FeatureExtractor.this.distances.get(new UnorderedPair<Taxon, Taxon>(taxon1, taxon2));
                for (int i = FeatureExtractor.this.thresholds.length - 1; i >= 0; --i) {
                    if (!(d >= FeatureExtractor.this.thresholds[i])) continue;
                    c[Index.DIST.ordinal()] = i;
                    break;
                }
            }
            return new Extractor(c, FeatureExtractor.this.options.hydrophobicModeling ? FeatureExtractor.this.hydrophobicModelingHeuristic.compute(str1) : null, FeatureExtractor.this.options.hydrophobicModeling ? FeatureExtractor.this.hydrophobicModelingHeuristic.compute(str2) : null);
        }

        public final class Extractor
        implements StrTaxonSuffStat.StrTaxonSuffStatExtractor {
            private final int[] c;
            private final int[] topHydro;
            private final int[] botHydro;

            public Extractor(int[] c, int[] topHydro, int[] botHydro) {
                this.c = c;
                this.topHydro = topHydro;
                this.botHydro = botHydro;
            }

            @Override
            public int extract(int position1, int position2) {
                if (this.topHydro != null && this.botHydro != null) {
                    this.c[Index.HC.ordinal()] = position1 < this.topHydro.length && position2 < this.botHydro.length ? this.topHydro[position1] + this.botHydro[position2] : 0;
                }
                return FeatureExtractor.this.cp.coord2int(this.c);
            }
        }
    }

    public static enum Index {
        DIST{

            @Override
            public int size(FeatureExtractor fe) {
                return fe.thresholds.length;
            }
        }
        ,
        HC{

            @Override
            public int size(FeatureExtractor fe) {
                return fe.options.hydrophobicModeling ? 3 : 1;
            }
        };


        public abstract int size(FeatureExtractor var1);
    }

    public static class FeatureOptions {
        @Option
        public boolean useLongGaps = true;
        @Option
        public int nQuantiles = 1;
        @Option
        public boolean hydrophobicModeling = true;
    }
}

