/*
 * Decompiled with CFR 0.152.
 */
package ev.poi.exp;

import ev.io.PreprocessGutellData;
import ev.poi.PoissonAlignerMain;
import ev.poi.PoissonModelSimulator;
import ev.poi.exp.PhylogeneticOutput;
import ev.poi.exp.PoissonSystem;
import ev.to.Clust;
import ev.to.ExternalMSASystem;
import ev.to.ExternalTreeSystem;
import fig.basic.Option;
import fig.exec.Execution;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import nuts.io.IO;
import nuts.util.IncrementalExperiment;

public class RandomExperiments
implements Runnable {
    @Option
    public String previouslyGeneratedFolder = "";
    @Option
    public String gutellPath = "";
    @Option
    public String gutellOutlierPath = "";
    @Option
    public int nOutliers = 0;
    private PoissonSystem poissonSystem;
    private IncrementalExperiment experiments;
    private PoissonModelSimulator.PoissonModelSimulatorMain simulator;

    public RandomExperiments(PoissonSystem poissonSystem, IncrementalExperiment experiments, PoissonModelSimulator.PoissonModelSimulatorMain simulator) {
        this.poissonSystem = poissonSystem;
        this.experiments = experiments;
        this.simulator = simulator;
    }

    public static void main(String[] args) {
        PoissonModelSimulator.PoissonModelSimulatorMain simulator = new PoissonModelSimulator.PoissonModelSimulatorMain();
        PoissonSystem.externalTreeSystem = new ExternalTreeSystem();
        PoissonSystem.externalMSASystem = new ExternalMSASystem();
        PoissonSystem poissonSystem = new PoissonSystem();
        IncrementalExperiment experiments = new IncrementalExperiment(poissonSystem);
        experiments.outputTypeClassPackage = PhylogeneticOutput.class.getPackage().getName();
        RandomExperiments sexp = new RandomExperiments(poissonSystem, experiments, simulator);
        IO.run(args, sexp, "sim", simulator, "exp", experiments, "system", poissonSystem, "treeinit", PoissonSystem.externalTreeSystem, "clust", Clust.class, "msainit", PoissonSystem.externalMSASystem, "tprop", PoissonAlignerMain.proposalOptions, "prop", PoissonAlignerMain.poissonProposalOptions, "nj", ExternalTreeSystem.nj, "phyml", ExternalTreeSystem.phyML);
    }

    @Override
    public void run() {
        File dataDir = null;
        if (!this.gutellPath.equals("")) {
            if (!this.previouslyGeneratedFolder.equals("")) {
                throw new RuntimeException();
            }
            dataDir = new File(Execution.getFile("gutell-random-subset"));
            PreprocessGutellData.createRandomGutellSplit(dataDir, new File(this.gutellPath), new File(this.gutellOutlierPath), this.simulator.nReplica, this.simulator.nTaxa, this.nOutliers, this.simulator.rand, (int)this.simulator.expectedLength);
        } else if (this.previouslyGeneratedFolder.equals("")) {
            dataDir = new File(Execution.getFile("generated"));
            this.simulator.generate(dataDir);
        } else {
            dataDir = new File(this.previouslyGeneratedFolder);
        }
        this.experiments.inputDirectory = dataDir;
        this.experiments.inputSuffixFilter = "msf";
        this.experiments.refDirectories = new ArrayList<File>(Arrays.asList(dataDir, dataDir));
        this.experiments.refOutputTypes = new ArrayList<String>(Arrays.asList("MSAOutput", "TreeOutput"));
        this.experiments.init();
        this.experiments.runSystem(this.poissonSystem);
    }
}

