/*
 * Decompiled with CFR 0.152.
 */
package nuts.remote;

import fig.basic.LogInfo;
import fig.exec.Execution;
import java.util.List;
import nuts.io.IO;
import nuts.util.CollUtils;
import nuts.util.EasyFormat;

public class ReportProgress
implements Runnable {
    public static final String TIME_REM_FILE = "progress.map";
    private static List<Integer> nDivisionsList = CollUtils.list();
    private static List<Integer> markList = CollUtils.list();
    private static long startTime = -1L;
    private static long lastRecordedTime = -1L;
    private static long printInterval = 30000L;
    private static long lastPrint = 0L;

    public static long estimateTimeRemaining(long start, long current, double fractionFinished) {
        double delta = current - start;
        return (long)(delta * (1.0 - fractionFinished) / fractionFinished);
    }

    public static long estimateTimeRemaining() {
        return ReportProgress.estimateTimeRemaining(startTime, lastRecordedTime, ReportProgress.estimateFractionCompleted());
    }

    public static String fmt(long duration) {
        long sec;
        long min;
        long hrs;
        StringBuilder result = new StringBuilder();
        long d = duration / 86400000L;
        if (d > 0L) {
            result.append("" + d + "d ");
        }
        if ((hrs = (duration %= 86400000L) / 3600000L) > 0L) {
            result.append("" + hrs + "h ");
        }
        if ((min = (duration %= 3600000L) / 60000L) > 0L) {
            result.append("" + min + "m ");
        }
        if ((sec = (duration %= 60000L) / 1000L) > 0L) {
            result.append("" + sec + "s ");
        }
        result.append("" + (duration %= 1000L) + "ms ");
        return result.toString();
    }

    public static int progressBlock(int nDivisions) {
        lastRecordedTime = System.currentTimeMillis();
        if (startTime == -1L) {
            startTime = System.currentTimeMillis();
        }
        nDivisionsList.add(nDivisions);
        markList.add(0);
        return nDivisions;
    }

    public static void divisionCompleted() {
        lastRecordedTime = System.currentTimeMillis();
        int currentMark = markList.get(markList.size() - 1);
        int currentNDiv = nDivisionsList.get(nDivisionsList.size() - 1);
        if (++currentMark == currentNDiv + 1) {
            nDivisionsList.remove(nDivisionsList.size() - 1);
            markList.remove(markList.size() - 1);
            currentMark = markList.get(markList.size() - 1);
            currentNDiv = nDivisionsList.get(nDivisionsList.size() - 1);
            ++currentMark;
        }
        markList.set(markList.size() - 1, currentMark);
        ReportProgress.update();
    }

    public static void update() {
        long currentT = System.currentTimeMillis();
        if (currentT - lastPrint > printInterval) {
            String s = "FractionCompleted: " + EasyFormat.fmt(100.0 * ReportProgress.estimateFractionCompleted()) + "%\n" + "EstimatedTimeRemaining: " + ReportProgress.fmt(ReportProgress.estimateTimeRemaining());
            LogInfo.logs(s);
            IO.writeToDisk(Execution.getFile(TIME_REM_FILE), s);
            lastPrint = currentT;
        }
    }

    public static double estimateFractionCompleted() {
        double sum = 0.0;
        double currentFraction = 1.0;
        if (nDivisionsList.size() != markList.size()) {
            throw new RuntimeException();
        }
        for (int i = 0; i < nDivisionsList.size(); ++i) {
            sum += currentFraction * ((double)markList.get(i).intValue() / (0.5 + (double)nDivisionsList.get(i).intValue()));
            currentFraction /= 0.5 + (double)nDivisionsList.get(i).intValue();
        }
        return sum;
    }

    public static void main(String[] args) {
        IO.run(args, new ReportProgress());
    }

    @Override
    public void run() {
        ReportProgress.progressBlock(10);
        for (int i = 0; i < 10; ++i) {
            ReportProgress.progressBlock(2);
            for (int j = 0; j < 2; ++j) {
                ReportProgress.divisionCompleted();
            }
            ReportProgress.divisionCompleted();
        }
    }
}

