/*
 * Decompiled with CFR 0.152.
 */
package pepper.editmodel;

import fig.basic.Option;
import fig.exec.Execution;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import nuts.io.IO;
import nuts.util.Counter;
import pepper.Edit;
import pepper.Encodings;
import pepper.editmodel.EditParam;

public class SinkWordSampler {
    private final Encodings enc;
    private Random random;
    private EditParam param;
    private String prevWord;
    private StringBuilder sampledWord;
    private List<Edit> sampledEdits;
    private int boundaryc;
    @Option(gloss="file to load words from", required=true)
    public static String inputFile;

    private Encodings enc() {
        return this.enc;
    }

    public SinkWordSampler(Random random, EditParam param, String prevWord) {
        this.enc = param.getEncodings();
        this.random = random;
        this.param = param;
        this.prevWord = prevWord;
        this.boundaryc = this.enc.getBoundaryEqClassId();
    }

    public static String sample(Random random, EditParam param, String prevWord) {
        SinkWordSampler sampler = new SinkWordSampler(random, param, prevWord);
        sampler.sample();
        return sampler.getSampledWord();
    }

    public void sample() {
        this.sampledWord = new StringBuilder();
        this.sampledEdits = new ArrayList<Edit>();
        for (int i = 0; i < this.prevWord.length(); ++i) {
            int x = this.enc().char2PhoneId(this.prevWord.charAt(i));
            int c1 = this.enc.topc(this.prevWord, i - 1);
            int c2 = this.enc.topc(this.prevWord, i + 1);
            this.sampleChar(c1, x, c2, this.param);
        }
    }

    private void sampleChar(int c1, int x, int c2, EditParam currentParam) {
        double rand = this.random.nextDouble();
        double currentSum = 0.0;
        if ((currentSum += currentParam.deletionCost(c1, x, c2)) > rand) {
            this.sampledWord.append("");
            this.sampledEdits.add(new Edit(this.enc, c1, x, c2));
            return;
        }
        for (int y = 0; y < this.enc().getNumberOfPhonemes(); ++y) {
            if ((currentSum += currentParam.substitutionCost(c1, x, c2, y)) > rand) {
                this.sampledWord.append("" + this.enc().phoneId2Char(y));
                this.sampledEdits.add(new Edit(this.enc, c1, x, c2, y));
                return;
            }
            for (int z = 0; z < this.enc().getNumberOfPhonemes(); ++z) {
                if (!((currentSum += currentParam.fissionCost(c1, x, c2, y, z)) > rand)) continue;
                this.sampledWord.append("" + this.enc().phoneId2Char(y) + this.enc().phoneId2Char(z));
                this.sampledEdits.add(new Edit(this.enc, c1, x, c2, y, z));
                return;
            }
        }
        throw new RuntimeException("This does not seem to add up to oneDataGenerator.generateChar()");
    }

    public List<Edit> getSampledEdits() {
        return this.sampledEdits;
    }

    public String getSampledWord() {
        return this.sampledWord.toString();
    }

    public static Counter<Environment> getEnvironments(Encodings enc, String word) {
        Counter<Environment> envCounts = new Counter<Environment>();
        for (int i = 0; i < word.length(); ++i) {
            int x = enc.char2PhoneId(word.charAt(i));
            int c1 = enc.topc(word, i - 1);
            int c2 = enc.topc(word, i + 1);
            Environment env = new Environment(enc, c1, x, c2);
            envCounts.incrementCount(env, 1.0);
        }
        return envCounts;
    }

    public static void main(String[] args) throws IOException {
        Execution.init(args, "envs", SinkWordSampler.class, "encodings", Encodings.class);
        Encodings enc = Encodings.realEncoding();
        Counter<Environment> counter = new Counter<Environment>();
        for (String line : IO.i(inputFile)) {
            counter.incrementAll(SinkWordSampler.getEnvironments(enc, line));
        }
        for (Environment env : counter) {
            IO.so("" + env.toString() + " : " + counter.getCount(env));
        }
        Execution.finish();
    }

    public static class Environment {
        private int c1;
        private int x;
        private int c2;
        private final Encodings enc;

        public Environment(Encodings enc, int c1, int x, int c2) {
            this.enc = enc;
            this.c1 = c1;
            this.c2 = c2;
            this.x = x;
        }

        public String toString() {
            return "" + this.enc.getEqClassDescription(this.c1) + " " + this.enc.phoneId2Char(this.x) + " " + this.enc.getEqClassDescription(this.c2);
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + this.c1;
            result = 31 * result + this.c2;
            result = 31 * result + this.x;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Environment other = (Environment)obj;
            if (this.c1 != other.c1) {
                return false;
            }
            if (this.c2 != other.c2) {
                return false;
            }
            return this.x == other.x;
        }
    }
}

