/*
 * Decompiled with CFR 0.152.
 */
package sage;

import fig.basic.IOUtils;
import fig.basic.LogInfo;
import goblin.CognateSet;
import goblin.DerivationTree;
import goblin.HLFeatureExtractor;
import goblin.HLParams;
import goblin.Taxon;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import nuts.io.Extensions;
import nuts.maxent.LabeledInstance;
import nuts.util.Arbre;
import nuts.util.Counter;
import nuts.util.CounterMap;
import nuts.util.Tree;
import pepper.Encodings;
import pepper.editmodel.Utils;
import sage.FLoad;
import sage.FatContext;
import sage.FatFeatureExtractor;

public class MartinetHypothesesCalculator {
    private final CounterMap<Taxon, String> ngrams;
    private final CounterMap<Taxon, String> changes;
    private final Counter<Taxon> freq;
    private final Tree<String> globalTopology;
    private final int nFeaturesDelta = 2;
    private final Encodings enc;
    private final Set<Taxon> languages;

    public MartinetHypothesesCalculator(Counter<LabeledInstance<HLParams.HLContext, HLParams.HLOutcome>> sufficientStatistics, CounterMap<Taxon, String> ngrams, Tree<String> globalTopology, Set<Taxon> languages) {
        this.languages = languages;
        this.ngrams = ngrams;
        this.changes = MartinetHypothesesCalculator.changes(sufficientStatistics);
        this.freq = MartinetHypothesesCalculator.freq(ngrams);
        this.globalTopology = globalTopology;
        this.enc = Encodings.getGlobalEncodings();
        FLoad.index(Encodings.getGlobalEncodings().allChars());
    }

    private static String key(char x, char y) {
        return x + ">" + y;
    }

    private static CounterMap<Taxon, String> changes(Counter<LabeledInstance<HLParams.HLContext, HLParams.HLOutcome>> sufficientStatistics) {
        CounterMap<Taxon, String> result = new CounterMap<Taxon, String>();
        for (LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> instance : sufficientStatistics.keySet()) {
            if (!HLFeatureExtractor.isSubstitution(instance)) continue;
            result.incrementCount(instance.getInput().botLang, MartinetHypothesesCalculator.key(instance.getInput().topChar(), instance.getLabel().outcomeChar()), sufficientStatistics.getCount(instance));
        }
        return result;
    }

    private static Counter<Taxon> freq(CounterMap<Taxon, String> ngrams2) {
        Counter<Taxon> result = new Counter<Taxon>();
        for (Taxon lang : ngrams2.keySet()) {
            for (String ngram : ngrams2.getCounter(lang).keySet()) {
                if (ngram.length() != 1) continue;
                result.incrementCount(lang, ngrams2.getCount(lang, ngram));
            }
        }
        return result;
    }

    public void weakPointStatistics(String prefix, Integer iteration) {
        String fileName = prefix + (iteration == null ? "" : Extensions.extension2String(iteration));
        PrintWriter out = IOUtils.openOutHard(Utils.safeGetExecFilePath(fileName));
        out.append("#Merger\tLanguages\tFunctionalLoad\tChangePr\tChangeCount\tDeltaFeatures\tLHSCount\tRHSCount\n");
        ArrayList<Character> charsList = new ArrayList<Character>(this.enc.allChars());
        LogInfo.track("Printing functional load statistics");
        List<Tree<String>> subts = this.globalTopology.getPreOrderTraversal();
        int langIndex = 0;
        for (Tree<String> subt : subts) {
            Taxon topL = new Taxon(subt.getLabel());
            if (!this.languages.contains(topL)) continue;
            LogInfo.logs("Language " + langIndex++ + "/" + this.languages.size());
            for (int i = 0; i < charsList.size(); ++i) {
                char p1 = ((Character)charsList.get(i)).charValue();
                for (int j = i + 1; j < charsList.size(); ++j) {
                    char p2 = ((Character)charsList.get(j)).charValue();
                    if (!this.comparable(p1, p2)) continue;
                    double fload = this.fload(topL, p1, p2);
                    for (Tree<String> child : subt.getChildren()) {
                        Taxon botL = new Taxon(child.getLabel());
                        this.weakPointStatistics(out, fload, topL, botL, p1, p2);
                        this.weakPointStatistics(out, fload, topL, botL, p2, p1);
                    }
                }
            }
        }
        LogInfo.end_track();
        out.close();
    }

    private void weakPointStatistics(PrintWriter out, double fload, Taxon topL, Taxon botL, char p1, char p2) {
        if (this.ngrams.getCount(topL, "" + p1) != 0.0) {
            double count = this.changes.getCount(botL, MartinetHypothesesCalculator.key(p1, p2));
            double changePr = count / this.ngrams.getCount(topL, "" + p1);
            out.append(MartinetHypothesesCalculator.key(p1, p2) + "\t");
            out.append("" + topL + ">" + botL + "\t");
            out.append(fload + "\t");
            out.append(changePr + "\t");
            out.append(count + "\t");
            out.append(this.nFeatDiff(p1, p2) + "\t");
            out.append(this.ngrams.getCount(topL, "" + p1) + "\t");
            out.append(this.ngrams.getCount(topL, "" + p2) + "\n");
        }
    }

    private String nFeatDiff(char p1, char p2) {
        List<String> diffFeatures = HLFeatureExtractor.modifiedFeatures(this.enc.char2PhoneId(p1), this.enc.char2PhoneId(p2), this.enc);
        if (diffFeatures == null) {
            return "N/A";
        }
        return "" + diffFeatures.size();
    }

    private double fload(Taxon lang, char x, char y) {
        double sum = 0.0;
        for (char left : this.enc.allChars()) {
            for (char right : this.enc.allChars()) {
                sum += this.ngrams.getCount(lang, "" + left + x + right) * this.ngrams.getCount(lang, "" + left + y + right);
            }
        }
        return sum / this.freq.getCount(lang) / this.freq.getCount(lang);
    }

    private boolean comparable(char p1, char p2) {
        if (p1 == p2) {
            return false;
        }
        return p1 != this.enc.boundChar() && p2 != this.enc.boundChar();
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        CognateSet cs = CognateSet.restoreCognateSet(args[0]);
        Encodings.registerEncodings(Encodings.restoreEncodings(args[1]));
        FatFeatureExtractor.forceContext();
        Counter<LabeledInstance<FatContext, HLParams.HLOutcome>> counter = new Counter<LabeledInstance<FatContext, HLParams.HLOutcome>>();
        Arbre<DerivationTree.DerivationNode> a = cs.getTree(cs.getCognateIds().iterator().next());
        FatContext.addSuffStats(counter, a, FatFeatureExtractor.granularities(), Encodings.getGlobalEncodings(), null);
        System.out.println(a.deepToString());
        System.out.println(counter);
    }
}

