/*
 * Decompiled with CFR 0.152.
 */
package scratch;

import java.text.Normalizer;
import java.util.HashSet;
import java.util.Set;

public class DiacriticsRemover {
    private static final Set<Character> badSet = DiacriticsRemover.badSet();

    private static Set<Character> badSet() {
        char[] spacingDiac;
        HashSet<Character> result = new HashSet<Character>();
        for (char c = '\u0300'; c <= '\u036f'; c = (char)(c + '\u0001')) {
            result.add(Character.valueOf(c));
        }
        for (char c : spacingDiac = new char[]{'\u02c8', '\u02cc', '\u02d0', '\u02d1', '\u02bc', '\u02b4', '\u02b0', '\u02b1', '\u02b2', '\u02b7', '\u02e0', '\u02e4', '\u02de', '\'', ':'}) {
            result.add(Character.valueOf(c));
        }
        return result;
    }

    public String removeDiacritics(String s) {
        s = Normalizer.normalize(s, Normalizer.Form.NFKD);
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (badSet.contains(Character.valueOf(c))) continue;
            result.append(c);
        }
        return result.toString();
    }
}

