/*
 * Decompiled with CFR 0.152.
 */
package unsupalg.hmm;

import fig.basic.Pair;
import java.util.List;
import java.util.Random;
import nuts.util.ApproxConsistencyCheck;
import unsupalg.hmm.GibbsEStep;
import unsupalg.hmm.Param;
import unsupalg.hmm.ParamUtils;
import unsupalg.hmm.RescaledBaumWelch;
import unsupalg.hmm.SuffStat;

public interface EStep {
    public void compute(List<Integer> var1, Param var2);

    public double logll();

    public int length();

    public List<Integer> observations();

    public double[] oneNodePosterior(int var1);

    public double[][] twoNodesPosterior(int var1);

    public static class EStepTest
    extends ApproxConsistencyCheck<EStep> {
        private Param params;
        private List<Integer> obs;

        public EStepTest() {
            Random rand = new Random(1L);
            this.params = ParamUtils.randomUniParam(rand, 3, 2);
            this.obs = ParamUtils.generateObservations(rand, this.params, 20);
        }

        @Override
        public ApproxConsistencyCheck.MetricElt test(EStep implementation) {
            implementation.compute(this.obs, this.params);
            SuffStat suffStat = new SuffStat(this.params.nStates(), this.params.nObs());
            suffStat.addFromPosterior(implementation);
            return suffStat;
        }

        public static void main(String[] args) {
            Random rand = new Random(1L);
            Param params = ParamUtils.randomUniParam(rand, 3, 2);
            System.out.println(params.toString());
            Pair<List<Integer>, List<Integer>> pair = ParamUtils.generateStateObservations(rand, params, 20);
            EStepTest test = new EStepTest();
            test.threshold = 0.05;
            if (!test.consistent(new RescaledBaumWelch(), new GibbsEStep(new Random(1L)))) {
                System.out.println(test.report());
            }
        }
    }
}

