/*
 * Decompiled with CFR 0.152.
 */
package web;

import fig.basic.Option;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import nuts.io.IO;
import nuts.tui.Table;

public class ConvertSchedule
implements Runnable {
    @Option
    public String csvSchedulePath = "/Users/bouchard/Documents/courses/stat547-fa2011/misc/schedule.csv";
    @Option
    public String htmlFilePath = "/Users/bouchard/Documents/courses/stat547-fa2011/web/stat547-fa2011/index.html";
    @Option
    public String tag = "<!-- schedule -->";
    @Option
    public String lectureNotesFolder = "/Users/bouchard/Documents/courses/stat547-fa2011/web/stat547-fa2011/lectures/";
    @Option
    public int nDayMaxLookahead = 10;

    public static void main(String[] args) {
        IO.runLight(args, new ConvertSchedule());
    }

    @Override
    public void run() {
        String str = IO.f2s(this.htmlFilePath);
        IO.writeToDisk(this.htmlFilePath + ".backup", str);
        Table t = new Table();
        int r = 0;
        for (List<String> fields : IO.iCSV(this.csvSchedulePath)) {
            for (String x : fields) {
                if (!x.contains("\n")) continue;
                throw new RuntimeException("MAKE SURE THERE ARE NOT NEW LINES IN THE INDIVIDUAL CSV ENTRIES");
            }
            int c = 0;
            for (String f : fields) {
                if (c == 0) {
                    f = this.lectureNoteLink(f);
                } else if (r != 0 && c >= 2 && this.farFuture(fields.get(0))) {
                    f = "";
                } else if (f.matches("Exercise.*")) {
                    f = "<a href=\"files/" + f.replaceAll("\\s", "").toLowerCase() + ".pdf\">" + f + "</a>";
                } else if (f.matches("Assignment.*")) {
                    f = "<a href=\"files/" + f.replaceAll("\\s", "").toLowerCase() + ".pdf\">" + f + "</a>";
                } else {
                    f = f.replaceAll("G[+]S ", "<a href=\"#GS\">G+S</a> ");
                    f = f.replaceAll("Du ", "<a href=\"#Du\">Du</a> ");
                    f = f.replaceAll("Bi ", "<a href=\"#Bi\">Bi</a> ");
                    f = f.replaceAll("SR ", "<a href=\"#SR\">SR</a> ");
                    f = f.replaceAll("ACD ", "<a href=\"#ACD\">ACD</a> ");
                    f = f.replaceAll("WJ ", "<a href=\"#WJ\">WJ</a> ");
                    f = f.replaceAll("BD ", "<a href=\"#BD\">BD</a> ");
                }
                t.set(r, c, f);
                ++c;
            }
            ++r;
        }
        boolean first = true;
        StringBuilder transformed = new StringBuilder();
        for (String line : str.split("\n")) {
            if (line.contains(this.tag)) {
                if (first) {
                    for (String subline : t.toHTML().split("\n")) {
                        transformed.append("" + this.tag + " " + subline + "\n");
                    }
                }
                first = false;
                continue;
            }
            transformed.append(line + "\n");
        }
        IO.writeToDisk(this.htmlFilePath, transformed.toString());
    }

    private boolean farFuture(String string) {
        String month = string.split("\\s+")[0].substring(0, 3);
        Calendar now = Calendar.getInstance();
        int yr = now.get(1);
        String fullStr = month + " " + string.replaceAll("[^0-9]*", "") + " " + yr;
        SimpleDateFormat df = new SimpleDateFormat("MMM d yyyy", Locale.US);
        try {
            Date result = df.parse(fullStr);
            long resultMilli = result.getTime();
            long nowMilli = now.getTimeInMillis();
            long delta = resultMilli - nowMilli;
            long maxDelta = this.nDayMaxLookahead * 24 * 60 * 60 * 1000;
            return delta > maxDelta;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private String lectureNoteLink(String f) {
        File derivedFile = new File(this.lectureNotesFolder, f.toLowerCase().replaceAll("\\s+", "") + ".pdf");
        if (derivedFile.exists()) {
            return "<a href=\"lectures/" + derivedFile.getName() + "\">" + f + "</a>";
        }
        return f;
    }
}

