/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.processing;

import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import spoon.Launcher;
import spoon.compiler.SpoonResource;
import spoon.reflect.factory.Factory;
import spoon.support.processing.XmlProcessorProperties;

public class SpoonletXmlHandler
extends DefaultHandler {
    private Factory factory;
    private Launcher launcher;
    private List<SpoonResource> spoonletIndex;
    XmlProcessorProperties prop;
    String propName;
    List<Object> values;
    String buffer;

    public SpoonletXmlHandler(Factory factory, Launcher launcher, List<SpoonResource> spoonletIndex) {
        this.factory = factory;
        this.launcher = launcher;
        this.spoonletIndex = spoonletIndex;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (localName.equals("processor")) {
            this.factory.getEnvironment().setProcessorProperties(this.prop.getProcessorName(), this.prop);
            this.prop = null;
        } else if (localName.equals("property")) {
            if (this.values != null) {
                this.prop.addProperty(this.propName, this.values);
            }
            this.values = null;
            this.propName = null;
        } else if (localName.equals("value")) {
            this.values.add(this.buffer);
        }
        this.buffer = null;
        super.endElement(uri, localName, qName);
    }

    @Override
    public void characters(char[] ch, int start, int end) throws SAXException {
        this.buffer = new String(ch, start, end);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (localName.equals("processor")) {
            this.launcher.addProcessor(attributes.getValue("class"));
            this.prop = new XmlProcessorProperties(this.factory, attributes.getValue("class"));
        } else if (localName.equals("template")) {
            String foldername;
            if (attributes.getValue("path") != null) {
                foldername = attributes.getValue("path");
                for (SpoonResource r : this.spoonletIndex) {
                    if (!r.getName().startsWith(foldername)) continue;
                    this.launcher.addTemplateResource(r);
                }
            }
            if (attributes.getValue("folder") != null) {
                foldername = attributes.getValue("folder");
                for (SpoonResource r : this.spoonletIndex) {
                    if (!r.getName().startsWith(foldername)) continue;
                    this.launcher.addTemplateResource(r);
                }
            }
            if (attributes.getValue("file") != null) {
                String filename = attributes.getValue("file");
                for (SpoonResource r : this.spoonletIndex) {
                    if (!r.getName().startsWith(filename)) continue;
                    this.launcher.addTemplateResource(r);
                }
            }
        } else if (localName.equals("property")) {
            this.propName = attributes.getValue("name");
            if (attributes.getValue("value") != null) {
                this.prop.addProperty(this.propName, attributes.getValue("value"));
            } else {
                this.values = new ArrayList<Object>();
            }
        }
    }
}

