/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.template;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import spoon.Launcher;
import spoon.reflect.code.CtArrayAccess;
import spoon.reflect.code.CtCodeElement;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtType;
import spoon.reflect.factory.Factory;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.support.template.UndefinedParameterException;
import spoon.support.util.RtHelper;
import spoon.template.Parameter;
import spoon.template.Template;
import spoon.template.TemplateParameter;

public abstract class Parameters {
    protected static final String fieldPrefix = "_FIELD_";
    static Map<Template<?>, Map<String, Object>> finals = new HashMap();
    static CtTypeReference<TemplateParameter<?>> templateParameterType;

    private Parameters() {
    }

    public static Integer getIndex(CtExpression<?> e) {
        if (e.getParent() instanceof CtArrayAccess) {
            CtExpression<Integer> indexExpression = ((CtArrayAccess)e.getParent()).getIndexExpression();
            return (Integer)((CtLiteral)indexExpression).getValue();
        }
        return null;
    }

    public static Object getValue(Template<?> template, String parameterName, Integer index) {
        Object tparamValue = null;
        try {
            Field rtField = null;
            for (Field f : RtHelper.getAllFields(template.getClass())) {
                if (!Parameters.isParameterSource(f) || !parameterName.equals(Parameters.getParameterName(f))) continue;
                rtField = f;
                break;
            }
            if (Modifier.isFinal(rtField.getModifiers())) {
                Map<String, Object> m = finals.get(template);
                if (m == null) {
                    return null;
                }
                return m.get(parameterName);
            }
            rtField.setAccessible(true);
            tparamValue = rtField.get(template);
            if (rtField.getType().isArray() && index != null) {
                tparamValue = ((Object[])tparamValue)[index];
            }
        }
        catch (Exception e) {
            throw new UndefinedParameterException();
        }
        return tparamValue;
    }

    public static CtField<?> getParameterField(CtClass<? extends Template<?>> templateClass, String parameterName) {
        for (CtField<?> f : templateClass.getFields()) {
            Parameter p = f.getAnnotation(Parameter.class);
            if (p == null) continue;
            if (f.getSimpleName().equals(parameterName)) {
                return f;
            }
            if (!parameterName.equals(p.value())) continue;
            return f;
        }
        return null;
    }

    public static void setValue(Template<?> template, String parameterName, Integer index, Object value) {
        Object tparamValue = null;
        try {
            Field rtField = null;
            for (Field f : RtHelper.getAllFields(template.getClass())) {
                if (!Parameters.isParameterSource(f) || !parameterName.equals(Parameters.getParameterName(f))) continue;
                rtField = f;
                break;
            }
            if (rtField == null) {
                return;
            }
            if (Modifier.isFinal(rtField.getModifiers())) {
                Map<String, Object> m = finals.get(template);
                if (m == null) {
                    m = new HashMap<String, Object>();
                    finals.put(template, m);
                }
                m.put(parameterName, value);
                return;
            }
            rtField.setAccessible(true);
            rtField.set(template, value);
            if (rtField.getType().isArray()) {
                tparamValue = ((Object[])tparamValue)[index];
            }
        }
        catch (Exception e) {
            throw new UndefinedParameterException();
        }
    }

    private static String getParameterName(Field f) {
        String name = f.getName();
        Parameter p = f.getAnnotation(Parameter.class);
        if (p != null && !p.value().equals("")) {
            name = p.value();
        }
        return name;
    }

    private static String getParameterName(CtFieldReference<?> f) {
        String name = f.getSimpleName();
        Parameter p = f.getDeclaration().getAnnotation(Parameter.class);
        if (p != null && !p.value().equals("")) {
            name = p.value();
        }
        return name;
    }

    public static Collection<String> getNames(CtClass<? extends Template<?>> templateType) {
        ArrayList<String> params = new ArrayList<String>();
        try {
            for (CtFieldReference<?> f : templateType.getReference().getAllFields()) {
                if (!Parameters.isParameterSource(f)) continue;
                params.add(Parameters.getParameterName(f));
            }
        }
        catch (Exception e) {
            Launcher.logger.error(e.getMessage(), e);
        }
        return params;
    }

    public static boolean isParameterSource(CtFieldReference<?> ref) {
        return ref.getDeclaration() != null && ref.getDeclaration().getAnnotation(Parameter.class) != null || !(ref.getType() instanceof CtTypeParameterReference) && !ref.getSimpleName().equals("this") && Parameters.getTemplateParameterType(ref.getFactory()).isAssignableFrom(ref.getType());
    }

    public static boolean isParameterSource(Field field) {
        return field.getAnnotation(Parameter.class) != null || TemplateParameter.class.isAssignableFrom(field.getType());
    }

    private static synchronized CtTypeReference<TemplateParameter<?>> getTemplateParameterType(Factory factory) {
        if (templateParameterType == null) {
            templateParameterType = factory.Type().createReference(TemplateParameter.class);
        }
        return templateParameterType;
    }

    public static <T> TemplateParameter<T> NIL(Class<? extends T> type) {
        if (Number.class.isAssignableFrom(type)) {
            return new TemplateParameter<Number>(){

                public CtCodeElement getSubstitution(CtType<?> targetType) {
                    return null;
                }

                @Override
                public Number S() {
                    return 0;
                }
            };
        }
        return new TemplateParameter<T>(){

            public CtCodeElement getSubstitution(CtType<?> targetType) {
                return null;
            }

            @Override
            public T S() {
                return null;
            }
        };
    }

    public static List<Field> getAllTemplateParameterFields(Class<? extends Template> clazz) {
        if (!Template.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException();
        }
        ArrayList<Field> result = new ArrayList<Field>();
        for (Field f : RtHelper.getAllFields(clazz)) {
            if (!Parameters.isParameterSource(f)) continue;
            result.add(f);
        }
        return result;
    }

    public static List<CtField<?>> getAllTemplateParameterFields(Class<? extends Template<?>> clazz, Factory factory) {
        CtType c = factory.Class().get((Class)clazz);
        if (c == null) {
            throw new IllegalArgumentException("Template not in template classpath");
        }
        ArrayList result = new ArrayList();
        for (Field f : Parameters.getAllTemplateParameterFields(clazz)) {
            result.add(c.getField(f.getName()));
        }
        return result;
    }
}

