/*
 * Decompiled with CFR 0.152.
 */
package org.forester.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.forester.util.ForesterUtil;

public final class CommandLineArguments {
    private static final String OPTIONS_PREFIX = "-";
    private static final String EXTENDED_OPTIONS_PREFIX = "--";
    private static final String OPTIONS_SEPARATOR = "=";
    private Map<String, String> _options;
    private Map<String, String> _extended_options;
    private List<String> _names;
    private String _command_line_str;

    public CommandLineArguments(String[] stringArray) throws IOException {
        this.init();
        this.parseCommandLineArguments(stringArray);
    }

    private Map<String, String> getAllOptions() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.putAll(this.getOptionsList());
        hashMap.putAll(this.getExtendedOptionsList());
        return hashMap;
    }

    public String getCommandLineArgsAsString() {
        return this._command_line_str;
    }

    private Map<String, String> getExtendedOptionsList() {
        return this._extended_options;
    }

    public File getFile(int n) {
        return new File(this.getNames()[n]);
    }

    public String getName(int n) {
        return this.getNames()[n];
    }

    public String[] getNames() {
        String[] stringArray = new String[this.getNamesList().size()];
        return this.getNamesList().toArray(stringArray);
    }

    private List<String> getNamesList() {
        return this._names;
    }

    public int getNumberOfNames() {
        return this.getNames().length;
    }

    private Map<String, String> getOptionsList() {
        return this._options;
    }

    public String getOptionValue(String string) throws IllegalArgumentException {
        Map<String, String> map = this.getAllOptions();
        if (map.containsKey(string)) {
            String string2 = map.get(string);
            if (!ForesterUtil.isEmpty(string2)) {
                return string2;
            }
            throw new IllegalArgumentException("value for \"" + string + "\" is not set");
        }
        throw new IllegalArgumentException("option \"" + string + "\" is not set");
    }

    public String getOptionValueAsCleanString(String string) throws IllegalArgumentException {
        return this.getOptionValue(string).replaceAll("\"", "").replaceAll("'", "");
    }

    public double getOptionValueAsDouble(String string) throws IOException {
        double d = -1.7976931348623157E308;
        try {
            d = new Double(this.getOptionValue(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("value for option \"" + string + "\" is expected to be of type double");
        }
        return d;
    }

    public int getOptionValueAsInt(String string) throws IOException {
        int n = Integer.MIN_VALUE;
        try {
            n = new Integer(this.getOptionValue(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("value for option \"" + string + "\" is expected to be of type integer");
        }
        return n;
    }

    public long getOptionValueAsLong(String string) throws IOException {
        long l = Long.MIN_VALUE;
        try {
            l = new Long(this.getOptionValue(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("value for option \"" + string + "\" is expected to be of type long");
        }
        return l;
    }

    private void init() {
        this._options = new HashMap<String, String>();
        this._extended_options = new HashMap<String, String>();
        this._names = new ArrayList<String>();
        this._command_line_str = "";
    }

    public boolean isOptionHasAValue(String string) {
        Map<String, String> map = this.getAllOptions();
        if (map.containsKey(string)) {
            String string2 = map.get(string);
            return !ForesterUtil.isEmpty(string2);
        }
        throw new IllegalArgumentException("option \"" + string + "\" is not set");
    }

    public boolean isOptionSet(String string) {
        Map<String, String> map = this.getAllOptions();
        return map.containsKey(string);
    }

    public boolean isOptionValueSet(String string) throws IllegalArgumentException {
        Map<String, String> map = this.getAllOptions();
        if (map.containsKey(string)) {
            return !ForesterUtil.isEmpty(map.get(string));
        }
        throw new IllegalArgumentException("option \"" + string + "\" is not set");
    }

    private void parseCommandLineArguments(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i].trim();
            this._command_line_str = this._command_line_str + string;
            if (i < stringArray.length - 1) {
                this._command_line_str = this._command_line_str + " ";
            }
            if (string.startsWith(EXTENDED_OPTIONS_PREFIX)) {
                this.parseOption(string.substring(EXTENDED_OPTIONS_PREFIX.length()), this.getExtendedOptionsList());
                continue;
            }
            if (string.startsWith(OPTIONS_PREFIX)) {
                this.parseOption(string.substring(OPTIONS_PREFIX.length()), this.getOptionsList());
                continue;
            }
            this.getNamesList().add(string);
        }
    }

    private void parseOption(String string, Map<String, String> map) throws IOException {
        int n = string.indexOf(OPTIONS_SEPARATOR);
        if (n < 1) {
            if (ForesterUtil.isEmpty(string)) {
                throw new IOException("attempt to set option with an empty name");
            }
            if (this.getAllOptions().containsKey(string)) {
                throw new IOException("attempt to set option \"" + string + "\" mutiple times");
            }
            map.put(string, null);
        } else {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            if (ForesterUtil.isEmpty(string2)) {
                throw new IllegalArgumentException("attempt to set option with an empty name");
            }
            if (this.getAllOptions().containsKey(string2)) {
                throw new IllegalArgumentException("attempt to set option \"" + string2 + "\" mutiple times [" + string + "]");
            }
            map.put(string2, string3);
        }
    }

    public List<String> validateAllowedOptions(List<String> list) {
        Map<String, String> map = this.getAllOptions();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : map.keySet()) {
            if (list.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public String validateAllowedOptionsAsString(List<String> list) {
        List<String> list2 = this.validateAllowedOptions(list);
        String string = "";
        Iterator<String> iterator = list2.iterator();
        while (iterator.hasNext()) {
            string = string + "\"" + iterator.next();
            if (iterator.hasNext()) {
                string = string + "\", ";
                continue;
            }
            string = string + "\"";
        }
        return string;
    }

    public List<String> validateMandatoryOptions(List<String> list) {
        Map<String, String> map = this.getAllOptions();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            String string2 = string;
            if (map.containsKey(string2)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public String validateMandatoryOptionsAsString(List<String> list) {
        List<String> list2 = this.validateMandatoryOptions(list);
        String string = "";
        Iterator<String> iterator = list2.iterator();
        while (iterator.hasNext()) {
            string = string + "\"" + iterator.next();
            if (iterator.hasNext()) {
                string = string + "\", ";
                continue;
            }
            string = string + "\"";
        }
        return string;
    }
}

