/*
 * Decompiled with CFR 0.152.
 */
package tutorialj;

import com.google.common.base.Joiner;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtType;
import tutorialj.NoJump;
import tutorialj.Tutorial;

public class TutorialNode {
    private final Tutorial annotation;
    private final CtMethod<?> element;

    public TutorialNode(Tutorial annotation, CtElement element) {
        this.annotation = annotation;
        this.element = (CtMethod)element;
    }

    public boolean hasJump() {
        if (this.annotation.nextStep() == null) {
            return false;
        }
        return !this.annotation.nextStep().equals(NoJump.class);
    }

    public String getJumpTarget() {
        return TutorialNode.removeFirstPartOfSignature(this.annotation.nextStep().toString());
    }

    public boolean isTutorialStart() {
        if (this.annotation.startTutorial() == null) {
            return false;
        }
        return !this.annotation.startTutorial().equals("");
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        String comments = this.element.getDocComment();
        if (comments != null) {
            result.append(TutorialNode.removeFirstSpaceOfEachLine(comments) + "\n");
        }
        StringBuilder sourceBlock = new StringBuilder();
        if (this.annotation.showSignature()) {
            sourceBlock.append(TutorialNode.fullSignature(this.element) + "\n");
        }
        if (this.annotation.showSource()) {
            if (this.annotation.showSignature()) {
                sourceBlock.append("{\n");
            }
            sourceBlock.append(TutorialNode.code(this.element).replaceFirst("\\n\\s+$", "\n"));
            if (this.annotation.showSignature()) {
                sourceBlock.append("}\n");
            }
        }
        if (sourceBlock.length() > 0) {
            result.append("```java\n");
            result.append(TutorialNode.removeManyFirstSpacesOfEachLine(sourceBlock.toString()));
            result.append("```\n");
        }
        if (this.annotation.showLink()) {
            String className = this.getEnclosingTypeName();
            result.append(this.annotation.linkTextPrefix() + "[" + className + "](" + this.annotation.linkPrefix() + "/" + className.replace('.', '/') + ".java)" + this.annotation.linkTextSuffix() + "\n");
        }
        return result.toString();
    }

    public int getLineNumber() {
        return this.element.getPosition().getLine() - 1;
    }

    public String getEnclosingTypeName() {
        CtType element = this.element.getPosition().getCompilationUnit().getMainType();
        return TutorialNode.removeFirstPartOfSignature(element.getSignature());
    }

    private static String removeFirstPartOfSignature(String s) {
        return s.replaceFirst("(class|interface|[@]interface)\\s+", "");
    }

    private static String removeFirstSpaceOfEachLine(String comments) {
        StringBuilder result = new StringBuilder();
        for (String line : comments.split("\\n")) {
            if (!line.isEmpty() && line.charAt(0) == ' ') {
                line = line.substring(1);
            }
            result.append(line + "\n");
        }
        return result.toString();
    }

    private static String removeManyFirstSpacesOfEachLine(String contents) {
        int min = Integer.MAX_VALUE;
        for (String line : contents.split("\\n")) {
            if (line.matches("^\\s*$")) continue;
            int current = 0;
            for (char aChar : line.toCharArray()) {
                if (aChar != ' ') break;
                ++current;
            }
            if (current >= min) continue;
            min = current;
        }
        StringBuilder result = new StringBuilder();
        for (String line : contents.split("\\n")) {
            result.append((line.matches("^\\s*$") ? "" : line.substring(min)) + "\n");
        }
        return result.toString();
    }

    private static String fullSignature(CtMethod<?> m) {
        return (m.getModifiers().isEmpty() ? "" : Joiner.on((String)" ").join((Iterable)m.getModifiers()) + " ") + m.getSignature() + (m.getThrownTypes().isEmpty() ? "" : " throws " + Joiner.on((String)", ").join((Iterable)m.getThrownTypes()));
    }

    private static String code(CtMethod<?> m) {
        SourcePosition p = m.getBody().getPosition();
        return m.getPosition().getCompilationUnit().getOriginalSourceCode().substring(p.getSourceStart(), p.getSourceEnd()).replaceFirst("^\\s*\\n", "");
    }
}

