/*
 * Decompiled with CFR 0.152.
 */
package conifer.largemove;

import fig.basic.Pair;
import goblin.Taxon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import nuts.math.Graph;
import nuts.util.Arbre;
import pty.RootedTree;
import pty.UnrootedTree;

public class LargeMoveUtils {
    public static int shuffle(int current, int first, int second) {
        if (current == first) {
            return second;
        }
        if (current == second) {
            return first;
        }
        return current;
    }

    public static RootedTree nextRooting(UnrootedTree unrooted, Random rand) {
        Graph<Taxon> topology = unrooted.getTopology();
        if (topology.vertexSet().size() == 2) {
            throw new RuntimeException("Not supported");
        }
        ArrayList<Taxon> taxa = new ArrayList<Taxon>(topology.vertexSet());
        Collections.sort(taxa);
        for (int i = 0; i < 1000; ++i) {
            Taxon current = (Taxon)taxa.get(rand.nextInt(taxa.size()));
            if (topology.nbrs(current).size() <= 1) continue;
            return unrooted.reRootAtNode(current);
        }
        throw new RuntimeException();
    }

    static Taxon[] originalTaxonOrder(Taxon parent, Graph<Taxon> topology, Pair<Arbre<Taxon>, Arbre<Taxon>> edge) {
        List[] nbrs = new List[]{new ArrayList<Taxon>(topology.nbrs(edge.getFirst().getContents())), new ArrayList<Taxon>(topology.nbrs(edge.getSecond().getContents()))};
        for (int i = 0; i < 2; ++i) {
            List nbr = nbrs[i];
            if (!nbr.remove(i == 0 ? edge.getSecond().getContents() : edge.getFirst().getContents())) {
                throw new RuntimeException();
            }
            Collections.sort(nbr);
        }
        if (parent != null) {
            if (!((Taxon)nbrs[0].get(0)).equals(parent)) {
                Collections.swap(nbrs[0], 0, nbrs[0].indexOf(parent));
            }
            if (!((Taxon)nbrs[0].get(0)).equals(parent)) {
                throw new RuntimeException();
            }
        }
        Taxon[] result = new Taxon[4];
        int topSize = nbrs[0].size();
        int botSize = nbrs[1].size();
        int resultIndex = 0;
        for (int i = 0; i < 2; ++i) {
            if (topSize != 2 || botSize != 2) {
                if (topSize == 1 && botSize == 2 && i == 0) {
                    result[resultIndex++] = null;
                } else if (topSize != 2 || botSize != 1) {
                    throw new RuntimeException();
                }
            }
            for (Taxon t : nbrs[i]) {
                result[resultIndex++] = t;
            }
        }
        return result;
    }
}

