/*
 * Decompiled with CFR 0.152.
 */
package conifer.proposals;

import conifer.Phylogeny;
import conifer.data.PhylogeneticData;
import conifer.msa.InformedProposals;
import conifer.msa.MSAUtils;
import conifer.particle.FiniteGenerationParticle;
import conifer.particle.PhyloParticle;
import conifer.particle.PhyloParticleInitContext;
import conifer.particle.TreeProvider;
import conifer.proposals.ProposalModel;
import conifer.proposals.TwoStageMethodProvider;
import conifer.trees.TreeOptions;
import ev.par.ExponentialFamily;
import ev.poi.processors.TreeDistancesProcessor;
import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.OptionSet;
import goblin.Taxon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import ma.MSAPoset;
import ma.SequenceType;
import monaco.prop.AbstractProposalOptions;
import monaco.prop.ProposalProvider;
import nuts.util.CollUtils;
import pty.RootedTree;
import pty.io.Dataset;
import pty.smc.LazyParticleFilter;
import pty.smc.PartialCoalescentState;
import pty.smc.PriorPriorKernel;
import pty.smc.models.CTMC;

public class ProposalOptions
extends AbstractProposalOptions<PhyloParticle> {
    @Option
    public ArrayList<ProposalModel> proposalModels = new ArrayList();
    @OptionSet(name="initTree")
    public TreeOptions initTreeOptions = new TreeOptions();
    @Option
    public boolean initTreeFromDataEvenWhenHeldout = false;
    @Option
    public TreeInitMethod treeInitMethod = TreeInitMethod.DATA;
    @Option
    public MSAInitMethod msaInitMethod = MSAInitMethod.APPROX_PAIR;
    @Option
    public boolean initMSAFromDataEvenWhenHeldout = false;
    @Option(gloss="If the types of particles used by this proposal is not naturally bounded (i.e. tree particles), this specifies the number of generations to run the algorithm")
    public int nGenerations = 100000;
    @Option
    public double multiplicativeBranchProposalScaling = 1.4;
    @Option
    public double globalMultiplicativeBranchProposalScaling = 1.2;
    @Option
    public boolean skipConsistencyCheck = true;
    @Option
    public boolean useTwoStageMethod = false;
    public ProposalOptions nested = null;
    @Option
    public boolean forceTreeMSAParticles = false;
    @Option
    public double informedProposalThreshold = 0.9;

    @Override
    public List<ProposalProvider<PhyloParticle>> getProviders() {
        ArrayList<ProposalProvider<PhyloParticle>> result = CollUtils.list();
        for (ProposalModel model : this.proposalModels) {
            result.add(model.getProposalProvider(this));
        }
        return result;
    }

    public PhyloParticleInitContext.MSAProvider getMSAProvider(PhylogeneticData dataBeforeHeldout, PhylogeneticData dataAfterHeldout) {
        if (this.msaInitMethod == MSAInitMethod.DATA) {
            MSAPoset fromData = dataAfterHeldout.getMsa();
            if (fromData.edges().isEmpty()) {
                if (!this.initMSAFromDataEvenWhenHeldout) {
                    throw new RuntimeException();
                }
                LogInfo.warning("Initializing with input alignment!");
                if (dataBeforeHeldout.getMsa() == null) {
                    throw new RuntimeException();
                }
                return new PhyloParticleInitContext.SingletonMSAProvider(dataBeforeHeldout.getMsa());
            }
            return new PhyloParticleInitContext.SingletonMSAProvider(fromData);
        }
        if (this.msaInitMethod == MSAInitMethod.EMPTY) {
            MSAPoset empty = new MSAPoset(dataAfterHeldout.getMsa().sequences());
            return new PhyloParticleInitContext.SingletonMSAProvider(empty);
        }
        if (this.msaInitMethod == MSAInitMethod.PAIR) {
            Map<Taxon, String> sequences = dataBeforeHeldout.getMsa().sequences();
            LogInfo.warning("Assuming RNA data in this version");
            ExponentialFamily expFam = MSAUtils.loadBasicRNAAligner();
            return new PhyloParticleInitContext.SingletonMSAProvider(MSAPoset.maxRecallMSA(sequences, expFam.allPairsPosterior(sequences)));
        }
        if (this.msaInitMethod == MSAInitMethod.APPROX_PAIR) {
            Map<Taxon, String> sequences = dataBeforeHeldout.getMsa().sequences();
            LogInfo.warning("Assuming RNA data in this version");
            ExponentialFamily expFam = MSAUtils.loadBasicRNAAligner();
            return new PhyloParticleInitContext.SingletonMSAProvider(InformedProposals.getSingleton(this.informedProposalThreshold, sequences, expFam).getMaxRecallAlignment(sequences));
        }
        throw new RuntimeException();
    }

    public TreeProvider getTreeProvider(PhylogeneticData dataBeforeHeldout, PhylogeneticData dataAfterHeldout, MSAPoset msa) {
        if (this.treeInitMethod == TreeInitMethod.DATA) {
            Phylogeny fromData = dataAfterHeldout.getPhylogeny();
            if (fromData == null) {
                if (!this.initTreeFromDataEvenWhenHeldout) {
                    throw new RuntimeException();
                }
                LogInfo.warning("Initializing with input tree!");
                if (dataBeforeHeldout.getPhylogeny() == null) {
                    throw new RuntimeException();
                }
                return new TreeProvider.SingletonTreeProvider(dataBeforeHeldout.getPhylogeny());
            }
            return new TreeProvider.SingletonTreeProvider(fromData);
        }
        if (this.treeInitMethod == TreeInitMethod.RANDOM) {
            return this.initTreeOptions;
        }
        if (this.treeInitMethod == TreeInitMethod.SMC) {
            LazyParticleFilter.ParticleFilterOptions options = new LazyParticleFilter.ParticleFilterOptions();
            options.nParticles = 10000;
            options.nThreads = 1;
            options.resampleLastRound = true;
            options.parallelizeFinalParticleProcessing = true;
            options.finalMaxNUniqueParticles = 1000;
            options.maxNUniqueParticles = 1000;
            options.rand = this.initTreeOptions.rand;
            options.verbose = true;
            Dataset dataset = Dataset.DatasetUtils.fromAlignment(msa, SequenceType.RNA);
            CTMC.SimpleCTMC ctmc = CTMC.SimpleCTMC.dnaCTMC(dataset.nSites());
            PartialCoalescentState init = PartialCoalescentState.initFastState(dataset, ctmc);
            PriorPriorKernel pk2 = new PriorPriorKernel(init);
            LazyParticleFilter<PartialCoalescentState> lpf = new LazyParticleFilter<PartialCoalescentState>(pk2, options);
            TreeDistancesProcessor tdp = new TreeDistancesProcessor();
            lpf.sample(tdp);
            RootedTree p = RootedTree.Util.centroidRooting(tdp.getConsensus(true));
            return new TreeProvider.SingletonTreeProvider(p);
        }
        throw new RuntimeException();
    }

    public PhyloParticle getInitialParticle() {
        if (this.proposalModels.isEmpty()) {
            throw new RuntimeException("At least one proposal has to be defined");
        }
        return this.proposalModels.get(0).getInitialParticle(this);
    }

    @Override
    public ProposalProvider<PhyloParticle> getProposalCombination() {
        if (this.useTwoStageMethod) {
            ProposalProvider<PhyloParticle> firsts = super.getProposalCombination();
            ProposalProvider<PhyloParticle> seconds = this.nested.getProposalCombination();
            if (this.proposalModels.size() != 1 || this.proposalModels.get(0) != ProposalModel.SIMPLE_PRIOR_PRIOR || this.nested.proposalModels.size() == 0 || this.nested.proposalModels.get(0) == ProposalModel.SIMPLE_PRIOR_PRIOR) {
                throw new RuntimeException();
            }
            return new TwoStageMethodProvider(firsts, seconds);
        }
        return super.getProposalCombination();
    }

    public int getNIterations(PhyloParticle initialParticle) {
        if (!(initialParticle instanceof FiniteGenerationParticle)) {
            return this.nGenerations;
        }
        if (this.useTwoStageMethod) {
            boolean isNGenMAX;
            boolean bl = isNGenMAX = Integer.MAX_VALUE == this.nGenerations;
            if (isNGenMAX) {
                return this.nGenerations;
            }
            return this._finiteNIterations(initialParticle) + this.nGenerations;
        }
        return this._finiteNIterations(initialParticle);
    }

    private int _finiteNIterations(PhyloParticle initialParticle) {
        return ((FiniteGenerationParticle)((Object)initialParticle)).nGenerationsLeft();
    }

    public static ProposalOptions createSimpleMCMCProposalOptions() {
        ProposalOptions result = new ProposalOptions();
        result.proposalModels = CollUtils.list(Arrays.asList(ProposalModel.BRANCH_SCALE, ProposalModel.NNI));
        result.weights = CollUtils.list(Arrays.asList(0.5, 0.5));
        return result;
    }

    public static enum MSAInitMethod {
        DATA,
        PAIR,
        APPROX_PAIR,
        EMPTY;

    }

    public static enum TreeInitMethod {
        DATA,
        RANDOM,
        SMC;

    }
}

