/*
 * Decompiled with CFR 0.152.
 */
package ev.ex;

import fig.basic.NumUtils;
import fig.basic.Pair;
import fig.prob.SampleUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import nuts.math.Sampling;
import nuts.maxent.SloppyMath;
import nuts.util.CollUtils;
import pty.smc.ParticleFilter;
import pty.smc.ParticleKernel;

public class SimpleParticleFilter<S> {
    private List<S> currentParticles;
    private ParticleKernel<S> kernel;
    private double approxLogNorm;
    public int nParticles = 100;
    private double[] finalWeights;

    public void compute(Random rand, ParticleKernel<S> kernel) {
        this.kernel = kernel;
        this.init();
        while (this.hasMoreIterations()) {
            double[] logWeights = this.propagate(rand);
            this.updateLogNorm(logWeights);
            NumUtils.expNormalize(logWeights);
            if (this.hasMoreIterations()) {
                this.currentParticles = this.resample(rand, logWeights);
                continue;
            }
            this.finalWeights = logWeights;
        }
    }

    public void integrate(ParticleFilter.ParticleProcessor<S> processor) {
        for (int i = 0; i < this.nParticles; ++i) {
            processor.process(this.currentParticles.get(i), this.finalWeights[i]);
        }
    }

    public S sample(Random rand) {
        return Sampling.randomElt(this.currentParticles, rand);
    }

    public double estimateNormalizer() {
        return this.approxLogNorm;
    }

    private List<S> resample(Random rand, double[] logWeights) {
        ArrayList newParticles = CollUtils.list();
        for (int i = 0; i < this.nParticles; ++i) {
            int randomIndex = SampleUtils.sampleMultinomial(rand, logWeights);
            newParticles.add(this.currentParticles.get(randomIndex));
        }
        return newParticles;
    }

    private void updateLogNorm(double[] logWeights) {
        this.approxLogNorm += SloppyMath.logAdd(logWeights) - Math.log(this.nParticles);
    }

    private double[] propagate(Random rand) {
        double[] logWeights = new double[this.nParticles];
        for (int i = 0; i < this.nParticles; ++i) {
            Pair<S, Double> currentPair = this.kernel.next(rand, this.currentParticles.get(i));
            this.currentParticles.set(i, currentPair.getFirst());
            logWeights[i] = currentPair.getSecond();
        }
        return logWeights;
    }

    private boolean hasMoreIterations() {
        return this.kernel.nIterationsLeft(this.currentParticles.get(0)) != 0;
    }

    private void init() {
        this.approxLogNorm = 0.0;
        this.currentParticles = CollUtils.list();
        for (int i = 0; i < this.nParticles; ++i) {
            this.currentParticles.add(this.kernel.getInitial());
        }
    }
}

