/*
 * Decompiled with CFR 0.152.
 */
package ev.hmm;

import ev.hmm.HetPairHMM;
import ev.hmm.HetPairHMMSpecification;
import pepper.Encodings;

public final class HomogenousHMM {
    private final Encodings enc;
    private final double[][][][] sub;
    private final double[][][] del;
    private final double[][][] ins;
    private final int startState;
    private final int endState;

    private int c2i(char c) {
        return this.enc.char2PhoneId(c);
    }

    public HomogenousHMM(Encodings enc, int nStates, int startState, int endState) {
        this.enc = enc;
        this.startState = startState;
        this.endState = endState;
        this.sub = new double[nStates][nStates][enc.N()][enc.N()];
        this.del = new double[nStates][nStates][enc.N()];
        this.ins = new double[nStates][nStates][enc.N()];
    }

    public int nStates() {
        return this.sub.length;
    }

    public void setSub(int s1, int s2, char top, char bot, double value) {
        this.sub[s1][s2][this.c2i((char)top)][this.c2i((char)bot)] = value;
    }

    public void setIns(int s1, int s2, char bot, double value) {
        this.ins[s1][s2][this.c2i((char)bot)] = value;
    }

    public void setDel(int s1, int s2, char top, double value) {
        this.del[s1][s2][this.c2i((char)top)] = value;
    }

    public HetPairHMM createPairHMM(String top, String bot) {
        final double[][][][] logsub = new double[this.nStates()][this.nStates()][top.length()][bot.length()];
        final double[][][] logdel = new double[this.nStates()][this.nStates()][top.length()];
        final double[][][] logins = new double[this.nStates()][this.nStates()][bot.length()];
        for (int s1 = 0; s1 < this.nStates(); ++s1) {
            for (int s2 = 0; s2 < this.nStates(); ++s2) {
                int t;
                for (t = 0; t < top.length(); ++t) {
                    for (int b = 0; b < bot.length(); ++b) {
                        logsub[s1][s2][t][b] = Math.log(this.sub[s1][s2][this.c2i(top.charAt(t))][this.c2i(bot.charAt(b))]);
                    }
                }
                for (t = 0; t < top.length(); ++t) {
                    logdel[s1][s2][t] = Math.log(this.del[s1][s2][this.c2i(top.charAt(t))]);
                }
                for (int b = 0; b < bot.length(); ++b) {
                    logins[s1][s2][b] = Math.log(this.ins[s1][s2][this.c2i(bot.charAt(b))]);
                }
            }
        }
        HetPairHMMSpecification specs = new HetPairHMMSpecification(){

            @Override
            public int nStates() {
                return logsub.length;
            }

            @Override
            public double logWeight(int prevState, int currentState, int x, int y, int deltaX, int deltaY) {
                if (deltaX == 1 && deltaY == 1) {
                    return logsub[prevState][currentState][x][y];
                }
                if (deltaX == 1) {
                    return logdel[prevState][currentState][x];
                }
                if (deltaY == 1) {
                    return logins[prevState][currentState][y];
                }
                throw new RuntimeException();
            }

            @Override
            public int endState() {
                return HomogenousHMM.this.endState;
            }

            @Override
            public int startState() {
                return HomogenousHMM.this.startState;
            }
        };
        return new HetPairHMM(top, bot, specs);
    }
}

