/*
 * Decompiled with CFR 0.152.
 */
package ev.to;

import ev.to.PhyloTools;
import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.UnorderedPair;
import goblin.Taxon;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import nuts.io.IO;
import nuts.util.CollUtils;
import nuts.util.Counter;
import pty.RootedTree;
import pty.SumT;
import pty.UnrootedTree;

public class NJ
extends PhyloTools {
    @Option
    public static String dnadistPath = "dnadist";
    @Option
    public static String neighborPath = "neighbor";

    @Override
    public File createTree(File phylipFile) {
        LogInfo.logsForce("Creating distance mtx");
        String str = IO.call(dnadistPath, phylipFile.getAbsolutePath() + "\n" + "y" + "\n", this.workingDir);
        File distFile = new File(this.workingDir, "outfile");
        if (IO.f2s(distFile).equals("")) {
            throw new RuntimeException("Error: maybe because encountered invalid symbols?");
        }
        LogInfo.logsForce("Creating the tree");
        File workingDir2 = new File(this.workingDir, "neighbor-working-dir");
        workingDir2.mkdir();
        IO.call(neighborPath, distFile.getAbsolutePath() + "\n" + "y" + "\n", workingDir2);
        return new File(workingDir2, "outtree");
    }

    public static void main(String[] args) {
        IO.run(args, new NJ(), "generic", PhyloTools.PhyloToolsOptions.class);
    }

    public static UnrootedTree inferTree(Counter<UnorderedPair<Taxon, Taxon>> distances) {
        if (distances.keySet().size() == 1) {
            return NJ.inferTreeFromPair(distances);
        }
        File tempDir = IO.getTempDir();
        HashMap<Taxon, Taxon> conversion = CollUtils.map();
        int i = 0;
        for (UnorderedPair<Taxon, Taxon> unorderedPair : distances.keySet()) {
            i = NJ.add(unorderedPair.getFirst(), conversion, i);
            i = NJ.add(unorderedPair.getSecond(), conversion, i);
        }
        Counter<UnorderedPair<Taxon, Taxon>> distances2 = new Counter<UnorderedPair<Taxon, Taxon>>();
        for (UnorderedPair<Taxon, Taxon> unorderedPair : distances.keySet()) {
            Taxon c1 = (Taxon)conversion.get(unorderedPair.getFirst());
            Taxon c2 = (Taxon)conversion.get(unorderedPair.getSecond());
            distances2.setCount(new UnorderedPair<Taxon, Taxon>(c1, c2), distances.getCount(unorderedPair));
        }
        String string = SumT.phylipDistanceMatrix(distances2);
        File file = new File(tempDir, "infile");
        IO.writeToDisk(file, string);
        IO.call(neighborPath, "y\n", tempDir);
        File fileBeforeConversion = new File(tempDir, "outtree");
        String newickStr = IO.f2s(fileBeforeConversion);
        for (Taxon originalName : conversion.keySet()) {
            newickStr = newickStr.replaceAll(((Taxon)conversion.get(originalName)).toString(), originalName.toString());
        }
        RootedTree tree = RootedTree.Util.fromNewickString(newickStr);
        IO.rmDir(tempDir);
        return UnrootedTree.fromRooted(tree);
    }

    private static UnrootedTree inferTreeFromPair(Counter<UnorderedPair<Taxon, Taxon>> distances) {
        UnorderedPair<Taxon, Taxon> key = CollUtils.pick(distances.keySet());
        double half = distances.getCount(key) / 2.0;
        String newickStr = "(" + key.getFirst() + ":" + half + "," + key.getSecond() + ":" + half + ");";
        return UnrootedTree.fromNewickRemovingBinaryRoot(newickStr);
    }

    private static int add(Taxon taxon, Map<Taxon, Taxon> conversion, int i) {
        if (conversion.keySet().contains(taxon)) {
            return i;
        }
        conversion.put(taxon, new Taxon("X" + i + "X"));
        return i + 1;
    }
}

