/*
 * Decompiled with CFR 0.152.
 */
package fenchel.algo;

import fig.basic.Pair;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import nuts.math.Graph;
import nuts.util.Counter;

public class BlockingPriorities<E> {
    private final Counter<E> nBlocks = new Counter();
    private final Queue<E> zeroBlocks = new LinkedList();

    public static <N> BlockingPriorities<Pair<N, N>> initPriorities(Graph<N> topology) {
        BlockingPriorities<Pair<N, N>> priorities = new BlockingPriorities<Pair<N, N>>();
        for (N node : topology.vertexSet()) {
            Set<N> nbrs = topology.nbrs(node);
            int nBlocks = nbrs.size() - 1;
            for (N other : nbrs) {
                priorities.init(Pair.makePair(node, other), nBlocks);
            }
        }
        return priorities;
    }

    public void init(E e, int nBlocks) {
        if (this.nBlocks.keySet().contains(e)) {
            throw new RuntimeException();
        }
        this.increment(e, nBlocks);
    }

    public void removeBlock(E e) {
        this.increment(e, -1);
    }

    public boolean isBlocked() {
        return this.zeroBlocks.isEmpty();
    }

    public int size() {
        return this.nBlocks.keySet().size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public E popUnblocked() {
        if (this.isBlocked()) {
            return null;
        }
        E result = this.zeroBlocks.poll();
        this.nBlocks.removeKey(result);
        return result;
    }

    private void increment(E e, int delta) {
        this.nBlocks.incrementCount(e, delta);
        double current = this.nBlocks.getCount(e);
        if (current < 0.0) {
            throw new RuntimeException();
        }
        if (current == 0.0) {
            this.zeroBlocks.add(e);
        }
    }
}

