/*
 * Decompiled with CFR 0.152.
 */
package fig.exec.servlet;

import fig.basic.StrUtils;
import fig.exec.servlet.DomainView;
import fig.exec.servlet.FileItem;
import fig.exec.servlet.FileSource;
import fig.exec.servlet.FilenameFilterBank;
import fig.exec.servlet.MyException;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;

public class DirSource
extends FileSource {
    public DirSource(DomainView domainView, File path) {
        super(domainView, path);
    }

    public DirSource(DomainView domainView, String path) {
        super(domainView, path);
    }

    public DirSource(DirSource parent, String name) {
        super(parent, name);
    }

    public List<String> getChildren(int depth, TraverseSpec spec) {
        return this.getChildren("", depth, spec);
    }

    public List<String> getChildren(String dir, int depth, TraverseSpec spec) {
        ArrayList<String> childDirs = new ArrayList<String>();
        this.getChildren(childDirs, dir, depth, spec);
        return childDirs;
    }

    private void getChildren(List<String> childDirs, String dir, int depth, TraverseSpec spec) {
        if (depth == 0) {
            return;
        }
        String[] childNames = new File(this.path, dir).list();
        if (childNames == null) {
            return;
        }
        for (String childName : childNames) {
            String childDir;
            String string = childDir = StrUtils.isEmpty(dir) ? childName : new File(dir, childName).toString();
            if (spec.retFilter == null || spec.retFilter.accept(this.path, childDir)) {
                childDirs.add(childDir);
            }
            if (!new File(this.path, childDir).isDirectory() || spec.descendFilter != null && !spec.descendFilter.accept(this.path, childDir)) continue;
            this.getChildren(childDirs, childDir, depth - 1, spec);
        }
    }

    public File getPath(String file) {
        return new File(this.path, file);
    }

    public FileItem getFileItem(String file) throws MyException {
        return (FileItem)this.domainView.getFileViewDB().getRootFileView().getItem(this.getPath(file).toString());
    }

    public static class TraverseSpec {
        private FilenameFilter retFilter;
        private FilenameFilter descendFilter;

        public TraverseSpec(FilenameFilter retFilter, FilenameFilter descendFilter) {
            this.retFilter = retFilter;
            this.descendFilter = descendFilter;
        }

        public static TraverseSpec allowAll() {
            return new TraverseSpec(null, null);
        }

        public static TraverseSpec allowOnlyFiles() {
            return new TraverseSpec(FilenameFilterBank.onlyFile(), null);
        }
    }
}

