/*
 * Decompiled with CFR 0.152.
 */
package goblin;

import goblin.DataLoader;
import goblin.DataPrepUtils;
import goblin.DerivationTree;
import goblin.Reroot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import nuts.tui.FancyTreeRenderer;
import nuts.util.Arbre;
import nuts.util.Tree;

public class CreateTopo {
    private static final String help = "goblin.CreateTopo <full-topo> (<heldout-restr-file>\":\"<proto-lang>\":\"<n-restric>|ALL) <p|h|l>\n\tp : Phylip format\n\tl : Lisp format (default)\n\th : Human readable printout";

    public static void main(String[] arguments) {
        String opt;
        Tree<String> fullTopo;
        if (arguments.length < 2 || arguments.length > 3) {
            System.out.println(help);
            return;
        }
        String topoStr = arguments[0];
        Tree<String> result = fullTopo = DataLoader.createRawTopology(topoStr);
        String restStr = arguments[1];
        if (!restStr.equals("ALL")) {
            String[] sFields = restStr.split("[:]");
            String restrFile = sFields[0];
            String protoLang = sFields[1];
            int restrN = Integer.parseInt(sFields[21]);
            Set<String> langs = DataLoader.readLangsToRestrict(protoLang, restrFile, restrN, fullTopo);
            HashMap<String, String> hack = new HashMap<String, String>();
            for (String s : langs) {
                hack.put(s, s);
            }
            Arbre<DerivationTree.DerivationNode> current = DataPrepUtils.tree2arbre(fullTopo, hack);
            current = DataPrepUtils.trim(current);
            result = CreateTopo.convert(current);
        }
        result = Reroot.removeChains(result);
        String string = opt = arguments.length == 2 ? "l" : arguments[2];
        if (opt.equals("l")) {
            System.out.println(result);
        } else if (opt.equals("p")) {
            System.out.println(CreateTopo.toPhylip(result) + ";");
        } else if (opt.equals("h")) {
            System.out.println("Tree:\n" + FancyTreeRenderer.println(result));
        } else {
            System.err.println(help);
        }
        System.out.println();
    }

    private static String toPhylip(Tree<String> t) {
        if (t.getChildren().size() == 0) {
            return t.getLabel();
        }
        String rslt = "(";
        for (int i = 0; i < t.getChildren().size(); ++i) {
            rslt = rslt + CreateTopo.toPhylip(t.getChildren().get(i));
            if (i >= t.getChildren().size() - 1) continue;
            rslt = rslt + ",";
        }
        rslt = rslt + ")";
        return rslt;
    }

    private static Tree<String> convert(Arbre<DerivationTree.DerivationNode> current) {
        String label = current.getContents().getLanguage().toString();
        ArrayList children = new ArrayList();
        if (children.size() > 2) {
            System.err.println("Non binary!");
        }
        for (Arbre<DerivationTree.DerivationNode> child : current.getChildren()) {
            children.add(CreateTopo.convert(child));
        }
        return new Tree<String>(label, children);
    }
}

