/*
 * Decompiled with CFR 0.152.
 */
package ma;

import fig.basic.UnorderedPair;
import goblin.Taxon;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import nuts.io.IO;

public class DistanceMtxParser {
    public static Map<UnorderedPair<Taxon, Taxon>, Double> read(File f, String langPrefix) {
        ArrayList<Taxon> langs = new ArrayList<Taxon>();
        double[][] distances = null;
        int ln = 0;
        int langIndex = -1;
        int nextIdx = -1;
        for (String line : IO.i(f)) {
            int i;
            if (ln++ == 0) {
                int size = Integer.parseInt(line);
                distances = new double[size][size];
                continue;
            }
            if (line.matches("^\\s+.*")) {
                line = line.replaceFirst("^\\s+", "");
                String[] fields = line.split("\\s+");
                for (i = 0; i < fields.length; ++i) {
                    distances[langIndex][i + nextIdx] = Double.parseDouble(fields[i]);
                }
                nextIdx += fields.length;
                continue;
            }
            ++langIndex;
            String[] fields = line.split("\\s+");
            langs.add(new Taxon(langPrefix + fields[0]));
            for (i = 1; i < fields.length; ++i) {
                distances[langIndex][i - 1] = Double.parseDouble(fields[i]);
            }
            nextIdx = fields.length - 1;
        }
        HashMap<UnorderedPair<Taxon, Taxon>, Double> result = new HashMap<UnorderedPair<Taxon, Taxon>, Double>();
        for (int i = 0; i < langs.size(); ++i) {
            for (int j = 0; j < langs.size(); ++j) {
                double dist = distances[i][j];
                if (dist != distances[j][i]) {
                    throw new RuntimeException();
                }
                result.put(new UnorderedPair(langs.get(i), langs.get(j)), dist);
            }
        }
        return result;
    }

    public static void main(String[] args) {
        Map<UnorderedPair<Taxon, Taxon>, Double> dists = DistanceMtxParser.read(new File(args[0]), "");
        HashSet<Taxon> langs = new HashSet<Taxon>();
        for (UnorderedPair<Taxon, Taxon> key : dists.keySet()) {
            langs.add(key.getFirst());
            langs.add(key.getSecond());
        }
        ArrayList langLists = new ArrayList(langs);
        Collections.sort(langLists);
        for (int i = 0; i < langLists.size(); ++i) {
            Object key1 = langLists.get(i);
            System.out.print(key1 + " ");
            for (int j = 0; j < langLists.size(); ++j) {
                Object key2 = langLists.get(j);
                System.out.print(dists.get(new UnorderedPair(key1, key2)) + " ");
            }
            IO.so();
        }
    }
}

