/*
 * Decompiled with CFR 0.152.
 */
package ma;

import Jama.Matrix;
import fig.basic.LogInfo;
import fig.basic.NumUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import ma.AffineGapAlignmentSampler;
import nuts.math.RateMtxUtils;
import nuts.util.CollUtils;
import nuts.util.Indexer;
import nuts.util.MathUtils;
import pepper.Encodings;

public class RateMatrixLoader {
    public static final double[] eval = new double[]{-0.237688, -0.572589, -2.87135, -1.80086, 0.0, -1.50997, -2.00378, -0.785944, -1.13116, -1.72489, -0.290841, -0.84021, -1.22413, -0.683149, -0.638375, -1.38183, -1.0694, -0.407039, -0.371537, -0.949449};
    public static final double[][] evec = new double[][]{{0.152773, 0.108573, 0.102903, 0.133593, -0.0521415, 0.0956828, 0.138341, 0.177849, 0.0537749, -0.0502762, -0.239453, 0.147873, -0.0399386, -0.580187, 0.180554, 0.127032, 0.10278, -0.0744991, -0.62137, -0.0025391}, {-0.256755, 0.436768, 0.125584, 0.118759, 0.0513453, 0.213852, 0.111448, -0.285538, 0.230064, -0.0301433, 0.0318147, 0.446052, 0.0521453, -0.0761061, -0.515726, -0.0865151, -0.0915485, -0.129092, 0.0483333, -0.0891585}, {-0.0375089, 0.0157756, 0.387055, -0.708228, 0.00360566, -0.089634, 0.573679, 0.00639143, -0.041365, -0.0135321, 3.88336E-4, -0.0434103, 0.00427688, 0.00223345, 0.00209585, -0.0761202, 0.00934563, -6.59095E-4, -0.00784392, 0.00107364}, {0.00856931, -0.0444615, 0.248271, -0.0996798, -0.0277668, 0.244006, -0.165036, -0.0906408, -0.170996, 0.219306, -0.0282009, -0.0719786, 0.0314602, -0.0179961, -0.0385066, 0.662981, -0.547551, -0.00683302, 0.00210723, -0.0714027}, {0.31025, 0.193263, 0.205601, 0.201325, 0.163302, 0.183367, 0.215991, 0.267732, 0.175526, 0.1737, 0.338652, 0.255342, 0.134055, 0.218463, 0.262993, 0.263987, 0.245453, 0.0672774, 0.207424, 0.227492}, {0.724318, -0.019642, 0.00497611, -0.0227006, -0.00334404, -0.259797, -0.0161941, -0.22691, 0.165461, -0.301918, 0.0194674, 0.130948, -0.0166728, 0.0187262, -0.104149, -0.119892, -0.406036, 9.64432E-4, -0.014422, 0.167925}, {-0.175456, -0.043419, -0.651771, -0.0472714, -0.015177, -0.291039, 0.412651, -1.46395E-4, 0.245448, -0.0155583, 0.00999212, 0.117788, -0.00933149, -0.00676297, -0.00121627, 0.443471, -0.107621, -0.00257243, 0.00568227, 0.0468215}, {0.117015, 0.350693, -0.169256, -0.381848, -0.0468014, -0.247171, -0.383005, 0.0969884, -0.301696, 0.225844, -0.203347, 0.261105, 0.103521, -0.0759263, -0.147824, 0.117676, 0.23901, -0.0382571, 0.0725524, 0.319214}, {-0.171856, -0.567062, 0.0679906, -0.202255, 0.00971191, 0.0734455, -0.234357, 0.172949, 0.33803, 0.0630586, -0.113004, 0.515657, 0.26578, -0.00636973, 0.0897973, -0.127422, -0.113056, 0.0448448, -0.0108214, 0.0790687}, {0.318545, -0.0134678, -0.126687, -0.0238445, 0.00292025, -0.0967741, 0.0678765, -0.0416801, 0.107078, 0.688129, -0.030415, 0.0401257, 0.0204408, -0.0347425, -0.032172, -0.171906, 0.00774146, 0.00300406, 0.00271163, -0.588388}, {0.00184398, 0.0320688, 0.0181647, 0.024284, -0.957418, 0.0381674, 0.029567, 0.00226549, 0.0193655, 0.043477, 0.238593, 0.0512065, 0.0701549, 0.0713339, 0.00353296, -0.0281654, 0.0112923, 0.0436926, -0.0532446, 0.0395073}, {0.0194596, -0.251938, 0.0883342, 0.144281, -0.0287224, 0.0592824, 0.148453, -0.611316, 0.0954274, 0.352054, -0.263602, -0.13204, 0.00184463, -0.0107077, -0.0268702, 0.039774, 0.249713, 0.0368616, -0.0288669, 0.469579}, {0.0774295, 0.0792606, -0.0638524, 0.0362701, 0.00194187, 0.0537588, 0.0736056, -0.0574548, -0.0200858, -0.175759, -0.177088, -0.241323, 0.907889, 0.0087887, -0.0288666, 0.0375967, 0.0646001, -0.00307011, 0.0058187, -0.137923}, {-0.0170349, 0.0897096, -0.00625436, -9.16056E-4, 0.0465075, -9.31081E-4, -0.00524553, 0.0292486, -0.0197301, 0.0249912, -0.18476, 0.0758092, -0.0244825, 0.754831, -0.0451495, 0.0138112, -0.00585027, -0.0395475, -0.610739, -0.0219085}, {-0.125773, 0.326812, -0.0963977, -0.192652, 0.0149767, 0.0632277, -0.172063, -0.451653, 0.111099, -0.0559634, 0.0434454, 0.111374, 0.0113963, 0.0185792, 0.729123, -0.0815551, -0.0926548, -0.0730935, 0.00457254, -0.103384}, {-0.246926, 0.13532, 0.439154, 0.219234, -0.00882055, -0.728919, -0.133362, 0.0517164, 0.280947, 0.102177, 0.00160188, -0.117874, 0.0851822, -0.0160518, 0.0598926, 0.0969465, -0.0603758, -0.0131564, -0.0178706, -0.00555479}, {0.146243, -0.146307, 0.0884023, -0.225878, -0.022172, 0.00499251, -0.264699, -0.216071, 0.294503, -0.2894, 0.119003, -0.0348962, -0.12354, 0.0228871, -0.1584, 0.394014, 0.529768, -0.00516348, -0.036199, -0.342235}, {-0.0534549, 0.125311, -0.0174761, -0.0314216, 0.0567915, 0.0024949, -0.0324329, -0.065885, 0.0073961, -0.0134403, 0.0316061, 0.0296611, 0.0056839, -0.0592443, -0.043891, -0.0158695, -0.0306948, 0.973807, -0.117524, -0.0252}, {0.0688182, 0.0966927, 0.100992, 0.115989, -0.201896, 0.0559269, 0.112196, 0.13259, 0.0843836, -0.160677, -0.745329, 0.0970068, -0.194853, 0.148373, 0.120214, 0.0795125, 0.0261912, 0.102737, 0.412444, -0.16803}, {0.0210312, 0.245898, -0.114241, -0.229342, -0.0153738, 0.263673, -0.17095, 0.247419, 0.61854, 0.132449, -0.0785555, -0.467279, -0.0642943, -0.0206306, -0.0932377, -0.0939369, -0.115283, -0.0219703, -0.0238274, 0.228408}};
    public static double DEFAULT_TRANS2TRANV = 2.0;
    private static final double coeff = 0.015;
    private static Map<Character, double[]> IUPAC_codes = null;

    public static double[][] dayhoff() {
        return RateMatrixLoader.sriramData();
    }

    public static Indexer<Character> proteinIndexer() {
        return Encodings.proteinEncodings().nonGapCharactersIndexer();
    }

    public static Indexer<Character> rnaIndexer() {
        return Encodings.rnaEncodings().nonGapCharactersIndexer();
    }

    public static double[][] k2p() {
        return RateMatrixLoader.k2p(DEFAULT_TRANS2TRANV);
    }

    public static double alpha(double transitionToTransversionRatio) {
        double R = transitionToTransversionRatio;
        return R / (R + 1.0);
    }

    public static double beta(double transitionToTransversionRatio) {
        double R = transitionToTransversionRatio;
        return 1.0 / (R + 1.0);
    }

    public static double[][] k2p(double transitionToTransversionRatio) {
        if (transitionToTransversionRatio <= 0.0) {
            throw new RuntimeException();
        }
        double alpha = RateMatrixLoader.alpha(transitionToTransversionRatio);
        double beta = RateMatrixLoader.beta(transitionToTransversionRatio);
        double[][] result = new double[4][4];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (i == j) continue;
                result[i][j] = RateMatrixLoader.isTransition(i, j) ? alpha : beta;
            }
        }
        RateMtxUtils.fillRateMatrixDiagonalEntries(result);
        return result;
    }

    public static double[][] hky85() {
        return RateMatrixLoader.hky85(0.25, 1.0);
    }

    public static double[][] hky85(double transvertionRate, double mutationRate) {
        double[][] result = new double[4][4];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (i == j) continue;
                result[i][j] = 0.25 * mutationRate * (RateMatrixLoader.isTransition(i, j) ? 1.0 : transvertionRate);
            }
        }
        RateMtxUtils.fillRateMatrixDiagonalEntries(result);
        return result;
    }

    public static boolean isPurine(int code) {
        return code == 0 || code == 2;
    }

    public static boolean isPyrimidine(int code) {
        return code == 1 || code == 3;
    }

    public static int getCode(char nucleotide) {
        switch (nucleotide) {
            case 'A': {
                return 0;
            }
            case 'C': {
                return 1;
            }
            case 'G': {
                return 2;
            }
            case 'T': {
                return 3;
            }
            case 'U': {
                return 3;
            }
        }
        throw new RuntimeException();
    }

    public static boolean isTransition(int i, int j) {
        return RateMatrixLoader.isPurine(i) && RateMatrixLoader.isPurine(j) || RateMatrixLoader.isPyrimidine(i) && RateMatrixLoader.isPyrimidine(j);
    }

    public static void main(String[] args) {
        double[][] k2pm = RateMatrixLoader.k2p();
        double time = 2.0;
        double[][] trans = RateMtxUtils.marginalTransitionMtx(k2pm, time);
        System.out.println("Method 1 for C-G:" + trans[1][2]);
        System.out.println("Method 2 for C-G:" + (0.5 - 0.5 * Math.exp(-2.0 * time / 3.0)) / 2.0);
        AffineGapAlignmentSampler.CompiledTKFParams ctkfp = new AffineGapAlignmentSampler.TKFParams(Encodings.EncodingType.PROTEIN).compile(1.0);
        System.out.println();
    }

    public static void checkPrMtx(double[][] numbers) {
        for (int i = 0; i < numbers.length; ++i) {
            if (MathUtils.isProb(numbers[i])) continue;
            System.err.println(MathUtils.sum(numbers[i]));
        }
    }

    public static double[][] normalize(double[][] numbers) {
        for (int i = 0; i < numbers.length; ++i) {
            NumUtils.normalize(numbers[i]);
        }
        return numbers;
    }

    private static double[][] sriramData() {
        int size = 20;
        double[][] rate = new double[20][20];
        rate[0][1] = 0.96472567159749;
        rate[0][2] = 3.592799188641;
        rate[0][3] = 4.3200552414656;
        rate[0][4] = 1.3184584178499;
        rate[0][5] = 3.2267534963169;
        rate[0][6] = 7.0141987829615;
        rate[0][7] = 8.5773867857875;
        rate[0][8] = 0.81434196396611;
        rate[0][9] = 2.3518447453539;
        rate[0][10] = 1.4735711728911;
        rate[0][11] = 0.93940162271805;
        rate[0][12] = 2.5490196078431;
        rate[0][13] = 0.65922920892495;
        rate[0][14] = 8.918983414867;
        rate[0][15] = 14.540712836859;
        rate[0][16] = 13.41190459537;
        rate[0][17] = 0.038517964118027;
        rate[0][18] = 0.8789722785666;
        rate[0][19] = 7.4036511156187;
        rate[1][2] = 1.1890243902439;
        rate[1][3] = 0.059525626545377;
        rate[1][4] = 0.84778922655537;
        rate[1][5] = 8.8348561504191;
        rate[1][6] = 0.055954088952654;
        rate[1][7] = 0.31434881434075;
        rate[1][8] = 8.4753987678285;
        rate[1][9] = 2.2684090115941;
        rate[1][10] = 0.55954088952654;
        rate[1][11] = 16.68131276901;
        rate[1][12] = 3.1707317073171;
        rate[1][13] = 0.48959827833572;
        rate[1][14] = 3.67541564689;
        rate[1][15] = 5.4755072760812;
        rate[1][16] = 0.96472567159749;
        rate[1][17] = 7.5538020086083;
        rate[1][18] = 0.27977044476327;
        rate[1][19] = 0.86083213773314;
        rate[2][3] = 32.459324155194;
        rate[2][4] = 0.073852625416383;
        rate[2][5] = 3.7732198142415;
        rate[2][6] = 5.3911764705882;
        rate[2][7] = 5.0264375413087;
        rate[2][8] = 19.061418685121;
        rate[2][9] = 2.7901430842607;
        rate[2][10] = 1.2482698961938;
        rate[2][11] = 11.542279411765;
        rate[2][12] = 0.19117647058824;
        rate[2][13] = 0.50183823529412;
        rate[2][14] = 1.5181660899654;
        rate[2][15] = 17.697478991597;
        rate[2][16] = 8.3557302231237;
        rate[2][17] = 0.86029411764706;
        rate[2][18] = 3.4411764705882;
        rate[2][19] = 0.57352941176471;
        rate[3][4] = 0.025534152404601;
        rate[3][5] = 4.8811013767209;
        rate[3][6] = 40.561952440551;
        rate[3][7] = 4.442350691173;
        rate[3][8] = 3.08657881175;
        rate[3][9] = 0.85749078239692;
        rate[3][10] = 0.025926985518518;
        rate[3][11] = 2.593085106383;
        rate[3][12] = 0.11667143483333;
        rate[3][13] = 0.012963492759259;
        rate[3][14] = 0.47853935065891;
        rate[3][15] = 3.4167709637046;
        rate[3][16] = 2.3984722282163;
        rate[3][17] = 0.032408731898147;
        rate[3][18] = 0.081351689612015;
        rate[3][19] = 0.63829787234043;
        rate[4][5] = 0.021864264103535;
        rate[4][6] = 0.014770525083277;
        rate[4][7] = 0.39055458751427;
        rate[4][8] = 1.0223340673168;
        rate[4][9] = 1.5970515970516;
        rate[4][10] = 0.03909844874985;
        rate[4][11] = 0.0080776309049169;
        rate[4][12] = 0.1415508653814;
        rate[4][13] = 0.086898395721925;
        rate[4][14] = 0.68155604487784;
        rate[4][15] = 5.8097784568373;
        rate[4][16] = 0.59929928084086;
        rate[4][17] = 0.3475935828877;
        rate[4][18] = 3.475935828877;
        rate[4][19] = 1.7647058823529;
        rate[5][6] = 25.476780185759;
        rate[5][7] = 1.0174974779977;
        rate[5][8] = 21.573939173192;
        rate[5][9] = 0.65266504894988;
        rate[5][10] = 2.663449280641;
        rate[5][11] = 5.546633126935;
        rate[5][12] = 4.0247678018576;
        rate[5][13] = 0.018038017885416;
        rate[5][14] = 5.5044618466582;
        rate[5][15] = 2.0267580716497;
        rate[5][16] = 1.9256432155439;
        rate[5][17] = 0.096202762055552;
        rate[5][18] = 0.10061919504644;
        rate[5][19] = 1.2538699690402;
        rate[6][7] = 2.8869795109055;
        rate[6][8] = 1.5519031141869;
        rate[6][9] = 2.1701112877583;
        rate[6][10] = 0.40484429065744;
        rate[6][11] = 2.9823529411765;
        rate[6][12] = 1.0705882352941;
        rate[6][13] = 0.019801735189768;
        rate[6][14] = 1.7993079584775;
        rate[6][15] = 2.818487394958;
        rate[6][16] = 1.2261663286004;
        rate[6][17] = 0.073114099162219;
        rate[6][18] = 0.76470588235294;
        rate[6][19] = 1.3058823529412;
        rate[7][8] = 0.3790676878815;
        rate[7][9] = 0.02312800484684;
        rate[7][10] = 0.25776602775942;
        rate[7][11] = 0.96662260409782;
        rate[7][12] = 0.60145406477198;
        rate[7][13] = 0.54775280898876;
        rate[7][14] = 1.2382877804129;
        rate[7][15] = 8.2853366065527;
        rate[7][16] = 1.1110604644803;
        rate[7][17] = 0.12888301387971;
        rate[7][18] = 0.017114723586662;
        rate[7][19] = 1.9233311302049;
        rate[8][9] = 0.27354343963341;
        rate[8][10] = 1.5876246692449;
        rate[8][11] = 0.96993944636678;
        rate[8][12] = 0.12544085640577;
        rate[8][13] = 1.6868512110727;
        rate[8][14] = 3.3075513942601;
        rate[8][15] = 1.2530894710826;
        rate[8][16] = 0.81434196396611;
        rate[8][17] = 1.0121107266436;
        rate[8][18] = 4.4982698961938;
        rate[8][19] = 1.5570934256055;
        rate[9][10] = 9.2275320303002;
        rate[9][11] = 1.6663354531002;
        rate[9][12] = 11.780604133545;
        rate[9][13] = 6.9753577106518;
        rate[9][14] = 0.42551201720752;
        rate[9][15] = 0.88575970928912;
        rate[9][16] = 6.895181185242;
        rate[9][17] = 0.098802836705702;
        rate[9][18] = 1.3434022257552;
        rate[9][19] = 31.526232114467;
        rate[10][11] = 0.65787197231834;
        rate[10][12] = 18.622837370242;
        rate[10][13] = 5.6340830449827;
        rate[10][14] = 1.1377976796255;
        rate[10][15] = 0.61690558576372;
        rate[10][16] = 1.2098794893211;
        rate[10][17] = 1.7543252595156;
        rate[10][18] = 1.0346020761246;
        rate[10][19] = 6.2906574394464;
        rate[11][12] = 8.6029411764706;
        rate[11][13] = 0.0066640454965565;
        rate[11][14] = 1.2089100346021;
        rate[11][15] = 3.4411764705882;
        rate[11][16] = 4.9442190669371;
        rate[11][17] = 0.03427223398229;
        rate[11][18] = 0.47794117647059;
        rate[11][19] = 0.375;
        rate[12][13] = 3.25;
        rate[12][14] = 0.5997693194925;
        rate[12][15] = 2.1848739495798;
        rate[12][16] = 3.6916835699797;
        rate[12][17] = 0.16247577591604;
        rate[12][18] = 0.11508700794053;
        rate[12][19] = 9.0588235294118;
        rate[13][14] = 0.39359861591695;
        rate[13][15] = 1.6386554621849;
        rate[13][16] = 0.49442190669371;
        rate[13][17] = 2.8676470588235;
        rate[13][18] = 24.852941176471;
        rate[13][19] = 0.44117647058824;
        rate[14][15] = 8.6431043005437;
        rate[14][16] = 2.8308077795013;
        rate[14][17] = 0.035840244687362;
        rate[14][18] = 0.043804743506776;
        rate[14][19] = 1.7301038062284;
        rate[15][16] = 19.663865546218;
        rate[15][17] = 2.7857142857143;
        rate[15][18] = 1.2016806722689;
        rate[15][19] = 1.0840336134454;
        rate[16][17] = 0.042019597219666;
        rate[16][18] = 1.5162271805274;
        rate[16][19] = 5.6592292089249;
        rate[17][18] = 2.2941176470588;
        rate[17][19] = 0.12654363316538;
        rate[18][19] = 1.0;
        for (int i = 0; i < 20; ++i) {
            for (int j = i + 1; j < 20; ++j) {
                rate[j][i] = rate[i][j];
            }
        }
        RateMtxUtils.fillRateMatrixDiagonalEntries(rate);
        return new Matrix(rate).times(0.015).getArray();
    }

    public static double[][] buildRNATip(CharSequence s) {
        double[][] result = new double[s.length()][];
        for (int i = 0; i < s.length(); ++i) {
            result[i] = RateMatrixLoader.buildRNATip(s.charAt(i));
        }
        return result;
    }

    public static double[] buildRNATip(char _c) {
        char c = Character.toUpperCase(_c);
        double[] result = RateMatrixLoader.getIUPAC_codes().get(Character.valueOf(c));
        if (result == null) {
            String msg = "Unknown character (case unsensitively):" + _c;
            LogInfo.warning(msg);
            result = RateMatrixLoader.getIUPAC_codes().get(Character.valueOf('N'));
        }
        return result;
    }

    public static Map<Character, double[]> getIUPAC_codes() {
        if (IUPAC_codes == null) {
            IUPAC_codes = RateMatrixLoader._build_IUPAC_codes();
        }
        return IUPAC_codes;
    }

    private static Map<Character, double[]> _build_IUPAC_codes() {
        int A = 0;
        int C = 1;
        int G = 2;
        int T = 3;
        HashMap map = new HashMap();
        CollUtils.getNoNullSet(map, Character.valueOf('A')).addAll(Arrays.asList(A));
        CollUtils.getNoNullSet(map, Character.valueOf('C')).addAll(Arrays.asList(C));
        CollUtils.getNoNullSet(map, Character.valueOf('G')).addAll(Arrays.asList(G));
        CollUtils.getNoNullSet(map, Character.valueOf('T')).addAll(Arrays.asList(T));
        CollUtils.getNoNullSet(map, Character.valueOf('U')).addAll(Arrays.asList(T));
        CollUtils.getNoNullSet(map, Character.valueOf('W')).addAll(Arrays.asList(A, T));
        CollUtils.getNoNullSet(map, Character.valueOf('S')).addAll(Arrays.asList(C, G));
        CollUtils.getNoNullSet(map, Character.valueOf('M')).addAll(Arrays.asList(A, C));
        CollUtils.getNoNullSet(map, Character.valueOf('K')).addAll(Arrays.asList(G, T));
        CollUtils.getNoNullSet(map, Character.valueOf('R')).addAll(Arrays.asList(A, G));
        CollUtils.getNoNullSet(map, Character.valueOf('Y')).addAll(Arrays.asList(C, T));
        CollUtils.getNoNullSet(map, Character.valueOf('B')).addAll(Arrays.asList(C, G, T));
        CollUtils.getNoNullSet(map, Character.valueOf('D')).addAll(Arrays.asList(A, G, T));
        CollUtils.getNoNullSet(map, Character.valueOf('H')).addAll(Arrays.asList(A, C, T));
        CollUtils.getNoNullSet(map, Character.valueOf('V')).addAll(Arrays.asList(A, C, G));
        CollUtils.getNoNullSet(map, Character.valueOf('-')).addAll(Arrays.asList(A, C, G, T));
        CollUtils.getNoNullSet(map, Character.valueOf('N')).addAll(Arrays.asList(A, C, G, T));
        HashMap<Character, double[]> result = CollUtils.map();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            char c = ((Character)iterator.next()).charValue();
            double[] curArray = new double[4];
            Iterator iterator2 = ((Set)map.get(Character.valueOf(c))).iterator();
            while (iterator2.hasNext()) {
                int i = (Integer)iterator2.next();
                curArray[i] = 1.0;
            }
            result.put(Character.valueOf(c), curArray);
        }
        return result;
    }
}

