/*
 * Decompiled with CFR 0.152.
 */
package nuts.math;

import fig.basic.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import nuts.util.CollUtils;
import nuts.util.CounterMap;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;

public class DynamicBinHistogram {
    private CounterMap<Double, Double> values = new CounterMap();

    public void add(double x, double y) {
        this.values.incrementCount(x, y, 1.0);
    }

    public List<Pair<Double, Double>> binBounds(List<CounterMap<Double, Double>> binnedPoint) {
        ArrayList<Pair<Double, Double>> result = CollUtils.list();
        double previousRight = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < binnedPoint.size(); ++i) {
            double right;
            CounterMap<Double, Double> current = binnedPoint.get(i);
            ArrayList<Double> xs = CollUtils.list(current.keySet());
            Collections.sort(xs);
            double left = previousRight;
            previousRight = right = i == binnedPoint.size() - 1 ? Double.POSITIVE_INFINITY : (Double)xs.get(xs.size() - 1);
            result.add(Pair.makePair(left, right));
        }
        return result;
    }

    public List<Pair<Pair<Double, Double>, SummaryStatistics>> binnedSummaryStatistics(int nBins) {
        List<CounterMap<Double, Double>> binPoints = this.binPoints(nBins);
        List<Pair<Double, Double>> binBounds = this.binBounds(binPoints);
        ArrayList<Pair<Pair<Double, Double>, SummaryStatistics>> result = CollUtils.list();
        for (int i = 0; i < binPoints.size(); ++i) {
            SummaryStatistics current = new SummaryStatistics();
            CounterMap<Double, Double> points = binPoints.get(i);
            for (double uniqueX : points.keySet()) {
                for (double y : points.getCounter(uniqueX).keySet()) {
                    int dummy = 0;
                    while ((double)dummy < points.getCount(uniqueX, y)) {
                        current.addValue(y);
                        ++dummy;
                    }
                }
            }
            result.add(Pair.makePair(binBounds.get(i), current));
        }
        return result;
    }

    public String binsToString(int nBins) {
        StringBuilder result = new StringBuilder();
        for (Pair<Pair<Double, Double>, SummaryStatistics> bin : this.binnedSummaryStatistics(nBins)) {
            result.append("(" + bin.getFirst().getFirst() + ", " + bin.getFirst().getSecond() + "]\t" + bin.getSecond().getMean() + "\n");
        }
        return result.toString();
    }

    public static void main(String[] args) {
        DynamicBinHistogram hist = new DynamicBinHistogram();
        hist.add(1.0, 1.0);
        hist.add(1.0, 1.5);
        hist.add(2.0, 2.0);
        hist.add(3.0, 3.0);
        hist.add(4.0, 4.0);
        System.out.println(hist.binPoints(4));
        System.out.println(hist.binBounds(hist.binPoints(4)));
        System.out.println(hist.binsToString(4));
    }

    public List<CounterMap<Double, Double>> binPoints(int requestedNBins) {
        int totalNPoints = (int)this.values.totalCount();
        List<Set<Integer>> indices = CollUtils.partition(totalNPoints, requestedNBins);
        ArrayList<Double> uniqueXs = CollUtils.list(this.values.keySet());
        Collections.sort(uniqueXs);
        ArrayList<CounterMap<Double, Double>> result = CollUtils.list();
        int currentUniqueXIndex = 0;
        int nextStopPoint = 0;
        int currentPointIndex = 0;
        for (int binIndex = 0; binIndex < indices.size(); ++binIndex) {
            CounterMap<Double, Double> currentResultEntry = new CounterMap<Double, Double>();
            int targetN = indices.get(binIndex).size();
            nextStopPoint += targetN;
            while (currentPointIndex < nextStopPoint && currentUniqueXIndex < uniqueXs.size()) {
                double currentX = (Double)uniqueXs.get(currentUniqueXIndex);
                int multiplicity = (int)this.values.getCounter(currentX).totalCount();
                for (double y : this.values.getCounter(currentX)) {
                    currentResultEntry.incrementCount(currentX, y, this.values.getCount(currentX, y));
                }
                currentPointIndex += multiplicity;
                ++currentUniqueXIndex;
            }
            result.add(currentResultEntry);
        }
        return result;
    }
}

