/*
 * Decompiled with CFR 0.152.
 */
package nuts.math;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class EqClasses<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<T, Set<T>> elt2EqClass = new HashMap<T, Set<T>>();
    private final Set<T> representatives = new HashSet<T>();
    private boolean frozen = false;

    public void freeze() {
        this.frozen = true;
    }

    public EqClasses() {
    }

    public EqClasses(Set<Set<T>> model) {
        this();
        for (Set<T> cur : model) {
            if (cur.size() <= 0) continue;
            T rep = cur.iterator().next();
            this.addNewElt(rep);
            for (T elt : cur) {
                if (elt.equals(rep)) continue;
                this.addNewRelation(rep, elt);
            }
        }
    }

    public void addNewElt(T x) {
        if (this.frozen || this.elt2EqClass.containsKey(x)) {
            throw new RuntimeException("Bad call in addNewElt");
        }
        HashSet<T> newEqClass = new HashSet<T>();
        newEqClass.add(x);
        this.elt2EqClass.put(x, newEqClass);
        this.representatives.add(x);
    }

    public void addNewRelation(T existingElt, T newElt) {
        if (this.frozen) {
            throw new RuntimeException("Adding in frozen EqClass");
        }
        Set<T> eqClass = this.elt2EqClass.get(existingElt);
        if (eqClass == null) {
            throw new RuntimeException("The existing elt must exist in addNewRelation");
        }
        if (this.elt2EqClass.containsKey(newElt)) {
            throw new RuntimeException("newElt is already in existingElt's class in addNewRelation");
        }
        eqClass.add(newElt);
        this.elt2EqClass.put(newElt, eqClass);
    }

    public void forceNewRelation(T x, T y) {
        if (this.frozen) {
            throw new RuntimeException("Adding in frozen EqClass");
        }
        if (this.elt2EqClass.containsKey(x) && !this.elt2EqClass.containsKey(y)) {
            this.addNewRelation(x, y);
        } else if (this.elt2EqClass.containsKey(y) && !this.elt2EqClass.containsKey(x)) {
            this.addNewRelation(y, x);
        } else if (!this.elt2EqClass.containsKey(x) && !this.elt2EqClass.containsKey(y)) {
            this.addNewElt(x);
            this.addNewRelation(x, y);
        } else if (this.elt2EqClass.containsKey(x) && this.elt2EqClass.containsKey(y)) {
            if (this.areRelated(x, y)) {
                return;
            }
            Set<T> setX = this.elt2EqClass.get(x);
            Set<T> setY = this.elt2EqClass.get(y);
            setX.addAll(setY);
            for (T elt : setY) {
                this.representatives.remove(elt);
                this.elt2EqClass.put(elt, setX);
            }
        }
    }

    public boolean areRelated(T x, T y) {
        Set<T> eqClassX = this.elt2EqClass.get(x);
        Set<T> eqClassY = this.elt2EqClass.get(y);
        if (eqClassX == null || eqClassY == null) {
            throw new RuntimeException("Unk args in areRelated:" + (eqClassX == null ? "" + x : "") + "," + (eqClassY == null ? "" + y : ""));
        }
        return eqClassX == eqClassY;
    }

    public Set<T> eqClass(T x) {
        Set<T> eqClass = this.elt2EqClass.get(x);
        if (eqClass == null) {
            throw new RuntimeException("Unk elt in eqClass");
        }
        return Collections.unmodifiableSet(eqClass);
    }

    public Collection<T> representatives() {
        return Collections.unmodifiableCollection(this.representatives);
    }

    public boolean contains(T elt) {
        return this.elt2EqClass.keySet().contains(elt);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (T x : this.representatives()) {
            builder.append(this.eqClass(x));
        }
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof EqClasses)) {
            return false;
        }
        EqClasses o_cast = (EqClasses)o;
        return this.elt2EqClass.equals(o_cast.elt2EqClass);
    }

    public int hashCode() {
        return this.elt2EqClass.hashCode();
    }

    public static void main(String[] args) {
        EqClasses<Integer> ec = new EqClasses<Integer>();
        ec.addNewElt(5);
        ec.addNewElt(6);
        ec.addNewRelation(5, 17);
        ec.addNewRelation(17, 21);
        ec.addNewRelation(6, 8);
        ec.addNewElt(11);
        ec.addNewRelation(11, 0);
        System.out.println(ec.toString());
        System.out.println(ec.areRelated(17, 5));
        System.out.println(ec.areRelated(11, 6));
        System.out.println(ec.areRelated(8, 8));
        System.out.println(ec.representatives());
        System.out.println(ec.eqClass(21));
    }
}

