/*
 * Decompiled with CFR 0.152.
 */
package nuts.math;

import fig.basic.IOUtils;
import fig.basic.LogInfo;
import java.io.File;
import java.io.PrintWriter;
import java.util.Collection;
import nuts.io.CSV;
import nuts.io.IO;
import nuts.math.StatisticsMap;

public class Evaluator {
    public static <T> StatisticsMap<EvaluationScorer<T>> evaluate(File refDirectory, String refSuffix, File guessDirectory, String guessSuffix, Parser<T> parser, Collection<EvaluationScorer<T>> metrics) {
        StatisticsMap<EvaluationScorer<T>> stats = new StatisticsMap<EvaluationScorer<T>>();
        PrintWriter detailed = IOUtils.openOutHard(guessDirectory.getAbsolutePath() + ".detailed-eval.csv");
        PrintWriter summary = IOUtils.openOutHard(guessDirectory.getAbsolutePath() + ".summary-eval");
        detailed.println(CSV.header("name", "metric", "score", "guess-path", "ref-path"));
        LogInfo.track((Object)("Evaluating " + guessDirectory + " against " + refDirectory), true);
        for (File ref : IO.ls(refDirectory, refSuffix)) {
            String baseName = IO.nameWithoutExtension(ref);
            File guess = new File(guessDirectory, IO.appendSuffix(baseName, guessSuffix));
            if (!guess.exists()) {
                guess = new File(guessDirectory, IO.appendSuffix(baseName, refSuffix));
            }
            if (!guess.exists()) {
                LogInfo.warning("Missing guess file:" + ref.getName());
                for (EvaluationScorer<T> metric : metrics) {
                    stats.addValue(metric, metric.worstScore());
                }
                continue;
            }
            T guessedObject = parser.parse(guess);
            T refObject = parser.parse(ref);
            for (EvaluationScorer<T> metric : metrics) {
                double current = metric.score(refObject, guessedObject);
                stats.addValue(metric, current);
                detailed.println(CSV.body(baseName, metric, current, guess.getAbsolutePath(), ref.getAbsolutePath()));
            }
        }
        String summaryStr = stats.toString();
        summary.append(summaryStr);
        LogInfo.logs(summaryStr);
        LogInfo.end_track();
        detailed.close();
        summary.close();
        if (!stats.matchingSizes()) {
            throw new RuntimeException();
        }
        return stats;
    }

    public static interface Parser<T> {
        public T parse(File var1);
    }

    public static interface EvaluationScorer<T> {
        public double worstScore();

        public double score(T var1, T var2);
    }
}

