/*
 * Decompiled with CFR 0.152.
 */
package pedi.factor;

import fenchel.factor.multisites.MSFactorGraph;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import nuts.io.CSV;
import nuts.lang.ArrayUtils;
import nuts.math.MtxUtils;
import nuts.util.CoordinatesPacker;
import pedi.factor.PedigreeNode;

public class FactorEncodings {
    private final CoordinatesPacker haploTypePacker;
    public final int firstHomoz;
    public final int secondHomoz;
    public final int firstHeteroz;
    public final int secondHeteroz;
    private static final int UNASSIGNED = -1;
    private Map<IndexedNodeType, double[][]> data = new HashMap<IndexedNodeType, double[][]>();

    public void addBinary(MSFactorGraph<PedigreeNode> fg, PedigreeNode node1, PedigreeNode node2) {
        this.addBinary(fg, node1, node2, -1);
    }

    public void addBinary(MSFactorGraph<PedigreeNode> fg, PedigreeNode node1, PedigreeNode node2, int code) {
        fg.addBinary(node1, node2, this.get(node1.type, node2.type, code), this.get(node2.type, node1.type, code));
    }

    public void set(PedigreeNode.PedigreeNodeType nodeType1, PedigreeNode.PedigreeNodeType nodeType2, double[][] value) {
        this.set(nodeType1, nodeType2, -1, value);
    }

    public void set(PedigreeNode.PedigreeNodeType nodeType1, PedigreeNode.PedigreeNodeType nodeType2, int code, double[][] value) {
        if (this.get(nodeType1, nodeType2, code) != null) {
            throw new RuntimeException();
        }
        this.data.put(new IndexedNodeType(code, nodeType1, nodeType2), value);
        this.data.put(new IndexedNodeType(code, nodeType2, nodeType1), MtxUtils.transpose(value));
    }

    private double[][] get(PedigreeNode.PedigreeNodeType nodeType1, PedigreeNode.PedigreeNodeType nodeType2, int code) {
        double[][] result = this.data.get(new IndexedNodeType(code, nodeType1, nodeType2));
        return result;
    }

    public FactorEncodings(CoordinatesPacker packer) {
        this.haploTypePacker = packer;
        this.firstHomoz = this.haplotypeCode(0, 0);
        this.secondHomoz = this.haplotypeCode(1, 1);
        this.firstHeteroz = this.haplotypeCode(0, 1);
        this.secondHeteroz = this.haplotypeCode(1, 0);
    }

    public double mapGenotypeEditDistance(double[] truthArray, double[] guessArray, Appendable log) {
        guessArray = this.getGenotype(guessArray);
        truthArray = this.getGenotype(truthArray);
        int guess = ArrayUtils.argmax(guessArray);
        int truth = ArrayUtils.argmax(truthArray);
        double delta = Math.abs(guess - truth);
        if (log != null) {
            try {
                log.append("" + CSV.body(truth, guess, delta, Arrays.toString(guessArray)) + "\n");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return delta;
    }

    public double[] getGenotype(double[] haplotype) {
        if (haplotype.length != 4) {
            throw new RuntimeException();
        }
        double[] result = new double[]{haplotype[this.firstHomoz], haplotype[this.firstHeteroz] + haplotype[this.secondHeteroz], haplotype[this.secondHomoz]};
        return result;
    }

    public int haplotypeCode(int ... alleleValues) {
        return this.haploTypePacker.coord2int(alleleValues);
    }

    public int alleleCode(int hCode, int chrFrom) {
        return this.haploTypePacker.int2coord(hCode)[chrFrom];
    }

    public int nHaplotypes() {
        return this.haploTypePacker.size();
    }

    private static class IndexedNodeType {
        private final int code;
        private final PedigreeNode.PedigreeNodeType n1;
        private final PedigreeNode.PedigreeNodeType n2;

        private IndexedNodeType(int code, PedigreeNode.PedigreeNodeType n1, PedigreeNode.PedigreeNodeType n2) {
            this.code = code;
            this.n1 = n1;
            this.n2 = n2;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.code;
            result = 31 * result + (this.n1 == null ? 0 : this.n1.hashCode());
            result = 31 * result + (this.n2 == null ? 0 : this.n2.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IndexedNodeType other = (IndexedNodeType)obj;
            if (this.code != other.code) {
                return false;
            }
            if (this.n1 != other.n1) {
                return false;
            }
            return this.n2 == other.n2;
        }
    }
}

