/*
 * Decompiled with CFR 0.152.
 */
package sage;

import fig.basic.IOUtils;
import goblin.Baseline;
import goblin.BayesRiskMinimizer;
import goblin.CognateId;
import goblin.CognateSet;
import goblin.DataLoader;
import goblin.ReadEval;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.Map;
import ma.MultiAlignment;
import nuts.io.Extensions;
import nuts.io.IO;

public class InspectRecon {
    public static void main(String[] args) {
        double reconLen = 0.0;
        double trueLen = 0.0;
        try {
            int iteration = Integer.parseInt(args[0]);
            String iterStr = Extensions.extension2String(iteration);
            CognateSet cs = CognateSet.restoreCognateSet("snapshot" + iterStr + ".CognateSet");
            ObjectInputStream ois = IOUtils.openBinIn("heldout.List_HeldoutEntry");
            List heldout = (List)ois.readObject();
            ois.close();
            Map<CognateId, String> oracle = new Baseline.OracleBaseline(BayesRiskMinimizer.levenshteinLoss).baseline(cs, heldout);
            Map<CognateId, ReadEval.Evaluation> recons = ReadEval.read("GOBLIN-" + args[0] + ".eval");
            for (DataLoader.HeldoutEntry entry : heldout) {
                CognateId id = entry.id;
                IO.so("Id:" + id);
                IO.so("Tree\n" + cs.getTree(id).deepToString());
                IO.so("Multialign\n" + MultiAlignment.inducedMultiAlignment(cs.getTree(id)));
                IO.so("Gold:" + entry.trueReconstruction);
                String recon = recons.get((Object)id).recon;
                reconLen += (double)recon.length();
                trueLen += (double)entry.trueReconstruction.length();
                IO.so("MBR recon:" + recon);
                IO.so("Loss:" + BayesRiskMinimizer.levenshteinLoss.loss(entry.trueReconstruction, recon));
                IO.so("Oracle:" + oracle.get(id));
                IO.so("Oracle loss:" + BayesRiskMinimizer.levenshteinLoss.loss(entry.trueReconstruction, oracle.get(id)));
                IO.so("----");
            }
            IO.so("===");
            IO.so("True length:" + trueLen);
            IO.so("Recon length:" + reconLen);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("InspectRecon <iteration#>");
            return;
        }
    }
}

