/*
 * Decompiled with CFR 0.152.
 */
package smc;

import fig.basic.LogInfo;
import fig.basic.Pair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import java.util.Stack;
import monaco.process.ProcessSchedule;
import nuts.util.CollUtils;
import pty.smc.ParticleFilter;
import pty.smc.ParticleKernel;
import smc.CompactParticle;
import smc.EntangledParticleKernel;
import smc.EntangledProcessor;
import smc.EntangledRandom;
import smc.FullParticle;
import smc.Particle;
import smc.WeightCommunication;

public class EntangledStructure<S> {
    private ArrayList<Particle<S>> genealogy;
    private int[] capacity;
    private EntangledParticleKernel<S> kernel;
    private EntangledProcessor<S> processor;
    private int thisMachineId;
    private int N;
    private int T;
    public boolean lazy = false;

    public EntangledStructure(int thisMachineId, int N, int T, ParticleKernel<S> kernel, int[] capacity, ParticleFilter.ParticleProcessor<S> processor) {
        this.kernel = new EntangledParticleKernel<S>(kernel);
        this.processor = new EntangledProcessor<S>(processor);
        this.thisMachineId = thisMachineId;
        this.N = N;
        this.T = T;
        this.capacity = capacity;
        this.genealogy = new ArrayList();
    }

    private void printGenealogy() {
    }

    public double[] generateSampleAndComputeWeights(int t, int[] config, EntangledRandom eRandom, ProcessSchedule schedule) {
        this.printGenealogy();
        Particle<S> oldParticle = null;
        Particle newParticle = null;
        Pair<Object, Double> pair = null;
        double[] weights = new double[config[this.thisMachineId]];
        int k = 0;
        long pId = 0L;
        Object currSample = null;
        if (t == 0) {
            for (int m = 0; m < config.length; ++m) {
                for (int i = 0; i < config[m]; ++i) {
                    newParticle = !this.lazy && m == this.thisMachineId ? new FullParticle(m) : new CompactParticle(m);
                    pId = newParticle.getUniqueId();
                    long seed = eRandom.getSamplingSeed(pId);
                    if (m == this.thisMachineId) {
                        pair = this.kernel.next(new Random(seed), this.kernel.getInitial());
                        weights[k] = pair.getSecond();
                        ++k;
                        if (!this.lazy) {
                            newParticle.setSample(pair.getFirst(), pair.getSecond());
                        } else {
                            newParticle.setCompactParticle(seed, null);
                        }
                    } else {
                        newParticle.setCompactParticle(seed, null);
                    }
                    this.genealogy.add(newParticle);
                }
            }
        } else {
            ArrayList tempGenealogy = CollUtils.list();
            for (int n = 0; n < this.N; ++n) {
                oldParticle = this.genealogy.get(n);
                if (oldParticle == null) continue;
                currSample = null;
                int[] allocatedMachines = oldParticle.getMachines();
                for (int machine = 0; machine < allocatedMachines.length; ++machine) {
                    for (int j = 0; j < allocatedMachines[machine]; ++j) {
                        newParticle = !this.lazy && machine == this.thisMachineId ? new FullParticle(machine) : new CompactParticle(machine);
                        pId = newParticle.getUniqueId();
                        long seed = eRandom.getSamplingSeed(pId);
                        if (machine == this.thisMachineId) {
                            if (oldParticle.getSample() == null) {
                                LogInfo.logs("Unrecoverable error: currSample is null");
                                System.exit(-1);
                            }
                            currSample = oldParticle.getSample();
                            pair = this.kernel.next(new Random(seed), currSample);
                            weights[k] = pair.getSecond();
                            ++k;
                            if (!this.lazy) {
                                newParticle.setSample(pair.getFirst(), pair.getSecond());
                            } else {
                                newParticle.setCompactParticle(seed, oldParticle);
                            }
                        } else {
                            newParticle.setCompactParticle(seed, oldParticle);
                        }
                        tempGenealogy.add(newParticle);
                    }
                }
            }
            this.genealogy = tempGenealogy;
        }
        if (k != config[this.thisMachineId]) {
            LogInfo.logs("Unrecoverable error: generated " + k + " samples but should be " + config[this.thisMachineId]);
            System.exit(-1);
        }
        this.printGenealogy();
        return weights;
    }

    public void reconstruct(int n) {
        Particle<S> particle = this.genealogy.get(n);
        if (particle instanceof CompactParticle) {
            Particle<S> parent;
            Stack<Long> seeds = new Stack<Long>();
            long seed = 0L;
            for (parent = particle; parent != null && !(parent instanceof FullParticle); parent = parent.getParent()) {
                seed = ((CompactParticle)parent).getSeed();
                seeds.push(seed);
            }
            S currSample = parent == null ? this.kernel.getInitial() : parent.getSample();
            double weight = 0.0;
            while (!seeds.empty()) {
                seed = (Long)seeds.pop();
                Pair<S, Double> pair = this.kernel.next(new Random(seed), currSample);
                currSample = pair.getFirst();
                weight = pair.getSecond();
            }
            particle = particle.setSample(currSample, weight);
            this.genealogy.set(n, particle);
        }
        particle.addMachine(this.thisMachineId);
    }

    public void updateCompactParticle(int n, int newMachineId) {
        Particle<S> p = this.genealogy.get(n);
        p.addMachine(newMachineId);
    }

    public void remove(int n) {
        this.genealogy.set(n, null);
    }

    public void allocateFirstOpen(int n, int[] config) {
        Particle<S> p = this.genealogy.get(n);
        int machine = p.getMachine();
        if (config[machine] >= this.capacity[machine]) {
            for (int k = 0; k < config.length; ++k) {
                if (config[k] >= this.capacity[k]) continue;
                machine = k;
                break;
            }
        }
        int n2 = machine;
        config[n2] = config[n2] + 1;
        if (machine == this.thisMachineId) {
            this.reconstruct(n);
        } else {
            this.updateCompactParticle(n, machine);
        }
    }

    public void allocateMostAvailable(int n, int[] config) {
        Particle<S> p = this.genealogy.get(n);
        int machine = p.getMachine();
        if (config[machine] >= this.capacity[machine]) {
            machine = 0;
            for (int k = 1; k < config.length; ++k) {
                if (this.capacity[k] - config[k] <= this.capacity[machine] - config[machine]) continue;
                LogInfo.logs("machine=" + k + " has " + config[k] + " particles allocated; machine=" + machine + " has " + config[machine] + " particles allocated");
                machine = k;
            }
        }
        int n2 = machine;
        config[n2] = config[n2] + 1;
        if (machine == this.thisMachineId) {
            this.reconstruct(n);
        } else {
            this.updateCompactParticle(n, machine);
        }
    }

    public void allocateRetainRandom(int n, int[] config, EntangledRandom eRandom) {
        Particle<S> p = this.genealogy.get(n);
        int machine = p.getMachine();
        if (config[machine] >= this.capacity[machine]) {
            while (config[machine = eRandom.sampleMachine(config.length)] >= this.capacity[machine]) {
            }
        }
        int n2 = machine;
        config[n2] = config[n2] + 1;
        if (machine == this.thisMachineId) {
            this.reconstruct(n);
        } else {
            this.updateCompactParticle(n, machine);
        }
    }

    public void allocateRandomly(int n, int[] config, EntangledRandom eRandom) {
        int machine;
        int n2 = machine = eRandom.sampleMachine(config.length);
        config[n2] = config[n2] + 1;
        if (machine == this.thisMachineId) {
            this.reconstruct(n);
        } else {
            this.updateCompactParticle(n, machine);
        }
    }

    public double readWeights(int t, int[] config, double[] allWeights) throws IOException, WeightCommunication.WeightTimeoutException {
        int[] indices = new int[config.length];
        double[] weights = new double[this.N];
        double norm = 0.0;
        int index = 0;
        for (int k = 0; k < config.length; ++k) {
            indices[k] = index;
            if (k != this.thisMachineId) {
                norm += WeightCommunication.readWeights(t, this.thisMachineId, k, index, weights);
            }
            index += config[k];
        }
        Particle<S> p = null;
        for (int n = 0; n < this.N; ++n) {
            p = this.genealogy.get(n);
            if (p.getMachine() == this.thisMachineId) {
                allWeights[n] = p.getWeight();
                continue;
            }
            allWeights[n] = weights[indices[p.getMachine()]];
            int n2 = p.getMachine();
            indices[n2] = indices[n2] + 1;
        }
        this.printWeights(allWeights);
        return norm;
    }

    public void setWeight(int n, double w) {
        Particle<S> p = this.genealogy.get(n);
        if (p.getMachine() == this.thisMachineId) {
            p.setWeight(w);
        }
    }

    public void distributedProcess() {
        Particle<S> particle = null;
        for (int n = 0; n < this.N; ++n) {
            particle = this.genealogy.get(n);
            if (particle == null) {
                throw new RuntimeException();
            }
            if (particle.getMachine() != this.thisMachineId) continue;
            this.processor.process(particle.getSample(), particle.getWeight());
        }
    }

    public void printStatistics() {
        LogInfo.logs("numTotalIterations=" + this.kernel.getNumIterations());
        if (this.thisMachineId == 0) {
            LogInfo.logs("numProcessed=" + this.processor.getNumParticlesProcessed());
        }
    }

    private void printWeights(double[] weights) {
    }
}

