/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.Tree;
import org.eclipse.jgit.util.RawParseUtils;

@Deprecated
public abstract class TreeEntry
implements Comparable {
    private byte[] nameUTF8;
    private Tree parent;
    private ObjectId id;

    protected TreeEntry(Tree myParent, ObjectId myId, byte[] myNameUTF8) {
        this.nameUTF8 = myNameUTF8;
        this.parent = myParent;
        this.id = myId;
    }

    public Tree getParent() {
        return this.parent;
    }

    public void delete() {
        this.getParent().removeEntry(this);
        this.detachParent();
    }

    public void detachParent() {
        this.parent = null;
    }

    void attachParent(Tree p) {
        this.parent = p;
    }

    public Repository getRepository() {
        return this.getParent().getRepository();
    }

    public byte[] getNameUTF8() {
        return this.nameUTF8;
    }

    public String getName() {
        if (this.nameUTF8 != null) {
            return RawParseUtils.decode(this.nameUTF8);
        }
        return null;
    }

    public void rename(String n) throws IOException {
        this.rename(Constants.encode(n));
    }

    public void rename(byte[] n) throws IOException {
        Tree t = this.getParent();
        if (t != null) {
            this.delete();
        }
        this.nameUTF8 = n;
        if (t != null) {
            t.addEntry(this);
        }
    }

    public boolean isModified() {
        return this.getId() == null;
    }

    public void setModified() {
        this.setId(null);
    }

    public ObjectId getId() {
        return this.id;
    }

    public void setId(ObjectId n) {
        Tree p = this.getParent();
        if (p != null && this.id != n && (this.id == null && n != null || this.id != null && n == null || !this.id.equals(n))) {
            p.setId(null);
        }
        this.id = n;
    }

    public String getFullName() {
        StringBuilder r = new StringBuilder();
        this.appendFullName(r);
        return r.toString();
    }

    public byte[] getFullNameUTF8() {
        return this.getFullName().getBytes();
    }

    public int compareTo(Object o) {
        if (this == o) {
            return 0;
        }
        if (o instanceof TreeEntry) {
            return Tree.compareNames(this.nameUTF8, ((TreeEntry)o).nameUTF8, TreeEntry.lastChar(this), TreeEntry.lastChar((TreeEntry)o));
        }
        return -1;
    }

    public static final int lastChar(TreeEntry treeEntry) {
        if (!(treeEntry instanceof Tree)) {
            return 0;
        }
        return 47;
    }

    public abstract FileMode getMode();

    private void appendFullName(StringBuilder r) {
        Tree p = this.getParent();
        String n = this.getName();
        if (p != null) {
            super.appendFullName(r);
            if (r.length() > 0) {
                r.append('/');
            }
        }
        if (n != null) {
            r.append(n);
        }
    }
}

