/*
 * Decompiled with CFR 0.152.
 */
package ev.par;

import ev.par.Input;
import ev.par.Output;
import ev.par.StrTaxonSuffStat;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import nuts.maxent.BaseMeasures;
import nuts.util.Indexer;
import pepper.Encodings;

public final class Model {
    public final StrTaxonSuffStat stSuffStat;
    public final Encodings enc;
    public final int nStates;
    public final Indexer<Object> stateIndexer;
    public final int startState;
    public final int endState;
    public final int epsilon;
    public static final String SUB = "SUB";
    public static final String INS = "INS";
    public static final String DEL = "DEL";

    public Model(StrTaxonSuffStat stSuffStat, Encodings enc, Indexer<Object> stateIndexer, int startState, int endState) {
        this.stSuffStat = stSuffStat;
        this.enc = enc;
        this.stateIndexer = stateIndexer;
        this.nStates = stateIndexer.size();
        this.startState = startState;
        this.endState = endState;
        this.epsilon = enc.N();
    }

    public int epsilon() {
        return this.epsilon;
    }

    public List<Input> allInputs() {
        ArrayList<Input> result = new ArrayList<Input>();
        for (int s1 = 0; s1 < this.nStates; ++s1) {
            for (int stss = 0; stss < this.stSuffStat.valuesIndexer.size(); ++stss) {
                result.add(new Input(s1, stss, this));
            }
        }
        return result;
    }

    public List<Output> allOutputs() {
        ArrayList<Output> result = new ArrayList<Output>();
        for (int s1 = 0; s1 < this.nStates; ++s1) {
            for (int sym1 = 0; sym1 < this.enc.N() + 1; ++sym1) {
                for (int sym2 = 0; sym2 < this.enc.N() + 1; ++sym2) {
                    if (sym1 == this.epsilon() && sym2 == this.epsilon()) continue;
                    result.add(new Output(s1, sym1, sym2, this));
                }
            }
        }
        return result;
    }

    public static Model stdModel(Encodings enc) {
        return Model.stdBranchSpecificModel(enc, null);
    }

    public static Model stdBranchSpecificModel(Encodings enc, StrTaxonSuffStat stss) {
        Indexer<Object> stateIndexer = new Indexer<Object>();
        stateIndexer.addToIndex(SUB);
        stateIndexer.addToIndex(INS);
        stateIndexer.addToIndex(DEL);
        int specialState = stateIndexer.o2i(SUB);
        return new Model(stss, enc, stateIndexer, specialState, specialState);
    }

    public int charIdAt(String str, int xpos, int dx) {
        if (dx == 0) {
            return this.epsilon();
        }
        if (dx == 1) {
            int result = this.enc.char2PhoneId(str.charAt(xpos));
            if (result == -1) {
                throw new RuntimeException("Unknown character: " + str.charAt(xpos) + " in sequence: " + str);
            }
            return result;
        }
        throw new RuntimeException();
    }

    public static class ThreeStatesBaseMeasure
    implements BaseMeasures<Input, Output> {
        private static final long serialVersionUID = 1L;
        private final SortedSet<Output> from01 = new TreeSet<Output>();
        private final SortedSet<Output> from2 = new TreeSet<Output>();
        private final int s0;
        private final int s1;
        private final int s2;

        public ThreeStatesBaseMeasure(Model model) {
            int bot;
            int top;
            int bound = model.enc.getBoundaryPhoneId();
            this.s0 = model.stateIndexer.o2i(Model.SUB);
            this.s1 = model.stateIndexer.o2i(Model.INS);
            this.s2 = model.stateIndexer.o2i(Model.DEL);
            if (model.stateIndexer.size() != 3) {
                throw new RuntimeException();
            }
            for (top = 0; top < model.enc.N(); ++top) {
                for (bot = 0; bot < model.enc.N(); ++bot) {
                    if (!this.bothOrNeitherBound(bound, top, bot)) continue;
                    this.from01.add(new Output(this.s0, top, bot, model));
                }
            }
            for (int bot2 = 0; bot2 < model.enc.N(); ++bot2) {
                if (bot2 == bound) continue;
                this.from01.add(new Output(this.s1, model.epsilon(), bot2, model));
            }
            for (top = 0; top < model.enc.N(); ++top) {
                if (top == bound) continue;
                this.from01.add(new Output(this.s2, top, model.epsilon(), model));
            }
            for (top = 0; top < model.enc.N(); ++top) {
                for (bot = 0; bot < model.enc.N(); ++bot) {
                    if (!this.bothOrNeitherBound(bound, top, bot)) continue;
                    this.from2.add(new Output(this.s0, top, bot, model));
                }
            }
            for (top = 0; top < model.enc.N(); ++top) {
                if (top == bound) continue;
                this.from2.add(new Output(this.s2, top, model.epsilon(), model));
            }
        }

        private boolean bothOrNeitherBound(int bound, int top, int bot) {
            if (top == bound && bot == bound) {
                return true;
            }
            return top != bound && bot != bound;
        }

        @Override
        public SortedSet<Output> support(Input input) {
            if (input.state1 == this.s0 || input.state1 == this.s1) {
                return this.from01;
            }
            if (input.state1 == this.s2) {
                return this.from2;
            }
            throw new RuntimeException();
        }
    }
}

