/*
 * Decompiled with CFR 0.152.
 */
package fenchel.factor.multisites;

import fenchel.algo.FactorGraphInferenceAlgorithm;
import fenchel.algo.FactorGraphSumProduct;
import fenchel.factor.multisites.MSFactorGraph;
import fenchel.factor.multisites.MSUnaryMap;
import fenchel.factor.multisites.SubFactorGraph;
import fenchel.measurefacto.ExtendedExponentialFamily;
import java.util.Set;
import nuts.math.Graph;
import nuts.util.CollUtils;

public class SubGraphExponentialFamily<N>
implements ExtendedExponentialFamily<MSUnaryMap<N>> {
    private final MSFactorGraph<N> baseFactorGraph;
    private final Graph<N> subgraph;
    private final Set<N> richNodesSet;
    private final Set<N> querySet;
    private final boolean useovercomplete;
    private FactorGraphInferenceAlgorithm<N> algorithm = null;

    SubGraphExponentialFamily(MSFactorGraph<N> baseFactorGraph, Graph<N> subgraph, Set<N> richNodesSet, Set<N> querySet, boolean overc) {
        this.querySet = querySet;
        this.useovercomplete = overc;
        this.baseFactorGraph = baseFactorGraph;
        this.subgraph = subgraph;
        this.richNodesSet = CollUtils.inter(richNodesSet, subgraph.vertexSet());
    }

    @Override
    public MSUnaryMap<N> moments(MSUnaryMap<N> input) {
        if (!this.useovercomplete) {
            input.setLastStatesToOne();
        }
        SubFactorGraph<N> auxiliaryFactorGraph = new SubFactorGraph<N>(this.baseFactorGraph, this.subgraph, input);
        this.algorithm = new FactorGraphSumProduct();
        this.algorithm.init(auxiliaryFactorGraph);
        return MSUnaryMap.fromMoments(this.algorithm, this.richNodesSet, !this.useovercomplete);
    }

    @Override
    public MSUnaryMap<N> getExtendedStatistics() {
        return MSUnaryMap.fromMoments(this.algorithm, this.querySet, false);
    }
}

