/*
 * Decompiled with CFR 0.152.
 */
package fig.basic;

import java.util.Arrays;
import java.util.LinkedHashSet;

public class BipartiteMatcher {
    public double[][] copy(double[][] matrix) {
        double[][] newMatrix = new double[matrix.length][matrix[0].length];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[i].length; ++j) {
                newMatrix[i][j] = matrix[i][j];
            }
        }
        return newMatrix;
    }

    public int[] findMaxWeightAssignment(double[][] matrix) {
        matrix = this.copy(matrix);
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[i].length; ++j) {
                matrix[i][j] = -matrix[i][j];
            }
        }
        return this.findBestAssignment(matrix);
    }

    public int[] findMinWeightAssignment(double[][] matrix) {
        matrix = this.copy(matrix);
        return this.findBestAssignment(matrix);
    }

    public int[] findBestAssignment(double[][] matrix) {
        this.reduceMatrix(matrix);
        int[] starsByRow = new int[matrix.length];
        Arrays.fill(starsByRow, -1);
        int[] starsByCol = new int[matrix[0].length];
        Arrays.fill(starsByCol, -1);
        int[] primesByRow = new int[matrix.length];
        Arrays.fill(primesByRow, -1);
        int[] coveredRows = new int[matrix.length];
        int[] coveredCols = new int[matrix[0].length];
        this.initStars(matrix, starsByRow, starsByCol);
        this.coverColumnsOfStarredZeroes(starsByCol, coveredCols);
        while (!this.allAreCovered(coveredCols)) {
            int[] primedZero = this.primeSomeUncoveredZero(matrix, primesByRow, coveredRows, coveredCols);
            while (primedZero == null) {
                this.makeMoreZeroes(matrix, coveredRows, coveredCols);
                primedZero = this.primeSomeUncoveredZero(matrix, primesByRow, coveredRows, coveredCols);
            }
            int columnIndex = starsByRow[primedZero[0]];
            if (-1 == columnIndex) {
                this.incrementSetOfStarredZeroes(primedZero, starsByRow, starsByCol, primesByRow);
                Arrays.fill(primesByRow, -1);
                Arrays.fill(coveredRows, 0);
                Arrays.fill(coveredCols, 0);
                this.coverColumnsOfStarredZeroes(starsByCol, coveredCols);
                continue;
            }
            coveredRows[primedZero[0]] = 1;
            coveredCols[columnIndex] = 0;
        }
        int[] assign = new int[starsByCol.length];
        for (int i = 0; i < starsByCol.length; ++i) {
            assign[starsByCol[i]] = i;
        }
        return assign;
    }

    private boolean allAreCovered(int[] coveredCols) {
        for (int covered : coveredCols) {
            if (0 != covered) continue;
            return false;
        }
        return true;
    }

    private void reduceMatrix(double[][] matrix) {
        int j;
        int i;
        for (i = 0; i < matrix.length; ++i) {
            double minValInRow = Double.MAX_VALUE;
            for (j = 0; j < matrix[i].length; ++j) {
                if (!(minValInRow > matrix[i][j])) continue;
                minValInRow = matrix[i][j];
            }
            j = 0;
            while (j < matrix[i].length) {
                double[] dArray = matrix[i];
                int n = j++;
                dArray[n] = dArray[n] - minValInRow;
            }
        }
        for (i = 0; i < matrix[0].length; ++i) {
            double minValInCol = Double.MAX_VALUE;
            for (j = 0; j < matrix.length; ++j) {
                if (!(minValInCol > matrix[j][i])) continue;
                minValInCol = matrix[j][i];
            }
            for (j = 0; j < matrix.length; ++j) {
                double[] dArray = matrix[j];
                int n = i;
                dArray[n] = dArray[n] - minValInCol;
            }
        }
    }

    private void initStars(double[][] costMatrix, int[] starsByRow, int[] starsByCol) {
        int[] rowHasStarredZero = new int[costMatrix.length];
        int[] colHasStarredZero = new int[costMatrix[0].length];
        block0: for (int i = 0; i < costMatrix.length; ++i) {
            for (int j = 0; j < costMatrix[i].length; ++j) {
                if (0.0 != costMatrix[i][j] || 0 != rowHasStarredZero[i] || 0 != colHasStarredZero[j]) continue;
                starsByRow[i] = j;
                starsByCol[j] = i;
                rowHasStarredZero[i] = 1;
                colHasStarredZero[j] = 1;
                continue block0;
            }
        }
    }

    private void coverColumnsOfStarredZeroes(int[] starsByCol, int[] coveredCols) {
        for (int i = 0; i < starsByCol.length; ++i) {
            coveredCols[i] = -1 == starsByCol[i] ? 0 : 1;
        }
    }

    private int[] primeSomeUncoveredZero(double[][] matrix, int[] primesByRow, int[] coveredRows, int[] coveredCols) {
        for (int i = 0; i < matrix.length; ++i) {
            if (1 == coveredRows[i]) continue;
            for (int j = 0; j < matrix[i].length; ++j) {
                if (0.0 != matrix[i][j] || 0 != coveredCols[j]) continue;
                primesByRow[i] = j;
                return new int[]{i, j};
            }
        }
        return null;
    }

    private void incrementSetOfStarredZeroes(int[] unpairedZeroPrime, int[] starsByRow, int[] starsByCol, int[] primesByRow) {
        int i;
        int j = unpairedZeroPrime[1];
        LinkedHashSet<int[]> zeroSequence = new LinkedHashSet<int[]>();
        zeroSequence.add(unpairedZeroPrime);
        boolean paired = false;
        do {
            boolean bl = paired = -1 != (i = starsByCol[j]) && zeroSequence.add(new int[]{i, j});
        } while (paired && (paired = -1 != (j = primesByRow[i]) && zeroSequence.add(new int[]{i, j})));
        for (int[] zero : zeroSequence) {
            if (starsByCol[zero[1]] == zero[0]) {
                starsByCol[zero[1]] = -1;
                starsByRow[zero[0]] = -1;
            }
            if (primesByRow[zero[0]] != zero[1]) continue;
            starsByRow[zero[0]] = zero[1];
            starsByCol[zero[1]] = zero[0];
        }
    }

    private void makeMoreZeroes(double[][] matrix, int[] coveredRows, int[] coveredCols) {
        int j;
        int i;
        double minUncoveredValue = Double.MAX_VALUE;
        for (i = 0; i < matrix.length; ++i) {
            if (0 != coveredRows[i]) continue;
            for (j = 0; j < matrix[i].length; ++j) {
                if (0 != coveredCols[j] || !(matrix[i][j] < minUncoveredValue)) continue;
                minUncoveredValue = matrix[i][j];
            }
        }
        for (i = 0; i < coveredRows.length; ++i) {
            if (1 != coveredRows[i]) continue;
            j = 0;
            while (j < matrix[i].length) {
                double[] dArray = matrix[i];
                int n = j++;
                dArray[n] = dArray[n] + minUncoveredValue;
            }
        }
        for (i = 0; i < coveredCols.length; ++i) {
            if (0 != coveredCols[i]) continue;
            for (j = 0; j < matrix.length; ++j) {
                double[] dArray = matrix[j];
                int n = i;
                dArray[n] = dArray[n] - minUncoveredValue;
            }
        }
    }

    public static void main(String[] args) {
        double[][] mat = new double[][]{{3.0, 3.0, 0.0}, {3.0, 3.0, 0.0}, {0.0, 5.0, 0.0}};
        int[] assign = new BipartiteMatcher().findBestAssignment(mat);
        for (int i = 0; i < assign.length; ++i) {
            System.out.println(i + " => " + assign[i]);
        }
    }
}

