/*
 * Decompiled with CFR 0.152.
 */
package gep.data;

import fig.basic.Option;
import gep.data.DataSource;
import gep.timeseries.Measurements;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import nuts.io.IO;
import nuts.util.CollUtils;
import nuts.util.Indexer;

public class LoadFlatDataFormat
implements DataSource {
    @Option
    public String flatDataFile = "";
    private List<Measurements> _data = null;
    private int pointer = 0;
    public static final Pattern IGNORE_LINE_MATCH = Pattern.compile("^([#].*)?\\s*$");
    private Set<String> _possibleObs;

    private void ensureLoaded(Indexer<String> indexer) {
        if (this._data != null) {
            return;
        }
        this._data = CollUtils.list();
        this._possibleObs = CollUtils.set();
        this._read(false, indexer);
    }

    private void _read(boolean justPeakingValue, Indexer<String> indexer) {
        int index = 0;
        ArrayList<Double> times = CollUtils.list();
        ArrayList<Integer> values = CollUtils.list();
        for (String line : IO.i(this.flatDataFile)) {
            if (IGNORE_LINE_MATCH.matcher(line).matches()) continue;
            String[] fields = line.split("\\s+");
            if (index++ % 2 == 0) {
                if (justPeakingValue) continue;
                for (String field : fields) {
                    times.add(Double.parseDouble(field));
                }
                continue;
            }
            for (String field : fields) {
                if (justPeakingValue) {
                    this._possibleObs.add(field);
                    continue;
                }
                values.add(indexer.o2i(field));
            }
            if (justPeakingValue) continue;
            Measurements currentM = new Measurements(times, values);
            this._data.add(currentM);
            times = CollUtils.list();
            values = CollUtils.list();
        }
        if (times.size() != 0) {
            throw new RuntimeException();
        }
    }

    @Override
    public Measurements next(Indexer<String> indexer) {
        this.ensureLoaded(indexer);
        if (this.pointer++ < this._data.size()) {
            return this._data.get(this.pointer - 1);
        }
        return null;
    }

    @Override
    public Set<String> possibleObservations() {
        if (this._possibleObs == null) {
            this._possibleObs = CollUtils.set();
            this._read(true, null);
        }
        return this._possibleObs;
    }
}

