/*
 * Decompiled with CFR 0.152.
 */
package gep.timeseries;

import gep.GEPMain;
import gep.model.SplitContext;
import gep.model.SufficientStatistics;
import gep.model.SufficientStatisticsImpl;
import gep.pmcmc.Generator;
import gep.timeseries.Event;
import gep.timeseries.Measurements;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import nuts.util.CollUtils;
import nuts.util.CounterMap;
import nuts.util.Indexer;
import nuts.util.MathUtils;

public class Series {
    public final List<Double> queries;
    public final Measurements observations;
    public boolean initialized = false;
    public CounterMap<Integer, Integer> queryStats = new CounterMap();
    public SufficientStatistics<SplitContext, SplitContext> suffStats = new SufficientStatisticsImpl<SplitContext, SplitContext>();
    public double previousLogLL = Double.NEGATIVE_INFINITY;
    public List<Event<SplitContext>> currentHiddenVariables = null;

    public List<Double> allTimes() {
        HashSet answer = CollUtils.set();
        answer.addAll(this.queries);
        answer.addAll(this.observations.getTimes());
        if (answer.size() != this.queries.size() + this.observations.size()) {
            throw new RuntimeException();
        }
        ArrayList<Double> ordered = CollUtils.list(answer);
        Collections.sort(ordered);
        return ordered;
    }

    public Series(Measurements observations, List<Double> queries) {
        this.queries = queries;
        this.observations = observations;
    }

    public CounterMap<Integer, Integer> getQueryPosteriors() {
        CounterMap<Integer, Integer> result = new CounterMap<Integer, Integer>();
        result.incrementAll(this.queryStats);
        result.normalize();
        return result;
    }

    public void updateQueryStats() {
        for (int queryIndex = 0; queryIndex < this.queries.size(); ++queryIndex) {
            boolean found = false;
            double queryPosition = this.queries.get(queryIndex);
            for (int hidIndex = 1; hidIndex < this.currentHiddenVariables.size(); ++hidIndex) {
                Event<SplitContext> e2;
                Event<SplitContext> e1 = this.currentHiddenVariables.get(hidIndex - 1);
                if (!(Event.left(e1, e2 = this.currentHiddenVariables.get(hidIndex)) <= queryPosition) || !(queryPosition < Event.right(e1, e2))) continue;
                int curChar = Event.contents(e1, e2).getX();
                this.queryStats.incrementCount(queryIndex, curChar, 1.0);
                found = true;
                break;
            }
            if (found) continue;
            throw new RuntimeException("None matched queryIndex=" + queryIndex + ", pos=" + queryIndex + "\n" + "Series:\n" + Generator.toString(this.currentHiddenVariables, new Indexer<Double>(), GEPMain.observedIndexer));
        }
    }

    public boolean isObserved(double d) {
        if (this._isObserved(d)) {
            return true;
        }
        if (!this._isQuery(d)) {
            throw new RuntimeException();
        }
        return false;
    }

    private boolean _isObserved(double d) {
        for (double d2 : this.observations.getTimes()) {
            if (!MathUtils.close(d, d2)) continue;
            return true;
        }
        return false;
    }

    private boolean _isQuery(double d) {
        for (double d2 : this.queries) {
            if (!MathUtils.close(d, d2)) continue;
            return true;
        }
        return false;
    }

    public int observationAt(double double1) {
        for (int i = 0; i < this.observations.size(); ++i) {
            if (!MathUtils.close(double1, this.observations.getTime(i))) continue;
            return this.observations.getValue(i);
        }
        throw new RuntimeException();
    }
}

