/*
 * Decompiled with CFR 0.152.
 */
package nuts.math;

import fig.basic.NumUtils;
import fig.basic.Option;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import nuts.math.MeasureZeroException;

public class RejectionSampler<T> {
    @Option
    public int nTrials = 100;
    @Option(gloss="Should two threshold be used?")
    public boolean useTowThreshold = true;
    @Option
    public int higherThreshold = 20000;
    private boolean useHighThreshold = false;
    private List<RejectionFilter<T>> rejectionFilters;
    private InnerSampler<T> sampler;
    private double nQueries = 0.0;
    private double nRejections = 0.0;
    private double[] nQueriesPerFilter;
    private double[] nRejectionsPerFilter;
    private double nFailures = 0.0;
    private double nMHRejection = 0.0;
    private double nMHQueries = 0.0;
    private boolean doMH = false;
    private Random rand;
    private double currentMHRatio;

    public List<RejectionFilter<T>> getRejectionFilters() {
        return this.rejectionFilters;
    }

    public boolean isComputingMHRatios() {
        return this.doMH;
    }

    public void initFilters(List<RejectionFilter<T>> rejectionFilters) {
        this.rejectionFilters = rejectionFilters;
        this.nQueriesPerFilter = new double[rejectionFilters.size()];
        this.nRejectionsPerFilter = new double[rejectionFilters.size()];
        this.nQueries = 0.0;
        this.nRejections = 0.0;
        this.nFailures = 0.0;
        this.nMHRejection = 0.0;
        this.nMHQueries = 0.0;
    }

    public void setDoMH(boolean doMH) {
        if (doMH != this.doMH && this.nQueries > 0.0) {
            throw new RuntimeException();
        }
        this.doMH = doMH;
    }

    public String toString() {
        return "" + this.rejectionRate();
    }

    public double rejectionRate() {
        return this.nRejections / this.nQueries;
    }

    public RejectionSampler() {
        this.initFilters(new ArrayList<RejectionFilter<T>>());
        this.setDoMH(false);
    }

    public int nFilters() {
        return this.rejectionFilters.size();
    }

    private boolean reject(T candidate) {
        this.nQueries += 1.0;
        for (int i = 0; i < this.rejectionFilters.size(); ++i) {
            int n = i;
            this.nQueriesPerFilter[n] = this.nQueriesPerFilter[n] + 1.0;
            if (!this.rejectionFilters.get(i).reject(candidate)) continue;
            this.nRejections += 1.0;
            int n2 = i;
            this.nRejectionsPerFilter[n2] = this.nRejectionsPerFilter[n2] + 1.0;
            return true;
        }
        return false;
    }

    private boolean MHReject() {
        double MHRatio;
        this.nMHQueries += 1.0;
        if (!this.doMH) {
            return false;
        }
        this.currentMHRatio = MHRatio = this.sampler.MHratio();
        if (!NumUtils.isProb(MHRatio)) {
            throw new RuntimeException("Should be a prob:" + MHRatio);
        }
        double coinFlip = this.rand.nextDouble();
        if (coinFlip > MHRatio) {
            this.nMHRejection += 1.0;
            this.nRejections += 1.0;
            return true;
        }
        return false;
    }

    public void initInnerSampler(InnerSampler<T> sampler) {
        this.useHighThreshold = false;
        this.sampler = sampler;
    }

    public T sample(Random rand) throws MeasureZeroException {
        this.rand = rand;
        double sumRatio = 0.0;
        double N = 0.0;
        int Nzero = 0;
        for (int i = 0; i < (this.useHighThreshold ? this.higherThreshold : this.nTrials); ++i) {
            T current = this.sampler.sample();
            if (!this.reject(current) && !this.MHReject()) {
                this.useHighThreshold = true;
                return current;
            }
            if (!this.doMH) continue;
            sumRatio += this.currentMHRatio;
            N += 1.0;
            if (this.currentMHRatio != 0.0) continue;
            ++Nzero;
        }
        this.nFailures += 1.0;
        throw new MeasureZeroException("Maximum number of rejection sampling rounds reached. Mean ratio was:" + sumRatio / N + ", Number of zero ratios: " + Nzero + "/" + N);
    }

    public static interface RejectionFilter<T> {
        public boolean reject(T var1);
    }

    public static interface InnerSampler<T> {
        public T sample() throws MeasureZeroException;

        public double MHratio();
    }
}

