/*
 * Decompiled with CFR 0.152.
 */
package nuts.math;

import fig.basic.LogInfo;
import org.apache.commons.math.ConvergenceException;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.integration.TrapezoidIntegrator;
import org.apache.commons.math.analysis.integration.UnivariateRealIntegratorImpl;

public class TrapezoidLogSpaceIntegrator
extends UnivariateRealIntegratorImpl {
    private static final long serialVersionUID = 4978222553983172543L;
    private double s;
    public static final double logOneHalf = Math.log(0.5);

    public static void main(String[] args) throws Exception {
        UnivariateRealFunction fct = new UnivariateRealFunction(){

            public double value(double x) throws FunctionEvaluationException {
                return x * x;
            }
        };
        UnivariateRealFunction logFct = new UnivariateRealFunction(){

            public double value(double x) throws FunctionEvaluationException {
                return 2.0 * Math.log(x);
            }
        };
        TrapezoidIntegrator i1 = new TrapezoidIntegrator(fct);
        System.out.println("Std=" + i1.integrate(0.0, 10.0));
        TrapezoidLogSpaceIntegrator i2 = new TrapezoidLogSpaceIntegrator(logFct);
        System.out.println("Log space=" + Math.exp(i2.integrate(0.0, 10.0)));
    }

    public TrapezoidLogSpaceIntegrator(UnivariateRealFunction f) {
        super(f, 64);
    }

    double stage(double min, double max, int n) throws FunctionEvaluationException {
        double sum = Double.NEGATIVE_INFINITY;
        if (n == 0) {
            this.s = logOneHalf + Math.log(max - min) + TrapezoidLogSpaceIntegrator.logAdd(this.f.value(min), this.f.value(max));
            return this.s;
        }
        long np = 1L << n - 1;
        double spacing = (max - min) / (double)np;
        double x = min + 0.5 * spacing;
        for (long i = 0L; i < np; ++i) {
            sum = TrapezoidLogSpaceIntegrator.logAdd(sum, this.f.value(x));
            x += spacing;
        }
        this.s = logOneHalf + TrapezoidLogSpaceIntegrator.logAdd(this.s, sum + Math.log(spacing));
        return this.s;
    }

    public static double logAdd(double logX, double logY) {
        if (logY > logX) {
            double temp = logX;
            logX = logY;
            logY = temp;
        }
        if (logX == Double.NEGATIVE_INFINITY) {
            return logX;
        }
        double negDiff = logY - logX;
        if (negDiff < -20.0) {
            return logX;
        }
        double result = logX + Math.log(1.0 + Math.exp(negDiff));
        return result;
    }

    public double integrate(double min, double max) throws MaxIterationsExceededException, FunctionEvaluationException, IllegalArgumentException {
        this.clearResult();
        this.verifyInterval(min, max);
        this.verifyIterationCount();
        double oldt = this.stage(min, max, 0);
        for (int i = 1; i <= this.maximalIterationCount; ++i) {
            LogInfo.logs("Current estimate:" + oldt);
            double t = this.stage(min, max, i);
            if (i >= this.minimalIterationCount && Math.abs(t - oldt) <= Math.abs(this.relativeAccuracy * oldt)) {
                this.setResult(t, i);
                return this.result;
            }
            oldt = t;
        }
        throw new MaxIterationsExceededException(this.maximalIterationCount);
    }

    protected void verifyIterationCount() throws IllegalArgumentException {
        super.verifyIterationCount();
        if (this.maximalIterationCount > 64) {
            throw new IllegalArgumentException("Iteration upper limit out of [0, 64] range: " + this.maximalIterationCount);
        }
    }

    public double integrate(UnivariateRealFunction f, double min, double max) throws ConvergenceException, FunctionEvaluationException, IllegalArgumentException {
        throw new RuntimeException();
    }
}

