/*
 * Decompiled with CFR 0.152.
 */
package pepper.editmodel.features;

import java.util.HashSet;
import nuts.maxent.FeatureExtractor;
import nuts.maxent.LabeledInstance;
import nuts.util.Counter;
import pepper.Edit;
import pepper.Effect;
import pepper.Encodings;
import pepper.Environment;
import pepper.PhonemeEqClass;

public class MultiGranEditFeaturesExtractor
implements FeatureExtractor<LabeledInstance<Environment, Effect>, String> {
    @Override
    public Counter<String> extractFeatures(LabeledInstance<Environment, Effect> instance) {
        Counter<String> feature = new Counter<String>();
        Encodings enc = instance.getInput().getEncodings();
        Edit edit = new Edit(enc, instance.getInput(), instance.getLabel());
        PhonemeEqClass c1EC = enc.retrieveEqClass(edit.c1);
        PhonemeEqClass c2EC = enc.retrieveEqClass(edit.c2);
        HashSet<String> leftEnvs = new HashSet<String>();
        leftEnvs.addAll(c1EC.getDescription());
        leftEnvs.add("A");
        HashSet<String> rightEnvs = new HashSet<String>();
        rightEnvs.addAll(c2EC.getDescription());
        rightEnvs.add("A");
        for (String leftEnv : leftEnvs) {
            for (String rightEnv : rightEnvs) {
                String featureName = edit.contextFreeToString() + " / " + leftEnv + " _ " + rightEnv;
                feature.incrementCount(featureName, 1.0);
            }
        }
        return feature;
    }

    @Override
    public double regularizationFactor(String feature) {
        return MultiGranEditFeaturesExtractor.regFactor(feature);
    }

    public static double regFactor(String feature) {
        double aCost = 1.0;
        double cvCost = 0.9;
        double ncCost = 0.8;
        double value = 1.0;
        value = feature.matches(".* A _.*") ? (value *= 1.0) : (feature.matches(".* C _.*") || feature.matches(".* V _.*") || feature.matches(".* # _.*") ? (value *= 0.9) : (value *= 0.8));
        value = feature.matches(".*_ A.*") ? (value *= 1.0) : (feature.matches(".*_ C.*") || feature.matches(".*_ V.*") || feature.matches(".*_ #.*") ? (value *= 0.9) : (value *= 0.8));
        return value;
    }
}

