/*
 * Decompiled with CFR 0.152.
 */
package practice;

import fig.basic.LogInfo;
import java.util.ArrayList;
import nuts.util.CollUtils;
import org.apache.commons.math.util.MathUtils;

public class MinEditDistance {
    public static int INSERT = 1;
    public static int DELETE = 1;
    public static int SUBSTITUTE = 2;
    private int[][] table;
    private ArrayList<String> wordlist = CollUtils.list();
    private String groupName;
    private double average;

    public MinEditDistance(String groupName) {
        this.groupName = groupName;
    }

    public void addWord(String word) {
        this.wordlist.add(word);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public double computeAverageDistance() {
        int total = 0;
        if (this.wordlist.size() <= 0) {
            return 0.0;
        }
        for (int i = 0; i < this.wordlist.size(); ++i) {
            for (int j = 0; j < this.wordlist.size(); ++j) {
                if (i == j) continue;
                total += this.getDistance(this.wordlist.get(i), this.wordlist.get(j));
            }
        }
        double size = MathUtils.binomialCoefficientDouble((int)this.wordlist.size(), (int)2);
        this.average = (double)total / size;
        return this.average;
    }

    public double computeDistance(MinEditDistance other) {
        double total = 0.0;
        int N = this.wordlist.size();
        int M = other.wordlist.size();
        for (int i = 0; i < N; ++i) {
            for (int j = 0; j < M; ++j) {
                total += (double)this.getDistance(this.wordlist.get(i), other.wordlist.get(j));
            }
        }
        double average = total / ((double)N * (double)M);
        LogInfo.logs("N=" + N + "; M=" + M + "; avg=" + average);
        return average;
    }

    public int getNumWords() {
        return this.wordlist.size();
    }

    public int getDistance(String x, String y) {
        this.table = new int[x.length() + 1][y.length() + 1];
        for (int r = 0; r <= x.length(); ++r) {
            for (int c = 0; c <= y.length(); ++c) {
                if (r == c && c == 0) continue;
                if (Math.min(r, c) == 0) {
                    this.table[r][c] = Math.max(r, c);
                    continue;
                }
                int sub = x.charAt(r - 1) == y.charAt(c - 1) ? 0 : 2;
                this.table[r][c] = Math.min(Math.min(this.table[r - 1][c] + 1, this.table[r][c - 1] + 1), this.table[r - 1][c - 1] + sub);
            }
        }
        return this.table[x.length()][y.length()];
    }

    public void printCurrentTable() {
        for (int r = 0; r < this.table.length; ++r) {
            StringBuilder sb = new StringBuilder();
            for (int c = 0; c < this.table[r].length; ++c) {
                sb.append("| " + this.table[r][c] + " |");
            }
            LogInfo.logsForce(sb.toString());
        }
    }

    public static void main(String[] args) {
        String x = "kitten";
        String y = "sitting";
        MinEditDistance med = new MinEditDistance("test");
        LogInfo.logsForce("MED=" + med.getDistance(x, y));
        med.printCurrentTable();
    }
}

