/*
 * Decompiled with CFR 0.152.
 */
package binc.lookup;

import binc.BinCallUtils;
import binc.Command;
import binc.GlobalSettings;
import binc.installer.Installer;
import binc.installer.InstallerContext;
import binc.lookup.BinLookupStrategy;
import java.io.File;
import java.util.Random;

public class InstallLookup
implements BinLookupStrategy {
    private static final String separator = "____";
    private static final String successStatusFileName = "auto-install-binary-location.txt";
    public static final BinLookupStrategy instance = new InstallLookup();
    private static final Random rand = new Random();

    private InstallLookup() {
    }

    @Override
    public File lookup(Command binary) {
        for (Installer installer : binary.getInstallers()) {
            File result = InstallLookup.attemptInstall(binary, installer);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static File attemptInstall(Command binary, Installer installer) {
        String installFolderPrefix = binary.getName() + separator + installer.getID();
        for (File directory : GlobalSettings.getInstallDir().listFiles()) {
            if (!directory.getName().startsWith(installFolderPrefix) || InstallLookup.getInstalledFile(directory) == null) continue;
            return InstallLookup.getInstalledFile(directory);
        }
        File installFolder = new File(GlobalSettings.getInstallDir(), installFolderPrefix + separator + System.currentTimeMillis() + separator + rand.nextLong());
        InstallerContext context = new InstallerContext(installFolder);
        File result = installer.install(context);
        if (result == null) {
            return null;
        }
        InstallLookup.createInstalledFilePointer(installFolder, result);
        return result;
    }

    private static void createInstalledFilePointer(File installFolder, File result) {
        File successFile = new File(installFolder, successStatusFileName);
        String installedBinRelativePath = InstallLookup.relativize(installFolder, result);
        BinCallUtils.write(successFile, installedBinRelativePath);
    }

    private static String relativize(File parent, File children) {
        String path = children.getAbsolutePath();
        String base = parent.getAbsolutePath();
        return new File(base).toURI().relativize(new File(path).toURI()).getPath();
    }

    private static File getInstalledFile(File directory) {
        File successFile = new File(directory, successStatusFileName);
        if (!successFile.exists()) {
            return null;
        }
        String contents = BinCallUtils.readFirstLine(successFile);
        return new File(directory, contents);
    }

    public String toString() {
        return "InstallLookup";
    }
}

