/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.tools.PhylogenyDecorator;
import org.forester.util.BasicTableParser;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;

public final class decorator {
    private static final String SEQUENCE_NAME_FIELD = "s";
    private static final String TAXONOMY_CODE_FIELD = "c";
    private static final String TAXONOMY_SCIENTIFIC_NAME_FIELD = "sn";
    private static final String DS_FILED = "d";
    private static final String SEQUENCE_ANNOTATION_DESC = "a";
    private static final String NODE_NAME_FIELD = "n";
    private static final String PICKY_OPTION = "p";
    private static final String FIELD_OPTION = "f";
    private static final String MOVE_DOMAIN_NUMBER_OPTION = "mdn";
    private static final String TREE_NAME_OPTION = "pn";
    private static final String TREE_ID_OPTION = "pi";
    private static final String TREE_DESC_OPTION = "pd";
    private static final String EXTRACT_BRACKETED_SCIENTIC_NAME_OPTION = "sn";
    private static final String PROCESS_NAME_INTELLIGENTLY_OPTION = "x";
    private static final String PROCESS_SIMILAR_TO_OPTION = "xs";
    private static final String CUT_NAME_AFTER_FIRST_SPACE_OPTION = "c";
    private static final String ALLOW_REMOVAL_OF_CHARS_OPTION = "r";
    private static final String ADVANCED_TABLE_OPTION = "table";
    private static final String KEY_COLUMN = "k";
    private static final String VALUE_COLUMN = "v";
    private static final String MAPPING_FILE_SEPARATOR_OPTION = "s";
    private static final String MAPPING_FILE_SEPARATOR_DEFAULT = ":";
    private static final boolean USE_FIRST_SEPARATOR_ONLY = true;
    private static final String PRG_NAME = "decorator";
    private static final String PRG_VERSION = "1.10";
    private static final String PRG_DATE = "2009.10.08";

    private static void argumentsError() {
        System.out.println();
        System.out.println("decorator -table | -f=<c> <phylogenies infile> [mapping table file] <phylogenies outfile>");
        System.out.println();
        System.out.println("options:");
        System.out.println();
        System.out.println(" -table : table instead of one to one map (-f=<c>)");
        System.out.println(" -r=<n> : allow to remove up to n characters from the end of the names");
        System.out.println("          in phylogenies infile if not found (in map) otherwise");
        System.out.println(" -p     : for picky, fails if node name not found in mapping table, default is off");
        System.out.println(" -pn=<s>: name for the phylogeny");
        System.out.println(" -pi=<s>: identifier for the phylogeny (in the form provider:value)");
        System.out.println(" -pd=<s>: description for phylogenies");
        System.out.println();
        System.out.println();
        System.out.println("advanced options, only available if -table is not used:");
        System.out.println();
        System.out.println(" -f=<c> : field to be replaced: n : node name");
        System.out.println("                                a : sequence annotation description");
        System.out.println("                                d : domain structure");
        System.out.println("                                c : taxonomy code");
        System.out.println("                                sn: taxonomy scientific name");
        System.out.println("                                s : sequence name");
        System.out.println(" -k=<n> : key column in mapping table (0 based),");
        System.out.println("          names of the node to be decorated - default is 0");
        System.out.println(" -v=<n> : value column in mapping table (0 based),");
        System.out.println("          data which with to decorate - default is 1");
        System.out.println(" -sn    : to extract bracketed scientific names");
        System.out.println(" -s=<c> : column separator in mapping file, default is \":\"");
        System.out.println(" -x     : process name \"intelligently\" (only for -f=n)");
        System.out.println(" -xs    : process name \"intelligently\" and process information after \"similar to\" (only for -f=n)");
        System.out.println(" -c     : cut name after first space (only for -f=n)");
        System.out.println();
        System.exit(-1);
    }

    public static void main(String[] stringArray) {
        Phylogeny[] phylogenyArray;
        File file;
        block68: {
            String[] stringArray2;
            Object object;
            String string;
            boolean bl;
            ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE);
            if (stringArray.length < 4 || stringArray.length > 12) {
                decorator.argumentsError();
            }
            CommandLineArguments commandLineArguments = null;
            try {
                commandLineArguments = new CommandLineArguments(stringArray);
            }
            catch (Exception exception) {
                ForesterUtil.fatalError(PRG_NAME, exception.getMessage());
            }
            if (commandLineArguments.getNumberOfNames() < 3 || commandLineArguments.getNumberOfNames() > 4) {
                decorator.argumentsError();
            }
            File file2 = commandLineArguments.getFile(0);
            File file3 = commandLineArguments.getFile(1);
            file = commandLineArguments.getFile(2);
            if (file.exists()) {
                ForesterUtil.fatalError(PRG_NAME, "[" + file + "] already exists");
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(ADVANCED_TABLE_OPTION);
            arrayList.add(PICKY_OPTION);
            arrayList.add(FIELD_OPTION);
            arrayList.add(PROCESS_NAME_INTELLIGENTLY_OPTION);
            arrayList.add(PROCESS_SIMILAR_TO_OPTION);
            arrayList.add("c");
            arrayList.add(ALLOW_REMOVAL_OF_CHARS_OPTION);
            arrayList.add(KEY_COLUMN);
            arrayList.add(VALUE_COLUMN);
            arrayList.add("s");
            arrayList.add("sn");
            arrayList.add(TREE_NAME_OPTION);
            arrayList.add(TREE_ID_OPTION);
            arrayList.add(TREE_DESC_OPTION);
            arrayList.add(MOVE_DOMAIN_NUMBER_OPTION);
            String string2 = commandLineArguments.validateAllowedOptionsAsString(arrayList);
            if (string2.length() > 0) {
                ForesterUtil.fatalError(PRG_NAME, "unknown option(s): " + string2);
            }
            if (!(bl = commandLineArguments.isOptionSet(ADVANCED_TABLE_OPTION))) {
                ArrayList<String> arrayList2 = new ArrayList<String>();
                arrayList2.add(FIELD_OPTION);
                string = commandLineArguments.validateMandatoryOptionsAsString(arrayList2);
                if (string.length() > 0) {
                    ForesterUtil.fatalError(PRG_NAME, "missing option(s): " + string);
                }
            }
            boolean bl2 = commandLineArguments.isOptionSet(PICKY_OPTION);
            string = MAPPING_FILE_SEPARATOR_DEFAULT;
            if (commandLineArguments.isOptionSet("s")) {
                if (bl) {
                    decorator.argumentsError();
                }
                string = commandLineArguments.getOptionValue("s");
            }
            int n = 0;
            int n2 = 1;
            String string3 = "";
            PhylogenyDecorator.FIELD fIELD = PhylogenyDecorator.FIELD.NODE_NAME;
            int n3 = -1;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            String string4 = "";
            String string5 = "";
            String string6 = "";
            try {
                if (commandLineArguments.isOptionSet(TREE_NAME_OPTION)) {
                    string4 = commandLineArguments.getOptionValueAsCleanString(TREE_NAME_OPTION);
                }
                if (commandLineArguments.isOptionSet(TREE_ID_OPTION)) {
                    string5 = commandLineArguments.getOptionValueAsCleanString(TREE_ID_OPTION);
                }
                if (commandLineArguments.isOptionSet(TREE_DESC_OPTION)) {
                    string6 = commandLineArguments.getOptionValueAsCleanString(TREE_DESC_OPTION);
                }
                if (commandLineArguments.isOptionSet("sn")) {
                    if (bl) {
                        decorator.argumentsError();
                    }
                    bl6 = true;
                }
                if (commandLineArguments.isOptionSet(KEY_COLUMN)) {
                    if (bl) {
                        decorator.argumentsError();
                    }
                    n = commandLineArguments.getOptionValueAsInt(KEY_COLUMN);
                }
                if (commandLineArguments.isOptionSet(VALUE_COLUMN)) {
                    if (bl) {
                        decorator.argumentsError();
                    }
                    n2 = commandLineArguments.getOptionValueAsInt(VALUE_COLUMN);
                }
                if (commandLineArguments.isOptionSet("c")) {
                    if (bl) {
                        decorator.argumentsError();
                    }
                    bl3 = true;
                }
                if (commandLineArguments.isOptionSet(PROCESS_NAME_INTELLIGENTLY_OPTION)) {
                    if (bl) {
                        decorator.argumentsError();
                    }
                    bl4 = true;
                }
                if (commandLineArguments.isOptionSet(PROCESS_SIMILAR_TO_OPTION)) {
                    if (bl) {
                        decorator.argumentsError();
                    }
                    bl5 = true;
                }
                if (commandLineArguments.isOptionSet(ALLOW_REMOVAL_OF_CHARS_OPTION)) {
                    n3 = commandLineArguments.getOptionValueAsInt(ALLOW_REMOVAL_OF_CHARS_OPTION);
                }
                if (commandLineArguments.isOptionSet(MOVE_DOMAIN_NUMBER_OPTION)) {
                    bl7 = true;
                }
                if (commandLineArguments.isOptionSet(FIELD_OPTION)) {
                    string3 = commandLineArguments.getOptionValue(FIELD_OPTION);
                    if (string3.equals(NODE_NAME_FIELD)) {
                        fIELD = PhylogenyDecorator.FIELD.NODE_NAME;
                    } else if (string3.equals(SEQUENCE_ANNOTATION_DESC)) {
                        fIELD = PhylogenyDecorator.FIELD.SEQUENCE_ANNOTATION_DESC;
                    } else if (string3.equals(DS_FILED)) {
                        fIELD = PhylogenyDecorator.FIELD.DOMAIN_STRUCTURE;
                        bl6 = false;
                    } else if (string3.equals("c")) {
                        fIELD = PhylogenyDecorator.FIELD.TAXONOMY_CODE;
                    } else if (string3.equals("s")) {
                        fIELD = PhylogenyDecorator.FIELD.SEQUENCE_NAME;
                    } else if (string3.equals("sn")) {
                        fIELD = PhylogenyDecorator.FIELD.TAXONOMY_SCIENTIFIC_NAME;
                        bl6 = false;
                    } else {
                        ForesterUtil.fatalError(PRG_NAME, "unknown value for \"f\" option: \"" + string3 + "\"");
                    }
                }
            }
            catch (Exception exception) {
                ForesterUtil.fatalError(PRG_NAME, "error in command line: " + exception.getMessage());
            }
            if (fIELD != PhylogenyDecorator.FIELD.NODE_NAME && (bl3 || bl4)) {
                ForesterUtil.fatalError(PRG_NAME, "attempt to use -x or -c option without -f=n");
            }
            if (fIELD != PhylogenyDecorator.FIELD.NODE_NAME && bl5) {
                ForesterUtil.fatalError(PRG_NAME, "attempt to use -xs option without -f=n");
            }
            if (bl3 && bl4) {
                ForesterUtil.fatalError(PRG_NAME, "attempt to use -x and -c option together");
            }
            if (bl5 && bl4) {
                ForesterUtil.fatalError(PRG_NAME, "attempt to use -xs and -x option together");
            }
            if (bl5 && bl3) {
                ForesterUtil.fatalError(PRG_NAME, "attempt to use -xs and -c option together");
            }
            phylogenyArray = null;
            try {
                object = ParserBasedPhylogenyFactory.getInstance();
                stringArray2 = ParserUtils.createParserDependingOnFileType(file2, true);
                phylogenyArray = object.create(file2, stringArray2);
            }
            catch (Exception exception) {
                ForesterUtil.fatalError(PRG_NAME, "failed to read phylgenies from [" + file2 + "] [" + exception.getMessage() + "]");
            }
            object = null;
            if (!bl) {
                stringArray2 = null;
                try {
                    stringArray2 = BasicTableParser.parse(file3, string, true);
                }
                catch (Exception exception) {
                    ForesterUtil.fatalError(PRG_NAME, "failed to read [" + file3 + "] [" + exception.getMessage() + "]");
                }
                if (n < 0 || n >= stringArray2.getNumberOfColumns()) {
                    ForesterUtil.fatalError(PRG_NAME, "illegal value for key column");
                }
                if (n2 < 0 || n2 >= stringArray2.getNumberOfColumns()) {
                    ForesterUtil.fatalError(PRG_NAME, "illegal value for value column");
                }
                object = stringArray2.getColumnsAsMap(n, n2);
            }
            if (!(ForesterUtil.isEmpty(string4) && ForesterUtil.isEmpty(string5) && ForesterUtil.isEmpty(string6))) {
                if (!(phylogenyArray.length <= 1 || ForesterUtil.isEmpty(string4) && ForesterUtil.isEmpty(string5))) {
                    ForesterUtil.fatalError(PRG_NAME, "attempt to set same name or id on more than one phylogeny");
                }
                if (!ForesterUtil.isEmpty(string4)) {
                    phylogenyArray[0].setName(string4);
                }
                if (!ForesterUtil.isEmpty(string5)) {
                    stringArray2 = string5.split(MAPPING_FILE_SEPARATOR_DEFAULT);
                    phylogenyArray[0].setIdentifier(new Identifier(stringArray2[1], stringArray2[0]));
                }
                if (!ForesterUtil.isEmpty(string6)) {
                    for (int i = 0; i < phylogenyArray.length; ++i) {
                        phylogenyArray[i].setDescription(string6);
                    }
                }
            }
            try {
                if (bl) {
                    Map<String, Map<String, String>> map = null;
                    try {
                        map = PhylogenyDecorator.parseMappingTable(file3);
                    }
                    catch (IOException iOException) {
                        ForesterUtil.fatalError(PRG_NAME, "failed to read \"" + file3 + "\" [" + iOException.getMessage() + "]");
                    }
                    PhylogenyDecorator.decorate(phylogenyArray, map, bl2, n3);
                    break block68;
                }
                PhylogenyDecorator.decorate(phylogenyArray, (Map<String, String>)object, fIELD, bl6, bl2, bl3, bl4, bl5, n3, bl7);
            }
            catch (NullPointerException nullPointerException) {
                ForesterUtil.unexpectedFatalError(PRG_NAME, nullPointerException);
            }
            catch (Exception exception) {
                ForesterUtil.fatalError(PRG_NAME, "failed to map [" + exception + "]");
            }
        }
        try {
            PhylogenyWriter phylogenyWriter = new PhylogenyWriter();
            phylogenyWriter.toPhyloXML(phylogenyArray, 0, file, ForesterUtil.getLineSeparator());
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, "failed to write output [" + iOException.getMessage() + "]");
        }
        System.out.println();
        ForesterUtil.programMessage(PRG_NAME, "wrote: " + file);
        ForesterUtil.programMessage(PRG_NAME, "OK.");
    }
}

