/*
 * Decompiled with CFR 0.152.
 */
package JSci.beans;

import JSci.beans.VariableEvent;
import JSci.beans.VariableListener;
import JSci.io.MathMLExpression;
import JSci.io.MathMLParser;
import JSci.maths.Complex;
import JSci.maths.MathDouble;
import JSci.maths.MathInteger;
import JSci.maths.matrices.AbstractComplexMatrix;
import JSci.maths.matrices.AbstractDoubleMatrix;
import JSci.maths.matrices.AbstractIntegerMatrix;
import JSci.maths.vectors.AbstractComplexVector;
import JSci.maths.vectors.AbstractDoubleVector;
import JSci.maths.vectors.AbstractIntegerVector;
import JSci.util.MatrixToolkit;
import JSci.util.VectorToolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public final class MathBean
implements Serializable,
VariableListener,
ActionListener {
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);
    private MathMLExpression expr;
    private String mathml = "";
    private Hashtable variables = new Hashtable();
    private Object result = new MathDouble(Double.NaN);

    public synchronized void setMathML(String string) {
        Object object;
        try {
            object = new MathMLParser();
            object.parse(string);
            this.expr = (MathMLExpression)((MathMLParser)((Object)object)).translateToJSciObjects()[0];
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = this.mathml;
        this.mathml = string;
        this.changes.firePropertyChange("mathml", object, string);
    }

    public synchronized String getMathML() {
        return this.mathml;
    }

    public synchronized double getResultAs0DArray() {
        if (this.result instanceof MathDouble) {
            return ((MathDouble)this.result).value();
        }
        if (this.result instanceof MathInteger) {
            return ((MathInteger)this.result).value();
        }
        return Double.NaN;
    }

    public synchronized double[] getResultAs1DArray() {
        if (this.result instanceof Complex) {
            double[] dArray = new double[]{((Complex)this.result).real(), ((Complex)this.result).imag()};
            return dArray;
        }
        if (this.result instanceof AbstractDoubleVector) {
            return VectorToolkit.toArray((AbstractDoubleVector)this.result);
        }
        if (this.result instanceof AbstractIntegerVector) {
            return VectorToolkit.toArray(((AbstractIntegerVector)this.result).toDoubleVector());
        }
        return null;
    }

    public synchronized double[][] getResultAs2DArray() {
        if (this.result instanceof AbstractComplexVector) {
            double[][] dArrayArray = new double[][]{VectorToolkit.toArray(((AbstractComplexVector)this.result).real()), VectorToolkit.toArray(((AbstractComplexVector)this.result).imag())};
            return dArrayArray;
        }
        if (this.result instanceof AbstractDoubleMatrix) {
            return MatrixToolkit.toArray((AbstractDoubleMatrix)this.result);
        }
        if (this.result instanceof AbstractIntegerMatrix) {
            return MatrixToolkit.toArray(((AbstractIntegerMatrix)this.result).toDoubleMatrix());
        }
        return null;
    }

    public synchronized double[][][] getResultAs3DArray() {
        if (this.result instanceof AbstractComplexMatrix) {
            double[][][] dArrayArray = new double[][][]{MatrixToolkit.toArray(((AbstractComplexMatrix)this.result).real()), MatrixToolkit.toArray(((AbstractComplexMatrix)this.result).imag())};
            return dArrayArray;
        }
        return null;
    }

    public void variableChanged(VariableEvent variableEvent) {
        this.variables.put(variableEvent.getVariable(), variableEvent.getValue());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        MathMLExpression mathMLExpression = this.expr;
        Enumeration enumeration = this.variables.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            mathMLExpression = mathMLExpression.substitute(k.toString(), this.variables.get(k));
        }
        this.result = mathMLExpression.evaluate();
        this.changes.firePropertyChange("resultAs0DArray", null, new Double(this.getResultAs0DArray()));
        this.changes.firePropertyChange("resultAs1DArray", null, this.getResultAs1DArray());
        this.changes.firePropertyChange("resultAs2DArray", null, this.getResultAs2DArray());
        this.changes.firePropertyChange("resultAs3DArray", null, this.getResultAs3DArray());
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }
}

