/*
 * Decompiled with CFR 0.152.
 */
package JSci.physics;

import JSci.maths.vectors.AbstractDoubleVector;
import JSci.maths.vectors.Double2Vector;
import JSci.physics.AbstractClassicalParticle;

public class ClassicalParticle2D
extends AbstractClassicalParticle {
    protected double mass;
    protected double x;
    protected double y;
    protected double vx;
    protected double vy;

    public void setMass(double d) {
        this.mass = d;
    }

    public double getMass() {
        return this.mass;
    }

    public void setPosition(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public AbstractDoubleVector getPosition() {
        return new Double2Vector(this.x, this.y);
    }

    public void setXPosition(double d) {
        this.x = d;
    }

    public double getXPosition() {
        return this.x;
    }

    public void setYPosition(double d) {
        this.y = d;
    }

    public double getYPosition() {
        return this.y;
    }

    public void setVelocity(double d, double d2) {
        this.vx = d;
        this.vy = d2;
    }

    public AbstractDoubleVector getVelocity() {
        return new Double2Vector(this.vx, this.vy);
    }

    public double getXVelocity() {
        return this.vx;
    }

    public double getYVelocity() {
        return this.vy;
    }

    public double speed() {
        return Math.sqrt(this.vx * this.vx + this.vy * this.vy);
    }

    public void setMomentum(double d, double d2) {
        this.vx = d / this.mass;
        this.vy = d2 / this.mass;
    }

    public AbstractDoubleVector getMomentum() {
        return new Double2Vector(this.mass * this.vx, this.mass * this.vy);
    }

    public double getXMomentum() {
        return this.mass * this.vx;
    }

    public double getYMomentum() {
        return this.mass * this.vy;
    }

    public double energy() {
        return this.mass * (this.vx * this.vx + this.vy * this.vy) / 2.0;
    }

    public ClassicalParticle2D move(double d) {
        return this.translate(d);
    }

    public ClassicalParticle2D translate(double d) {
        this.x += this.vx * d;
        this.y += this.vy * d;
        return this;
    }

    public ClassicalParticle2D accelerate(double d, double d2, double d3) {
        this.vx += d * d3;
        this.vy += d2 * d3;
        return this;
    }

    public ClassicalParticle2D applyForce(double d, double d2, double d3) {
        return this.accelerate(d / this.mass, d2 / this.mass, d3);
    }

    public ClassicalParticle2D gravitate(ClassicalParticle2D classicalParticle2D, double d) {
        double d2 = classicalParticle2D.x - this.x;
        double d3 = classicalParticle2D.y - this.y;
        double d4 = d2 * d2 + d3 * d3;
        double d5 = Math.sqrt(d4);
        double d6 = classicalParticle2D.mass / d4;
        double d7 = this.mass / d4;
        this.vx -= d6 * d2 * d / d5;
        this.vy -= d6 * d3 * d / d5;
        classicalParticle2D.vx += d7 * d2 * d / d5;
        classicalParticle2D.vy += d7 * d3 * d / d5;
        return this;
    }

    public ClassicalParticle2D collide(ClassicalParticle2D classicalParticle2D, double d) {
        double d2 = this.mass + classicalParticle2D.mass;
        double d3 = classicalParticle2D.vx - this.vx;
        double d4 = classicalParticle2D.vy - this.vy;
        double d5 = Math.cos(d);
        double d6 = Math.sin(d);
        this.vx += classicalParticle2D.mass * (d3 * d5 + d4 * d6 + d3) / d2;
        this.vy += classicalParticle2D.mass * (d4 * d5 - d3 * d6 + d4) / d2;
        classicalParticle2D.vx -= this.mass * (d3 * d5 + d4 * d6 + d3) / d2;
        classicalParticle2D.vy -= this.mass * (d4 * d5 - d3 * d6 + d4) / d2;
        return this;
    }
}

