/*
 * Decompiled with CFR 0.152.
 */
package conifer.proposals;

import conifer.evol.PIPLikelihoodModel;
import conifer.msa.TreeMSAState;
import fig.basic.Pair;
import java.util.Random;
import ma.RateMatrixLoader;
import monaco.prop.Proposal;
import nuts.math.Sampling;

public class K2PProposal
implements Proposal<TreeMSAState> {
    public final double transTransPriorMeanParam = 2.0;

    @Override
    public Pair<TreeMSAState, Double> propose_logRatio(Random rand, TreeMSAState current, boolean avoidExtensiveCaching) {
        PIPLikelihoodModel oldModel = (PIPLikelihoodModel)current.params;
        double newT2TRatio = Sampling.sampleExponential(rand, 2.0);
        double[][] newRateMtx = RateMatrixLoader.k2p(newT2TRatio);
        PIPLikelihoodModel newModel = oldModel.copyWithNewRateMtx(newRateMtx);
        current.inPlaceParamChange(newModel);
        return Pair.makePair(current, 0.0);
    }

    @Override
    public String name() {
        return "K2PProposal";
    }
}

