/*
 * Decompiled with CFR 0.152.
 */
package conifer.rna;

import conifer.rna.RNAmexp;
import conifer.ssm.BirthDeathExperiment;
import conifer.ssm.ImportanceSampler;
import conifer.ssm.SimplePotentialExperiments;
import fig.basic.LogInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import nuts.util.Counter;

public class RNAMove {
    static boolean useRNAeval;
    static String path;
    static boolean readSubset;
    char[] sequence;
    char[] target;
    char[] structure;
    double energy = 3.2;
    double distance = 0.0;
    double temp = 37.0;
    double rhoT = 0.001987 * (this.temp + 273.15);
    List<Neighbor> neighbors = new ArrayList<Neighbor>();
    int[] usedIndexes;
    static List<Neighbor> subsetStrs;
    static int[][] subsetPairs;

    RNAMove(char[] sequence, char[] target) {
        this.sequence = sequence;
        this.target = target;
    }

    public void removeOneBp(char[] sequence, char[] structure) {
        ArrayList<QueueItem> queue = new ArrayList<QueueItem>();
        for (int c = 0; c < structure.length; ++c) {
            if (structure[c] == '(') {
                QueueItem i = new QueueItem('(', c);
                queue.add(i);
                continue;
            }
            if (structure[c] != ')') continue;
            int last = queue.size() - 1;
            QueueItem i = (QueueItem)queue.get(last);
            queue.remove(last);
            char[] s = new char[structure.length];
            for (int d = 0; d < structure.length; ++d) {
                s[d] = structure[d];
            }
            s[i.position] = 46;
            s[c] = 46;
            Neighbor obpn = new Neighbor(sequence, s);
            obpn.rate = Math.exp(1.0 / (2.0 * this.rhoT));
            this.neighbors.add(obpn);
        }
    }

    public void makeOneBp(char[] sequence, char[] structure, int b, int c) {
        int indexCount = 0;
        for (int a = b + 1; a < c; ++a) {
            if (this.usedIndexes[a] != 0) continue;
            ++indexCount;
        }
        int[] indexes = new int[indexCount];
        int x = 0;
        for (int a = b + 1; a < c; ++a) {
            if (this.usedIndexes[a] != 0) continue;
            this.usedIndexes[a] = 1;
            indexes[x] = a;
            ++x;
        }
        if (0 <= b && c <= structure.length) {
            this.usedIndexes[b] = 1;
            this.usedIndexes[c] = 1;
        }
        for (x = 0; x < indexes.length; ++x) {
            for (int y = x + 1; y < indexes.length; ++y) {
                boolean isLegal = false;
                if (sequence[indexes[x]] == 'A') {
                    if (sequence[indexes[y]] == 'U') {
                        isLegal = true;
                    }
                } else if (sequence[indexes[x]] == 'C') {
                    if (sequence[indexes[y]] == 'G') {
                        isLegal = true;
                    }
                } else if (sequence[indexes[x]] == 'G') {
                    if (sequence[indexes[y]] == 'C') {
                        isLegal = true;
                    }
                    if (sequence[indexes[y]] == 'U') {
                        isLegal = true;
                    }
                } else if (sequence[indexes[x]] == 'U') {
                    if (sequence[indexes[y]] == 'A') {
                        isLegal = true;
                    }
                    if (sequence[indexes[y]] == 'G') {
                        isLegal = true;
                    }
                }
                if (!isLegal) continue;
                char[] s = new char[structure.length];
                for (int d = 0; d < structure.length; ++d) {
                    s[d] = structure[d];
                }
                s[indexes[x]] = 40;
                s[indexes[y]] = 41;
                Neighbor obpn = new Neighbor(sequence, s);
                obpn.rate = Math.exp(-1.0 / (2.0 * this.rhoT));
                this.neighbors.add(obpn);
            }
        }
    }

    public void addOneBp(char[] sequence, char[] structure) {
        this.usedIndexes = new int[structure.length];
        ArrayList<QueueItem> queue = new ArrayList<QueueItem>();
        for (int c = 0; c < structure.length; ++c) {
            if (structure[c] == '(') {
                QueueItem i = new QueueItem('(', c);
                queue.add(i);
                continue;
            }
            if (structure[c] != ')') continue;
            int last = queue.size() - 1;
            QueueItem i = (QueueItem)queue.get(last);
            queue.remove(last);
            this.makeOneBp(sequence, structure, i.position, c);
        }
        this.makeOneBp(sequence, structure, -1, structure.length);
    }

    public void enumerateNeighbors(char[] sequence) {
        if (readSubset) {
            int index = subsetStrs.indexOf(new Neighbor(sequence, this.structure));
            for (int i = 0; i < subsetPairs.length; ++i) {
                double rate;
                if (subsetPairs[index][i] != 1) continue;
                Neighbor n = subsetStrs.get(i);
                n.rate = rate = Math.exp((RNAMove.subsetStrs.get((int)index).energy - n.energy) / (2.0 * this.rhoT));
                this.neighbors.add(n);
            }
        } else {
            this.removeOneBp(sequence, this.structure);
            this.addOneBp(sequence, this.structure);
        }
    }

    public double parseEnergy(String strLine) {
        String strEnergy = "";
        for (int c = this.sequence.length; c < strLine.length(); ++c) {
            char ch = strLine.charAt(c);
            if (ch == '(' || ch == ')') continue;
            strEnergy = strEnergy + ch;
        }
        double energy = Double.parseDouble(strEnergy.trim());
        return energy;
    }

    public void getEnergies() {
        Runtime r = Runtime.getRuntime();
        try {
            int c;
            Process p = r.exec(path + "RNAeval -T " + this.temp);
            OutputStream outHere = p.getOutputStream();
            for (c = 0; c < this.sequence.length; ++c) {
                outHere.write(this.sequence[c]);
            }
            outHere.write(10);
            for (c = 0; c < this.structure.length; ++c) {
                outHere.write(this.structure[c]);
            }
            outHere.write(10);
            for (int i = 0; i < this.neighbors.size(); ++i) {
                Neighbor n = this.neighbors.get(i);
                for (int c2 = 0; c2 < this.sequence.length; ++c2) {
                    outHere.write(this.sequence[c2]);
                }
                outHere.write(10);
                String line = n.toString() + "\n";
                outHere.write(line.getBytes());
            }
            outHere.write(64);
            outHere.write(10);
            outHere.close();
            BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String strLine = in.readLine();
            if (strLine != null && (strLine = in.readLine()) != null) {
                this.energy = this.parseEnergy(strLine);
            }
            for (int i = 0; i < this.neighbors.size(); ++i) {
                double rate;
                Neighbor n = this.neighbors.get(i);
                strLine = in.readLine();
                if (strLine == null || (strLine = in.readLine()) == null) continue;
                n.energy = this.parseEnergy(strLine);
                n.rate = rate = Math.exp((this.energy - n.energy) / (2.0 * this.rhoT));
            }
            in.close();
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
        }
    }

    public int editDistance(char[] nstruct) {
        return RNAMove.editDistance(nstruct, this.target);
    }

    public static int editDistance(char[] nstruct, char[] target) {
        int distance = 0;
        ArrayList<QueueItem> targetQueue = new ArrayList<QueueItem>();
        ArrayList<QueueItem> neighborQueue = new ArrayList<QueueItem>();
        for (int c = 0; c < target.length; ++c) {
            QueueItem i;
            QueueItem i2;
            int tb = -1;
            int tc = -1;
            int nb = -1;
            int nc = -1;
            if (target[c] == '(') {
                i2 = new QueueItem('(', c);
                targetQueue.add(i2);
            } else if (target[c] == ')') {
                int last = targetQueue.size() - 1;
                i = (QueueItem)targetQueue.get(last);
                targetQueue.remove(last);
                tb = i.position;
                tc = c;
            }
            if (nstruct[c] == '(') {
                i2 = new QueueItem('(', c);
                neighborQueue.add(i2);
            } else if (nstruct[c] == ')') {
                int last = neighborQueue.size() - 1;
                i = (QueueItem)neighborQueue.get(last);
                neighborQueue.remove(last);
                nb = i.position;
                nc = c;
            }
            if (tb != -1 && tc != -1 && nb != -1 && nc != -1) {
                if (tb == nb && tc == nc) continue;
                distance += 2;
                continue;
            }
            if (tb != -1 && tc != -1) {
                ++distance;
                continue;
            }
            if (nb == -1 || nc == -1) continue;
            ++distance;
        }
        return distance;
    }

    public void getEditDistance() {
        this.distance = this.editDistance(this.structure);
        System.out.println("current dist: " + this.distance);
        for (int ni = 0; ni < this.neighbors.size(); ++ni) {
            Neighbor n = this.neighbors.get(ni);
            n.distance = this.editDistance(n.neighbor);
            n.doesIncrease = this.distance < (double)n.distance;
        }
    }

    public void makeMove(char[] sequence, char[] structure) {
        this.neighbors.clear();
        this.enumerateNeighbors(sequence);
        this.getEnergies();
        this.getEditDistance();
    }

    public static void makeStateSpace(char[] seq, String file_name) {
        Runtime r = Runtime.getRuntime();
        try {
            int line_number;
            Process p = r.exec("wc -l " + file_name);
            BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String strLine = in.readLine().trim();
            String[] parts = new String[]{};
            if (strLine != null) {
                parts = strLine.split("\\s");
            }
            int subset_size = Integer.parseInt(parts[0]) / 2;
            subsetStrs = new ArrayList<Neighbor>();
            Scanner input = new Scanner(new File(file_name));
            for (line_number = 0; line_number < subset_size; ++line_number) {
                String[] str_eg = input.nextLine().split("\\s+");
                Neighbor str = new Neighbor(seq, str_eg[0].toCharArray());
                str.energy = Double.parseDouble(str_eg[1]);
                subsetStrs.add(str);
            }
            subsetPairs = new int[subset_size][subset_size];
            while (input.hasNext()) {
                String[] pairs = input.nextLine().trim().split("\\s+");
                for (int i = 0; i < pairs.length; ++i) {
                    RNAMove.subsetPairs[line_number - subset_size][i] = Integer.parseInt(pairs[i]);
                }
                ++line_number;
            }
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
        }
    }

    public static void testcase(String[] args) {
        char[] s = new char[]{'C', 'C', 'C', 'A', 'A', 'A', 'G', 'G', 'G'};
        char[] t = new char[]{'(', '(', '(', '.', '.', '.', ')', ')', ')'};
        RNAMove m = new RNAMove(s, t);
        Neighbor k = new Neighbor(s, m.structure);
        System.out.println("Structure: " + k);
        System.out.println();
        System.out.println("1BP Neighbors:");
        m.enumerateNeighbors(s);
        m.getEnergies();
        m.getEditDistance();
        for (int c = 0; c < m.neighbors.size(); ++c) {
        }
    }

    public static void main(String[] args) {
        useRNAeval = false;
        path = "";
        double time = 10.0;
        char[] s = new char[]{'C', 'C', 'C', 'A', 'A', 'A', 'G', 'G', 'G'};
        char[] t = new char[]{'(', '(', '(', '.', '.', '.', ')', ')', ')'};
        char[] x = new char[]{'.', '.', '(', '.', '.', '.', '.', ')', '.'};
        boolean ctmc_sampling = false;
        String RNA_name = "";
        String subsetFile = "";
        int replicate = 20;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-r")) {
                useRNAeval = true;
            }
            if (args[i].equals("-p")) {
                path = args[i + 1];
            }
            if (args[i].equals("-seq")) {
                s = args[i + 1].toCharArray();
            }
            if (args[i].equals("-start")) {
                x = args[i + 1].toCharArray();
            }
            if (args[i].equals("-target")) {
                t = args[i + 1].toCharArray();
            }
            if (args[i].equals("-time")) {
                time = Double.parseDouble(args[i + 1]);
            }
            if (args[i].equals("-ctmc")) {
                ctmc_sampling = true;
            }
            if (args[i].equals("-name")) {
                RNA_name = args[i + 1];
            }
            if (args[i].equals("-rep")) {
                replicate = Integer.parseInt(args[i + 1]);
            }
            if (!args[i].equals("-rs")) continue;
            readSubset = true;
            subsetFile = args[i + 1];
        }
        if (readSubset) {
            RNAMove.makeStateSpace(s, subsetFile);
        }
        RNAProcess sp = new RNAProcess();
        RNAPot potential = new RNAPot();
        SimplePotentialExperiments.PotPropOptions opt = new SimplePotentialExperiments.PotPropOptions();
        opt.stopPr = Math.max(0.25, 1.0 - time / 16.0);
        opt.greed = 0.6666666666666666;
        opt.automatic = false;
        SimplePotentialExperiments.PotProposal<Neighbor> pp = new SimplePotentialExperiments.PotProposal<Neighbor>(sp, potential, opt);
        Neighbor nx = new Neighbor(s, x);
        Neighbor nt = new Neighbor(s, t);
        System.out.println("nx:" + nx + " nt: " + nt);
        StringBuffer output = new StringBuffer();
        StringBuffer output_time = new StringBuffer();
        StringBuffer output_rep = new StringBuffer();
        StringBuffer output_var = new StringBuffer();
        RNAmexp m = null;
        if (readSubset) {
            System.out.println("subsetFile: " + subsetFile);
            m = new RNAmexp(useRNAeval, readSubset, subsetFile);
        } else {
            m = new RNAmexp(useRNAeval);
        }
        m.makeMatrix(nx, time);
        double mexp_value = m.expm().get(m.map.get(nx).intValue(), m.map.get(nt).intValue());
        System.out.println("nx_index: " + m.map.get(nx) + " nt_index: " + m.map.get(nt) + " Matrix exponential value:" + mexp_value);
        output.append(mexp_value + "\n");
        int count = 0;
        int[] repeat = new int[]{5, 25, 125, 625, 3125, 15625};
        if (ctmc_sampling) {
            for (int nPart : repeat) {
                ++count;
                LogInfo.track("\nnPart = " + nPart + "\n");
                double mean_ctmc = 0.0;
                long a = System.nanoTime();
                for (int rep_ctmc = 0; rep_ctmc < replicate; ++rep_ctmc) {
                    LogInfo.track((Object)("replicate " + rep_ctmc), true);
                    CTMC_sampling fs = new CTMC_sampling();
                    fs.samples = nPart;
                    double norm_ctmc = fs.getSamples(s, x, t, time);
                    output_rep.append(norm_ctmc / (double)nPart);
                    if (rep_ctmc < replicate - 1) {
                        output_rep.append(", ");
                    }
                    mean_ctmc += norm_ctmc / (double)nPart;
                    LogInfo.end_track();
                }
                output_rep.append("\n");
                long b = System.nanoTime();
                double z_ctmc = mean_ctmc / (double)replicate;
                LogInfo.logsForce("Z_ctmc_ave = " + z_ctmc);
                double var_fs = z_ctmc * (1.0 - z_ctmc);
                if (count != repeat.length) {
                    output.append(z_ctmc + ", ");
                    output_var.append(var_fs + ", ");
                    output_time.append(TimeUnit.MILLISECONDS.convert(b - a, TimeUnit.NANOSECONDS) / (long)replicate + ",  ");
                } else {
                    output.append(z_ctmc);
                    output_var.append(var_fs);
                    output_time.append(TimeUnit.MILLISECONDS.convert(b - a, TimeUnit.NANOSECONDS) / (long)replicate);
                }
                LogInfo.end_track();
            }
            output.append("\n");
            output_time.append("\n");
            output_var.append("\n");
        }
        count = 0;
        for (int nPart : repeat) {
            ++count;
            LogInfo.track("nPart = " + nPart);
            ImportanceSampler<Neighbor> is = new ImportanceSampler<Neighbor>(pp, sp);
            is.nParticles = nPart;
            double mean = 0.0;
            double var_is = 0.0;
            long a = System.nanoTime();
            for (int rep = 0; rep < replicate; ++rep) {
                LogInfo.track((Object)("replicate " + rep), true);
                Counter<List<Neighbor>> samples = is.sample(nx, nt, time);
                double norm = samples.totalCount();
                double expected_norm = norm / (double)nPart;
                double variance = 0.0;
                for (List<Neighbor> sample : samples) {
                    variance += Math.pow(samples.getCount(sample) - expected_norm, 2.0);
                }
                var_is += (variance /= (double)nPart);
                output_rep.append(expected_norm);
                if (rep < replicate - 1) {
                    output_rep.append(", ");
                }
                mean += norm / (double)nPart;
                LogInfo.end_track();
            }
            output_rep.append("\n");
            long b = System.nanoTime();
            double z_ave = mean / (double)replicate;
            var_is /= (double)replicate;
            LogInfo.logsForce("Z_ave = " + z_ave);
            if (count != repeat.length) {
                output.append(z_ave + ", ");
                output_var.append(var_is + ", ");
                output_time.append(TimeUnit.MILLISECONDS.convert(b - a, TimeUnit.NANOSECONDS) / (long)replicate + ", ");
            } else {
                output.append(z_ave);
                output_var.append(var_is);
                output_time.append(TimeUnit.MILLISECONDS.convert(b - a, TimeUnit.NANOSECONDS) / (long)replicate);
            }
            LogInfo.end_track();
        }
        output.append("\n");
        output_time.append("\n");
        output_var.append("\n");
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter("output_" + RNA_name + "_len" + s.length + "_rep" + replicate + "_t" + time + ".txt"));
            String outText = output.toString();
            out.write(outText);
            out.write(output_time.toString());
            out.write(output_var.toString());
            out.write(output_rep.toString());
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        path = "";
    }

    public static class CTMC_sampling {
        public int samples = 10;

        public double getSamples(char[] seq, char[] start, char[] target, double time) {
            double t = 0.0;
            Random rand = new Random(1L);
            double sum_probs = 0.0;
            double reach_tg = 0.0;
            Neighbor current = new Neighbor(seq, start);
            Neighbor tg = new Neighbor(seq, target);
            RNAProcess rp = new RNAProcess();
            for (int counter = 0; counter < this.samples; ++counter) {
                t = 0.0;
                current = new Neighbor(seq, start);
                tg = new Neighbor(seq, target);
                block1: while (t < time) {
                    Counter<Neighbor> c = rp.rates(current);
                    double total_rate = c.totalCount();
                    sum_probs = 0.0;
                    double r = rand.nextDouble();
                    for (Neighbor nb : c) {
                        if (!(r <= (sum_probs += c.getCount(nb) / total_rate))) continue;
                        t += Math.log(1.0 / rand.nextDouble()) / total_rate;
                        if (current.equals(tg)) {
                            if (t >= time) {
                                reach_tg += 1.0;
                            }
                        } else if (t >= time) {
                            // empty if block
                        }
                        current = new Neighbor(seq, nb.neighbor);
                        continue block1;
                    }
                }
            }
            return reach_tg;
        }
    }

    public static class RNAPot
    implements SimplePotentialExperiments.Potential<Neighbor> {
        @Override
        public double get(Neighbor proposed, Neighbor target) {
            return RNAMove.editDistance(proposed.neighbor, target.neighbor);
        }
    }

    public static class RNAProcess
    implements SimplePotentialExperiments.SparseProcess<Neighbor>,
    BirthDeathExperiment.Process<Neighbor> {
        @Override
        public Counter<Neighbor> rates(Neighbor point) {
            RNAMove m = new RNAMove(point.sequence, null);
            m.structure = point.neighbor;
            m.enumerateNeighbors(point.sequence);
            if (useRNAeval) {
                m.getEnergies();
            }
            Counter<Neighbor> c = new Counter<Neighbor>();
            for (Neighbor n : m.neighbors) {
                double ex = n.rate;
                c.setCount(n, ex);
            }
            return c;
        }

        @Override
        public double holdRate(Neighbor x) {
            Counter<Neighbor> c = this.rates(x);
            double z = c.totalCount();
            return z;
        }

        @Override
        public double transitionProbability(Neighbor x, Neighbor y) {
            Counter<Neighbor> c = this.rates(x);
            double z = c.totalCount();
            return c.getCount(y) / z;
        }

        @Override
        public Neighbor sample(Random rand, Neighbor x) {
            throw new RuntimeException();
        }
    }

    public static class QueueItem {
        char element;
        int position;

        QueueItem(char e, int p) {
            this.element = e;
            this.position = p;
        }
    }

    public static class Neighbor {
        char[] sequence;
        char[] neighbor;
        double energy;
        double rate;
        int distance;
        boolean doesIncrease;

        Neighbor(char[] seq, char[] n) {
            this.sequence = seq;
            this.neighbor = n;
        }

        public int size() {
            return this.neighbor.length;
        }

        public String toString() {
            String s = new String();
            for (int c = 0; c < this.neighbor.length; ++c) {
                s = s + this.neighbor[c];
            }
            return s;
        }

        public boolean equals(Object obj) {
            if (obj == "___TARGET___") {
                return false;
            }
            return Arrays.equals(((Neighbor)obj).neighbor, this.neighbor);
        }

        public int hashCode() {
            return Arrays.hashCode(this.neighbor);
        }
    }
}

