/*
 * Decompiled with CFR 0.152.
 */
package ev.multi;

import ev.hmm.HetPairHMM;
import ev.par.ExponentialFamily;
import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.Parallelizer;
import fig.basic.UnorderedPair;
import goblin.Taxon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import ma.GreedyDecoder;
import ma.MSAPoset;
import nuts.util.CollUtils;
import nuts.util.Counter;
import nuts.util.MathUtils;

public class ManyPairsAligner {
    public static MSAPoset maxRecallAlignFromMostPairs(Map<Taxon, String> sequences, ExponentialFamily expFam, ManyPairsAlignerOptions options) {
        if (options.density == 1.0) {
            return expFam.maxRecallAlignFromAllPairs(sequences);
        }
        return MSAPoset.maxRecallMSA(sequences, ManyPairsAligner.mostPairsPosterior(sequences, expFam, options));
    }

    public static Counter<GreedyDecoder.Edge> mostPairsPosterior(final Map<Taxon, String> sequences, final ExponentialFamily expFam, final ManyPairsAlignerOptions options) {
        final Counter<GreedyDecoder.Edge> edgePosteriors = new Counter<GreedyDecoder.Edge>();
        final int n = sequences.size();
        Set<UnorderedPair<Integer, Integer>> availableLinks = ManyPairsAligner.allEdges(n);
        Set<UnorderedPair<Integer, Integer>> selectedLinks = ManyPairsAligner.chain(n);
        availableLinks.removeAll(selectedLinks);
        int index = 0;
        for (UnorderedPair<Integer, Integer> link : availableLinks) {
            int n2 = index++;
            if (!((double)n2 < options.density * (double)MathUtils.nChoose2(n) - (double)n)) continue;
            selectedLinks.add(link);
        }
        final ArrayList<Taxon> taxa = CollUtils.list(sequences.keySet());
        Collections.shuffle(taxa, options.rand);
        LogInfo.track("Pair alignment");
        Parallelizer<UnorderedPair<Integer, Integer>> parallelizer = new Parallelizer<UnorderedPair<Integer, Integer>>(options.nThreads);
        parallelizer.setPrimaryThread();
        parallelizer.process(CollUtils.list(selectedLinks), new Parallelizer.Processor<UnorderedPair<Integer, Integer>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void process(UnorderedPair<Integer, Integer> link, int _i, int _n, boolean log) {
                if (log) {
                    LogInfo.logs("Pair " + _i + "/" + _n + " [reduced from " + MathUtils.nChoose2(n) + "]");
                }
                Taxon l1 = (Taxon)taxa.get(link.getFirst());
                Taxon l2 = (Taxon)taxa.get(link.getSecond());
                String s1 = (String)sequences.get(l1);
                String s2 = (String)sequences.get(l2);
                HetPairHMM hmm = expFam.getHMM(s1, s2, l1, l2);
                Counter counter = edgePosteriors;
                synchronized (counter) {
                    for (int p1 = 0; p1 < s1.length(); ++p1) {
                        for (int p2 = 0; p2 < s2.length(); ++p2) {
                            GreedyDecoder.Edge current = new GreedyDecoder.Edge(p1, p2, l1, l2);
                            double value = Math.exp(hmm.logPosteriorAlignment(p1, p2));
                            if (!(value > options.posteriorThreshold)) continue;
                            edgePosteriors.setCount(current, value);
                        }
                    }
                }
            }
        });
        LogInfo.end_track();
        return edgePosteriors;
    }

    private static Set<UnorderedPair<Integer, Integer>> chain(int n) {
        HashSet<UnorderedPair<Integer, Integer>> result = CollUtils.set();
        for (int i = 1; i < n; ++i) {
            result.add(new UnorderedPair<Integer, Integer>(i - 1, i));
        }
        return result;
    }

    private static Set<UnorderedPair<Integer, Integer>> allEdges(int n) {
        HashSet<UnorderedPair<Integer, Integer>> result = CollUtils.set();
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                result.add(new UnorderedPair<Integer, Integer>(j, i));
            }
        }
        return result;
    }

    public static class ManyPairsAlignerOptions {
        @Option
        public double density = 1.0;
        @Option
        public Random rand = new Random(1L);
        @Option
        public int nThreads = 1;
        @Option
        public double posteriorThreshold = 0.0;
    }
}

